/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.responses.MetadataObjectListResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.tag.Tag;

class GenericTag
implements Tag,
Tag.AssociatedObjects {
    private final TagDTO tagDTO;
    private final RESTClient restClient;
    private final String metalake;

    GenericTag(TagDTO tagDTO, RESTClient restClient, String metalake) {
        this.tagDTO = tagDTO;
        this.restClient = restClient;
        this.metalake = metalake;
    }

    @Override
    public String name() {
        return this.tagDTO.name();
    }

    @Override
    public String comment() {
        return this.tagDTO.comment();
    }

    @Override
    public Map<String, String> properties() {
        return this.tagDTO.properties();
    }

    @Override
    public Optional<Boolean> inherited() {
        return this.tagDTO.inherited();
    }

    @Override
    public Audit auditInfo() {
        return this.tagDTO.auditInfo();
    }

    @Override
    public Tag.AssociatedObjects associatedObjects() {
        return this;
    }

    @Override
    public MetadataObject[] objects() {
        MetadataObjectListResponse resp = this.restClient.get(String.format("api/metalakes/%s/tags/%s/objects", this.metalake, this.name()), MetadataObjectListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.getMetadataObjects();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericTag)) {
            return false;
        }
        GenericTag that = (GenericTag)obj;
        return this.tagDTO.equals(that.tagDTO);
    }

    public int hashCode() {
        return this.tagDTO.hashCode();
    }
}

