/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.enc;

import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.AbstractCryptoTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.kerby.kerberos.kerb.crypto.key.KeyMaker;

public abstract class AbstractEncTypeHandler
extends AbstractCryptoTypeHandler
implements EncTypeHandler {
    private int prfSize;
    private KeyMaker keyMaker;

    public AbstractEncTypeHandler(EncryptProvider encProvider, HashProvider hashProvider, int prfSize) {
        super(encProvider, hashProvider);
        this.prfSize = prfSize;
    }

    protected void keyMaker(KeyMaker keyMaker) {
        this.keyMaker = keyMaker;
    }

    protected KeyMaker keyMaker() {
        return this.keyMaker;
    }

    @Override
    public int prfSize() {
        return this.prfSize;
    }

    @Override
    public String name() {
        return this.eType().getName();
    }

    @Override
    public String displayName() {
        return this.eType().getDisplayName();
    }

    protected abstract int paddingLength(int var1);

    @Override
    public int keyInputSize() {
        return this.encProvider().keyInputSize();
    }

    @Override
    public int keySize() {
        return this.encProvider().keySize();
    }

    @Override
    public int confounderSize() {
        return this.encProvider().blockSize();
    }

    @Override
    public int checksumSize() {
        return this.hashProvider().hashSize();
    }

    @Override
    public int paddingSize() {
        return this.encProvider().blockSize();
    }

    @Override
    public byte[] str2key(String string, String salt, byte[] param) throws KrbException {
        return this.keyMaker.str2key(string, salt, param);
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        return this.keyMaker.random2Key(randomBits);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key, int usage) throws KrbException {
        byte[] iv = new byte[this.encProvider().blockSize()];
        return this.encrypt(data, key, iv, usage);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] key, byte[] iv, int usage) throws KrbException {
        int confounderLen = this.confounderSize();
        int checksumLen = this.checksumSize();
        int headerLen = confounderLen + checksumLen;
        int inputLen = data.length;
        int paddingLen = this.paddingLength(inputLen);
        int workLength = headerLen + inputLen + paddingLen;
        byte[] workBuffer = new byte[workLength];
        System.arraycopy(data, 0, workBuffer, headerLen, data.length);
        int[] workLens = new int[]{confounderLen, checksumLen, inputLen, paddingLen};
        this.encryptWith(workBuffer, workLens, key, iv, usage, false);
        return workBuffer;
    }

    @Override
    public byte[] encryptRaw(byte[] data, byte[] key, int usage) throws KrbException {
        byte[] iv = new byte[this.encProvider().blockSize()];
        return this.encryptRaw(data, key, iv, usage);
    }

    @Override
    public byte[] encryptRaw(byte[] data, byte[] key, byte[] iv, int usage) throws KrbException {
        int checksumLen = this.checksumSize();
        int[] workLens = new int[]{0, checksumLen, data.length, 0};
        byte[] workBuffer = new byte[data.length];
        System.arraycopy(data, 0, workBuffer, 0, data.length);
        this.encryptWith(workBuffer, workLens, key, iv, usage, true);
        return workBuffer;
    }

    protected void encryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage, boolean raw) throws KrbException {
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws KrbException {
        byte[] iv = new byte[this.encProvider().blockSize()];
        return this.decrypt(cipher, key, iv, usage);
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, byte[] iv, int usage) throws KrbException {
        int totalLen = cipher.length;
        int confounderLen = this.confounderSize();
        int checksumLen = this.checksumSize();
        int dataLen = totalLen - (confounderLen + checksumLen);
        int[] workLens = new int[]{confounderLen, checksumLen, dataLen};
        return this.decryptWith(cipher, workLens, key, iv, usage, false);
    }

    @Override
    public byte[] decryptRaw(byte[] cipher, byte[] key, int usage) throws KrbException {
        byte[] iv = new byte[this.encProvider().blockSize()];
        return this.decryptRaw(cipher, key, iv, usage);
    }

    @Override
    public byte[] decryptRaw(byte[] cipher, byte[] key, byte[] iv, int usage) throws KrbException {
        int checksumLen = this.checksumSize();
        int[] workLens = new int[]{0, checksumLen, cipher.length};
        return this.decryptWith(cipher, workLens, key, iv, usage, true);
    }

    protected byte[] decryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage, boolean raw) throws KrbException {
        return null;
    }
}

