/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;

class ReplicationWork {
    private final BlockInfo block;
    private final String srcPath;
    private final long blockSize;
    private final byte storagePolicyID;
    private final DatanodeDescriptor srcNode;
    private final int additionalReplRequired;
    private final int priority;
    private final List<DatanodeDescriptor> containingNodes;
    private final List<DatanodeStorageInfo> liveReplicaStorages;
    private DatanodeStorageInfo[] targets;

    public ReplicationWork(BlockInfo block, BlockCollection bc, DatanodeDescriptor srcNode, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority) {
        this.block = block;
        this.srcPath = bc.getName();
        this.blockSize = block.getNumBytes();
        this.storagePolicyID = bc.getStoragePolicyID();
        this.srcNode = srcNode;
        this.srcNode.incrementPendingReplicationWithoutTargets();
        this.containingNodes = containingNodes;
        this.liveReplicaStorages = liveReplicaStorages;
        this.additionalReplRequired = additionalReplRequired;
        this.priority = priority;
        this.targets = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chooseTargets(BlockPlacementPolicy blockplacement, BlockStoragePolicySuite storagePolicySuite, Set<Node> excludedNodes) {
        try {
            this.targets = blockplacement.chooseTarget(this.getSrcPath(), this.additionalReplRequired, (Node)this.srcNode, this.liveReplicaStorages, false, excludedNodes, this.blockSize, storagePolicySuite.getPolicy(this.getStoragePolicyID()), null);
        }
        finally {
            this.srcNode.decrementPendingReplicationWithoutTargets();
        }
    }

    DatanodeStorageInfo[] getTargets() {
        return this.targets;
    }

    void resetTargets() {
        this.targets = null;
    }

    List<DatanodeDescriptor> getContainingNodes() {
        return Collections.unmodifiableList(this.containingNodes);
    }

    public int getPriority() {
        return this.priority;
    }

    public BlockInfo getBlock() {
        return this.block;
    }

    public DatanodeDescriptor getSrcNode() {
        return this.srcNode;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public byte getStoragePolicyID() {
        return this.storagePolicyID;
    }
}

