/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Privileges;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialFactory;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.SchemaDTO;
import org.apache.gravitino.dto.authorization.GroupDTO;
import org.apache.gravitino.dto.authorization.OwnerDTO;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.dto.authorization.RoleDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.dto.authorization.UserDTO;
import org.apache.gravitino.dto.credential.CredentialDTO;
import org.apache.gravitino.dto.file.FilesetDTO;
import org.apache.gravitino.dto.messaging.TopicDTO;
import org.apache.gravitino.dto.model.ModelDTO;
import org.apache.gravitino.dto.model.ModelVersionDTO;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.DistributionDTO;
import org.apache.gravitino.dto.rel.SortOrderDTO;
import org.apache.gravitino.dto.rel.TableDTO;
import org.apache.gravitino.dto.rel.expressions.FieldReferenceDTO;
import org.apache.gravitino.dto.rel.expressions.FuncExpressionDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.dto.rel.expressions.UnparsedExpressionDTO;
import org.apache.gravitino.dto.rel.indexes.IndexDTO;
import org.apache.gravitino.dto.rel.partitioning.BucketPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.DayPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.FunctionPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.HourPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.IdentityPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.ListPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.MonthPartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.rel.partitioning.RangePartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.TruncatePartitioningDTO;
import org.apache.gravitino.dto.rel.partitioning.YearPartitioningDTO;
import org.apache.gravitino.dto.rel.partitions.IdentityPartitionDTO;
import org.apache.gravitino.dto.rel.partitions.ListPartitionDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.dto.rel.partitions.RangePartitionDTO;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.UnparsedExpression;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;
import org.apache.gravitino.rel.partitions.RangePartition;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.tag.Tag;

public class DTOConverters {
    private DTOConverters() {
    }

    public static AuditDTO toDTO(Audit audit) {
        return ((AuditDTO.Builder)((AuditDTO.Builder)((AuditDTO.Builder)((AuditDTO.Builder)AuditDTO.builder().withCreator(audit.creator())).withCreateTime(audit.createTime())).withLastModifier(audit.lastModifier())).withLastModifiedTime(audit.lastModifiedTime())).build();
    }

    public static OwnerDTO toDTO(Owner owner) {
        return OwnerDTO.builder().withName(owner.name()).withType(owner.type()).build();
    }

    public static MetalakeDTO toDTO(Metalake metalake) {
        return ((MetalakeDTO.Builder)((MetalakeDTO.Builder)((MetalakeDTO.Builder)((MetalakeDTO.Builder)MetalakeDTO.builder().withName(metalake.name())).withComment(metalake.comment())).withProperties(metalake.properties())).withAudit(DTOConverters.toDTO(metalake.auditInfo()))).build();
    }

    public static PartitionDTO toDTO(Partition partition) {
        if (partition instanceof RangePartition) {
            RangePartition rangePartition = (RangePartition)partition;
            return RangePartitionDTO.builder().withName(rangePartition.name()).withUpper((LiteralDTO)DTOConverters.toFunctionArg(rangePartition.upper())).withLower((LiteralDTO)DTOConverters.toFunctionArg(rangePartition.lower())).withProperties(rangePartition.properties()).build();
        }
        if (partition instanceof IdentityPartition) {
            IdentityPartition identityPartition = (IdentityPartition)partition;
            return IdentityPartitionDTO.builder().withName(identityPartition.name()).withFieldNames(identityPartition.fieldNames()).withValues((LiteralDTO[])Arrays.stream(identityPartition.values()).map(v -> (LiteralDTO)DTOConverters.toFunctionArg(v)).toArray(LiteralDTO[]::new)).withProperties(identityPartition.properties()).build();
        }
        if (partition instanceof ListPartition) {
            ListPartition listPartition = (ListPartition)partition;
            return ListPartitionDTO.builder().withName(listPartition.name()).withLists((LiteralDTO[][])Arrays.stream(listPartition.lists()).map(list -> (LiteralDTO[])Arrays.stream(list).map(v -> (LiteralDTO)DTOConverters.toFunctionArg(v)).toArray(LiteralDTO[]::new)).toArray(x$0 -> new LiteralDTO[x$0][])).withProperties(listPartition.properties()).build();
        }
        throw new IllegalArgumentException("Unsupported partition type: " + partition.getClass());
    }

    public static CatalogDTO toDTO(Catalog catalog) {
        return ((CatalogDTO.Builder)((CatalogDTO.Builder)((CatalogDTO.Builder)((CatalogDTO.Builder)((CatalogDTO.Builder)((CatalogDTO.Builder)CatalogDTO.builder().withName(catalog.name())).withType(catalog.type())).withProvider(catalog.provider())).withComment(catalog.comment())).withProperties(catalog.properties())).withAudit(DTOConverters.toDTO(catalog.auditInfo()))).build();
    }

    public static SchemaDTO toDTO(Schema schema) {
        return ((SchemaDTO.Builder)((SchemaDTO.Builder)((SchemaDTO.Builder)((SchemaDTO.Builder)SchemaDTO.builder().withName(schema.name())).withComment(schema.comment())).withProperties(schema.properties())).withAudit(DTOConverters.toDTO(schema.auditInfo()))).build();
    }

    public static ColumnDTO toDTO(Column column) {
        return ((ColumnDTO.Builder)((ColumnDTO.Builder)((ColumnDTO.Builder)((ColumnDTO.Builder)((ColumnDTO.Builder)((ColumnDTO.Builder)ColumnDTO.builder().withName(column.name())).withDataType(column.dataType())).withComment(column.comment())).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).withDefaultValue(column.defaultValue() == null || column.defaultValue().equals(Column.DEFAULT_VALUE_NOT_SET) ? Column.DEFAULT_VALUE_NOT_SET : DTOConverters.toFunctionArg(column.defaultValue()))).build();
    }

    public static TableDTO toDTO(Table table) {
        return ((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)((TableDTO.Builder)TableDTO.builder().withName(table.name())).withComment(table.comment())).withColumns((ColumnDTO[])Arrays.stream(table.columns()).map(DTOConverters::toDTO).toArray(ColumnDTO[]::new))).withProperties(table.properties())).withSortOrders(DTOConverters.toDTOs(table.sortOrder()))).withDistribution(DTOConverters.toDTO(table.distribution()))).withAudit(DTOConverters.toDTO(table.auditInfo()))).withPartitioning(DTOConverters.toDTOs(table.partitioning()))).withIndex(DTOConverters.toDTOs(table.index()))).build();
    }

    public static DistributionDTO toDTO(Distribution distribution) {
        if (Distributions.NONE.equals(distribution) || null == distribution) {
            return DistributionDTO.NONE;
        }
        if (distribution instanceof DistributionDTO) {
            return (DistributionDTO)distribution;
        }
        return DistributionDTO.builder().withStrategy(distribution.strategy()).withNumber(distribution.number()).withArgs((FunctionArg[])Arrays.stream(distribution.expressions()).map(DTOConverters::toFunctionArg).toArray(FunctionArg[]::new)).build();
    }

    public static SortOrderDTO toDTO(SortOrder sortOrder) {
        if (sortOrder instanceof SortOrderDTO) {
            return (SortOrderDTO)sortOrder;
        }
        return SortOrderDTO.builder().withSortTerm(DTOConverters.toFunctionArg(sortOrder.expression())).withDirection(sortOrder.direction()).withNullOrder(sortOrder.nullOrdering()).build();
    }

    public static Partitioning toDTO(Transform transform) {
        if (transform instanceof Partitioning) {
            return (Partitioning)transform;
        }
        if (transform instanceof Transform.SingleFieldTransform) {
            String[] fieldName = ((Transform.SingleFieldTransform)transform).fieldName();
            switch (transform.name()) {
                case "identity": {
                    return IdentityPartitioningDTO.of(fieldName);
                }
                case "year": {
                    return YearPartitioningDTO.of(fieldName);
                }
                case "month": {
                    return MonthPartitioningDTO.of(fieldName);
                }
                case "day": {
                    return DayPartitioningDTO.of(fieldName);
                }
                case "hour": {
                    return HourPartitioningDTO.of(fieldName);
                }
            }
            throw new IllegalArgumentException("Unsupported transform: " + transform.name());
        }
        if (transform instanceof Transforms.BucketTransform) {
            return BucketPartitioningDTO.of(((Transforms.BucketTransform)transform).numBuckets(), ((Transforms.BucketTransform)transform).fieldNames());
        }
        if (transform instanceof Transforms.TruncateTransform) {
            return TruncatePartitioningDTO.of(((Transforms.TruncateTransform)transform).width(), ((Transforms.TruncateTransform)transform).fieldName());
        }
        if (transform instanceof Transforms.ListTransform) {
            Transforms.ListTransform listTransform = (Transforms.ListTransform)transform;
            ListPartitionDTO[] assignments = (ListPartitionDTO[])Arrays.stream(listTransform.assignments()).map(DTOConverters::toDTO).toArray(ListPartitionDTO[]::new);
            return ListPartitioningDTO.of(listTransform.fieldNames(), assignments);
        }
        if (transform instanceof Transforms.RangeTransform) {
            Transforms.RangeTransform rangeTransform = (Transforms.RangeTransform)transform;
            RangePartitionDTO[] assignments = (RangePartitionDTO[])Arrays.stream(rangeTransform.assignments()).map(DTOConverters::toDTO).toArray(RangePartitionDTO[]::new);
            return RangePartitioningDTO.of(rangeTransform.fieldName(), assignments);
        }
        if (transform instanceof Transforms.ApplyTransform) {
            return FunctionPartitioningDTO.of(transform.name(), DTOConverters.toFunctionArg(transform.arguments()));
        }
        throw new IllegalArgumentException("Unsupported transform: " + transform.name());
    }

    public static IndexDTO toDTO(Index index) {
        if (index instanceof IndexDTO) {
            return (IndexDTO)index;
        }
        return ((IndexDTO.Builder)((IndexDTO.Builder)((IndexDTO.Builder)IndexDTO.builder().withIndexType(index.type())).withName(index.name())).withFieldNames(index.fieldNames())).build();
    }

    public static UserDTO toDTO(User user) {
        if (user instanceof UserDTO) {
            return (UserDTO)user;
        }
        return ((UserDTO.Builder)((UserDTO.Builder)((UserDTO.Builder)UserDTO.builder().withName(user.name())).withRoles(user.roles())).withAudit(DTOConverters.toDTO(user.auditInfo()))).build();
    }

    public static GroupDTO toDTO(Group group) {
        if (group instanceof GroupDTO) {
            return (GroupDTO)group;
        }
        return ((GroupDTO.Builder)((GroupDTO.Builder)((GroupDTO.Builder)GroupDTO.builder().withName(group.name())).withRoles(group.roles())).withAudit(DTOConverters.toDTO(group.auditInfo()))).build();
    }

    public static RoleDTO toDTO(Role role) {
        if (role instanceof RoleDTO) {
            return (RoleDTO)role;
        }
        return ((RoleDTO.Builder)((RoleDTO.Builder)((RoleDTO.Builder)((RoleDTO.Builder)RoleDTO.builder().withName(role.name())).withSecurableObjects((SecurableObjectDTO[])role.securableObjects().stream().map(DTOConverters::toDTO).toArray(SecurableObjectDTO[]::new))).withProperties(role.properties())).withAudit(DTOConverters.toDTO(role.auditInfo()))).build();
    }

    public static SecurableObjectDTO toDTO(SecurableObject securableObject) {
        if (securableObject instanceof SecurableObjectDTO) {
            return (SecurableObjectDTO)securableObject;
        }
        return SecurableObjectDTO.builder().withFullName(securableObject.fullName()).withType(securableObject.type()).withPrivileges((PrivilegeDTO[])securableObject.privileges().stream().map(DTOConverters::toDTO).toArray(PrivilegeDTO[]::new)).build();
    }

    public static PrivilegeDTO toDTO(Privilege privilege) {
        if (privilege instanceof PrivilegeDTO) {
            return (PrivilegeDTO)privilege;
        }
        return PrivilegeDTO.builder().withName(privilege.name()).withCondition(privilege.condition()).build();
    }

    public static MetadataObjectDTO toDTO(MetadataObject metadataObject) {
        return MetadataObjectDTO.builder().withParent(metadataObject.parent()).withName(metadataObject.name()).withType(metadataObject.type()).build();
    }

    public static TagDTO toDTO(Tag tag, Optional<Boolean> inherited) {
        TagDTO.Builder builder = TagDTO.builder().withName(tag.name()).withComment(tag.comment()).withProperties(tag.properties()).withAudit(DTOConverters.toDTO(tag.auditInfo())).withInherited(inherited);
        return builder.build();
    }

    public static CredentialDTO[] toDTO(Credential[] credentials) {
        return (CredentialDTO[])Arrays.stream(credentials).map(DTOConverters::toDTO).toArray(CredentialDTO[]::new);
    }

    public static CredentialDTO toDTO(Credential credential) {
        CredentialDTO.Builder builder = CredentialDTO.builder().withCredentialType(credential.credentialType()).withExpireTimeInMs(credential.expireTimeInMs()).withCredentialInfo(credential.credentialInfo());
        return builder.build();
    }

    public static FunctionArg toFunctionArg(Expression expression) {
        if (expression instanceof FunctionArg) {
            return (FunctionArg)expression;
        }
        if (expression instanceof Literal) {
            if (Literals.NULL.equals(expression)) {
                return LiteralDTO.NULL;
            }
            return LiteralDTO.builder().withValue(((Literal)expression).value().toString()).withDataType(((Literal)expression).dataType()).build();
        }
        if (expression instanceof NamedReference.FieldReference) {
            return FieldReferenceDTO.builder().withFieldName(((NamedReference.FieldReference)expression).fieldName()).build();
        }
        if (expression instanceof FunctionExpression) {
            return FuncExpressionDTO.builder().withFunctionName(((FunctionExpression)expression).functionName()).withFunctionArgs((FunctionArg[])Arrays.stream(((FunctionExpression)expression).arguments()).map(DTOConverters::toFunctionArg).toArray(FunctionArg[]::new)).build();
        }
        if (expression instanceof UnparsedExpression) {
            return UnparsedExpressionDTO.builder().withUnparsedExpression(((UnparsedExpression)expression).unparsedExpression()).build();
        }
        throw new IllegalArgumentException("Unsupported expression type: " + expression.getClass());
    }

    public static FunctionArg[] toFunctionArg(Expression[] expressions) {
        if (ArrayUtils.isEmpty(expressions)) {
            return FunctionArg.EMPTY_ARGS;
        }
        return (FunctionArg[])Arrays.stream(expressions).map(DTOConverters::toFunctionArg).toArray(FunctionArg[]::new);
    }

    public static FilesetDTO toDTO(Fileset fileset) {
        return FilesetDTO.builder().name(fileset.name()).comment(fileset.comment()).type(fileset.type()).storageLocation(fileset.storageLocation()).properties(fileset.properties()).audit(DTOConverters.toDTO(fileset.auditInfo())).build();
    }

    public static TopicDTO toDTO(Topic topic) {
        return TopicDTO.builder().withName(topic.name()).withComment(topic.comment()).withProperties(topic.properties()).withAudit(DTOConverters.toDTO(topic.auditInfo())).build();
    }

    public static ModelDTO toDTO(Model model) {
        return ModelDTO.builder().withName(model.name()).withComment(model.comment()).withProperties(model.properties()).withLatestVersion(model.latestVersion()).withAudit(DTOConverters.toDTO(model.auditInfo())).build();
    }

    public static ModelVersionDTO toDTO(ModelVersion modelVersion) {
        return ModelVersionDTO.builder().withVersion(modelVersion.version()).withComment(modelVersion.comment()).withAliases(modelVersion.aliases()).withUri(modelVersion.uri()).withProperties(modelVersion.properties()).withAudit(DTOConverters.toDTO(modelVersion.auditInfo())).build();
    }

    public static ColumnDTO[] toDTOs(Column[] columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return new ColumnDTO[0];
        }
        return (ColumnDTO[])Arrays.stream(columns).map(DTOConverters::toDTO).toArray(ColumnDTO[]::new);
    }

    public static SortOrderDTO[] toDTOs(SortOrder[] sortOrders) {
        if (ArrayUtils.isEmpty(sortOrders)) {
            return new SortOrderDTO[0];
        }
        return (SortOrderDTO[])Arrays.stream(sortOrders).map(DTOConverters::toDTO).toArray(SortOrderDTO[]::new);
    }

    public static Partitioning[] toDTOs(Transform[] transforms) {
        if (ArrayUtils.isEmpty(transforms)) {
            return new Partitioning[0];
        }
        return (Partitioning[])Arrays.stream(transforms).map(DTOConverters::toDTO).toArray(Partitioning[]::new);
    }

    public static IndexDTO[] toDTOs(Index[] indexes) {
        if (ArrayUtils.isEmpty(indexes)) {
            return IndexDTO.EMPTY_INDEXES;
        }
        return (IndexDTO[])Arrays.stream(indexes).map(DTOConverters::toDTO).toArray(IndexDTO[]::new);
    }

    public static PartitionDTO[] toDTOs(Partition[] partitions) {
        if (ArrayUtils.isEmpty(partitions)) {
            return new PartitionDTO[0];
        }
        return (PartitionDTO[])Arrays.stream(partitions).map(DTOConverters::toDTO).toArray(PartitionDTO[]::new);
    }

    public static CatalogDTO[] toDTOs(Catalog[] catalogs) {
        if (ArrayUtils.isEmpty(catalogs)) {
            return new CatalogDTO[0];
        }
        return (CatalogDTO[])Arrays.stream(catalogs).map(DTOConverters::toDTO).toArray(CatalogDTO[]::new);
    }

    public static UserDTO[] toDTOs(User[] users) {
        if (ArrayUtils.isEmpty(users)) {
            return new UserDTO[0];
        }
        return (UserDTO[])Arrays.stream(users).map(DTOConverters::toDTO).toArray(UserDTO[]::new);
    }

    public static GroupDTO[] toDTOs(Group[] groups) {
        if (ArrayUtils.isEmpty(groups)) {
            return new GroupDTO[0];
        }
        return (GroupDTO[])Arrays.stream(groups).map(DTOConverters::toDTO).toArray(GroupDTO[]::new);
    }

    public static Distribution fromDTO(DistributionDTO distributionDTO) {
        if (DistributionDTO.NONE.equals(distributionDTO) || null == distributionDTO) {
            return Distributions.NONE;
        }
        return Distributions.of(distributionDTO.strategy(), distributionDTO.number(), DTOConverters.fromFunctionArgs(distributionDTO.args()));
    }

    public static Expression[] fromFunctionArgs(FunctionArg[] args) {
        if (ArrayUtils.isEmpty(args)) {
            return Expression.EMPTY_EXPRESSION;
        }
        return (Expression[])Arrays.stream(args).map(DTOConverters::fromFunctionArg).toArray(Expression[]::new);
    }

    public static Expression fromFunctionArg(FunctionArg arg) {
        switch (arg.argType()) {
            case LITERAL: {
                if (((LiteralDTO)arg).value() == null || ((LiteralDTO)arg).dataType().equals(Types.NullType.get())) {
                    return Literals.NULL;
                }
                return Literals.of(((LiteralDTO)arg).value(), ((LiteralDTO)arg).dataType());
            }
            case FIELD: {
                return NamedReference.field(((FieldReferenceDTO)arg).fieldName());
            }
            case FUNCTION: {
                return FunctionExpression.of(((FuncExpressionDTO)arg).functionName(), DTOConverters.fromFunctionArgs(((FuncExpressionDTO)arg).args()));
            }
            case UNPARSED: {
                return UnparsedExpression.of(((UnparsedExpressionDTO)arg).unparsedExpression());
            }
        }
        throw new IllegalArgumentException("Unsupported expression type: " + arg.getClass());
    }

    public static Index fromDTO(IndexDTO indexDTO) {
        return Indexes.of(indexDTO.type(), indexDTO.name(), indexDTO.fieldNames());
    }

    public static Index[] fromDTOs(IndexDTO[] indexDTOs) {
        if (ArrayUtils.isEmpty(indexDTOs)) {
            return Indexes.EMPTY_INDEXES;
        }
        return (Index[])Arrays.stream(indexDTOs).map(DTOConverters::fromDTO).toArray(Index[]::new);
    }

    public static Partition fromDTO(PartitionDTO partitionDTO) {
        switch (partitionDTO.type()) {
            case IDENTITY: {
                IdentityPartitionDTO identityPartitionDTO = (IdentityPartitionDTO)partitionDTO;
                Literal[] values = (Literal[])Arrays.stream(identityPartitionDTO.values()).map(DTOConverters::fromFunctionArg).toArray(Literal[]::new);
                return Partitions.identity(identityPartitionDTO.name(), identityPartitionDTO.fieldNames(), values, identityPartitionDTO.properties());
            }
            case RANGE: {
                RangePartitionDTO rangePartitionDTO = (RangePartitionDTO)partitionDTO;
                return Partitions.range(rangePartitionDTO.name(), (Literal)DTOConverters.fromFunctionArg(rangePartitionDTO.upper()), (Literal)DTOConverters.fromFunctionArg(rangePartitionDTO.lower()), rangePartitionDTO.properties());
            }
            case LIST: {
                ListPartitionDTO listPartitionDTO = (ListPartitionDTO)partitionDTO;
                Literal[][] lists = (Literal[][])Arrays.stream(listPartitionDTO.lists()).map(list -> (Literal[])Arrays.stream(list).map(DTOConverters::fromFunctionArg).toArray(Literal[]::new)).toArray(x$0 -> new Literal[x$0][]);
                return Partitions.list(listPartitionDTO.name(), lists, listPartitionDTO.properties());
            }
        }
        throw new IllegalArgumentException("Unsupported partition type: " + (Object)((Object)partitionDTO.type()));
    }

    public static SortOrder fromDTO(SortOrderDTO sortOrderDTO) {
        return SortOrders.of(DTOConverters.fromFunctionArg(sortOrderDTO.sortTerm()), sortOrderDTO.direction(), sortOrderDTO.nullOrdering());
    }

    public static SortOrder[] fromDTOs(SortOrderDTO[] sortOrderDTO) {
        if (ArrayUtils.isEmpty(sortOrderDTO)) {
            return SortOrders.NONE;
        }
        return (SortOrder[])Arrays.stream(sortOrderDTO).map(DTOConverters::fromDTO).toArray(SortOrder[]::new);
    }

    public static Transform[] fromDTOs(Partitioning[] partitioning) {
        if (ArrayUtils.isEmpty(partitioning)) {
            return Transforms.EMPTY_TRANSFORM;
        }
        return (Transform[])Arrays.stream(partitioning).map(DTOConverters::fromDTO).toArray(Transform[]::new);
    }

    public static Column[] fromDTOs(ColumnDTO[] columns) {
        if (ArrayUtils.isEmpty(columns)) {
            return new Column[0];
        }
        return (Column[])Arrays.stream(columns).map(DTOConverters::fromDTO).toArray(Column[]::new);
    }

    public static Credential[] fromDTO(CredentialDTO[] credentials) {
        if (ArrayUtils.isEmpty(credentials)) {
            return new Credential[0];
        }
        return (Credential[])Arrays.stream(credentials).map(DTOConverters::fromDTO).toArray(Credential[]::new);
    }

    public static Credential fromDTO(CredentialDTO credential) {
        return CredentialFactory.create(credential.credentialType(), credential.credentialInfo(), credential.expireTimeInMs());
    }

    public static Column fromDTO(ColumnDTO column) {
        if (column.defaultValue().equals(Column.DEFAULT_VALUE_NOT_SET)) {
            return column;
        }
        return Column.of(column.name(), column.dataType(), column.comment(), column.nullable(), column.autoIncrement(), DTOConverters.fromFunctionArg((FunctionArg)column.defaultValue()));
    }

    public static Table fromDTO(final TableDTO tableDTO) {
        return new Table(){

            @Override
            public String name() {
                return tableDTO.name();
            }

            @Override
            public Column[] columns() {
                return DTOConverters.fromDTOs((ColumnDTO[])tableDTO.columns());
            }

            @Override
            public Transform[] partitioning() {
                return DTOConverters.fromDTOs((Partitioning[])tableDTO.partitioning());
            }

            @Override
            public SortOrder[] sortOrder() {
                return DTOConverters.fromDTOs((SortOrderDTO[])tableDTO.sortOrder());
            }

            @Override
            public Distribution distribution() {
                return DTOConverters.fromDTO((DistributionDTO)tableDTO.distribution());
            }

            @Override
            public Index[] index() {
                return DTOConverters.fromDTOs((IndexDTO[])tableDTO.index());
            }

            @Override
            public String comment() {
                return tableDTO.comment();
            }

            @Override
            public Map<String, String> properties() {
                return tableDTO.properties();
            }

            @Override
            public Audit auditInfo() {
                return tableDTO.auditInfo();
            }
        };
    }

    public static Transform fromDTO(Partitioning partitioning) {
        switch (partitioning.strategy()) {
            case IDENTITY: {
                return Transforms.identity(((Partitioning.SingleFieldPartitioning)partitioning).fieldName());
            }
            case YEAR: {
                return Transforms.year(((Partitioning.SingleFieldPartitioning)partitioning).fieldName());
            }
            case MONTH: {
                return Transforms.month(((Partitioning.SingleFieldPartitioning)partitioning).fieldName());
            }
            case DAY: {
                return Transforms.day(((Partitioning.SingleFieldPartitioning)partitioning).fieldName());
            }
            case HOUR: {
                return Transforms.hour(((Partitioning.SingleFieldPartitioning)partitioning).fieldName());
            }
            case BUCKET: {
                return Transforms.bucket(((BucketPartitioningDTO)partitioning).numBuckets(), ((BucketPartitioningDTO)partitioning).fieldNames());
            }
            case TRUNCATE: {
                return Transforms.truncate(((TruncatePartitioningDTO)partitioning).width(), ((TruncatePartitioningDTO)partitioning).fieldName());
            }
            case LIST: {
                ListPartitioningDTO listPartitioningDTO = (ListPartitioningDTO)partitioning;
                ListPartition[] listPartitions = (ListPartition[])Arrays.stream(listPartitioningDTO.assignments()).map(p -> (ListPartition)DTOConverters.fromDTO(p)).toArray(ListPartition[]::new);
                return Transforms.list(listPartitioningDTO.fieldNames(), listPartitions);
            }
            case RANGE: {
                RangePartitioningDTO rangePartitioningDTO = (RangePartitioningDTO)partitioning;
                RangePartition[] rangePartitions = (RangePartition[])Arrays.stream(rangePartitioningDTO.assignments()).map(p -> (RangePartition)DTOConverters.fromDTO(p)).toArray(RangePartition[]::new);
                return Transforms.range(rangePartitioningDTO.fieldName(), rangePartitions);
            }
            case FUNCTION: {
                return Transforms.apply(((FunctionPartitioningDTO)partitioning).functionName(), DTOConverters.fromFunctionArgs(((FunctionPartitioningDTO)partitioning).args()));
            }
        }
        throw new IllegalArgumentException("Unsupported partitioning: " + (Object)((Object)partitioning.strategy()));
    }

    public static Privilege fromPrivilegeDTO(PrivilegeDTO privilegeDTO) {
        if (privilegeDTO.condition().equals((Object)Privilege.Condition.ALLOW)) {
            return Privileges.allow(privilegeDTO.name());
        }
        return Privileges.deny(privilegeDTO.name());
    }
}

