/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter.reactive;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerHttpObservationDocumentation;
import org.springframework.http.server.reactive.observation.ServerRequestObservationContext;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.observability.DefaultSignalListener;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@Deprecated(since="6.1", forRemoval=true)
public class ServerHttpObservationFilter
implements WebFilter {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = ServerHttpObservationFilter.class.getName() + ".context";
    private static final ServerRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultServerRequestObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ServerRequestObservationConvention observationConvention;

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, DEFAULT_OBSERVATION_CONVENTION);
    }

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry, ServerRequestObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public static Optional<ServerRequestObservationContext> findObservationContext(ServerWebExchange exchange2) {
        return Optional.ofNullable((ServerRequestObservationContext)((Object)exchange2.getAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE)));
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        ServerRequestObservationContext observationContext = new ServerRequestObservationContext(exchange2.getRequest(), exchange2.getResponse(), exchange2.getAttributes());
        exchange2.getAttributes().put(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, (Object)observationContext);
        return chain.filter(exchange2).tap(() -> new ObservationSignalListener(observationContext));
    }

    private final class ObservationSignalListener
    extends DefaultSignalListener<Void> {
        private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException");
        private final ServerRequestObservationContext observationContext;
        private final Observation observation;
        private final AtomicBoolean observationRecorded = new AtomicBoolean();

        ObservationSignalListener(ServerRequestObservationContext observationContext) {
            this.observationContext = observationContext;
            this.observation = ServerHttpObservationDocumentation.HTTP_REACTIVE_SERVER_REQUESTS.observation(ServerHttpObservationFilter.this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, ServerHttpObservationFilter.this.observationRegistry);
        }

        public Context addToContext(Context originalContext) {
            return originalContext.put((Object)"micrometer.observation", (Object)this.observation);
        }

        public void doFirst() throws Throwable {
            this.observation.start();
        }

        public void doOnCancel() throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                this.observationContext.setConnectionAborted(true);
                this.observation.stop();
            }
        }

        public void doOnComplete() throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                this.doOnTerminate(this.observationContext);
            }
        }

        public void doOnError(Throwable error) throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                if (DISCONNECTED_CLIENT_EXCEPTIONS.contains(error.getClass().getSimpleName())) {
                    this.observationContext.setConnectionAborted(true);
                }
                this.observationContext.setError(error);
                this.doOnTerminate(this.observationContext);
            }
        }

        private void doOnTerminate(ServerRequestObservationContext context) {
            ServerHttpResponse response = (ServerHttpResponse)context.getResponse();
            if (response != null) {
                if (response.isCommitted()) {
                    this.observation.stop();
                } else {
                    response.beforeCommit(() -> {
                        this.observation.stop();
                        return Mono.empty();
                    });
                }
            }
        }
    }
}

