/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataPad
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 2443487622598511815L;
    private final byte[] pad;

    public static RadiotapDataPad newInstance(byte[] pad, int offset, int length) {
        ByteArrays.validateBounds(pad, offset, length);
        return new RadiotapDataPad(pad, offset, length);
    }

    private RadiotapDataPad(byte[] pad, int offset, int length) {
        this.pad = ByteArrays.getSubArray(pad, offset, length);
    }

    private RadiotapDataPad(Builder builder) {
        if (builder == null || builder.pad == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.pad: ").append(builder.pad);
            throw new NullPointerException(sb.toString());
        }
        this.pad = ByteArrays.clone(builder.pad);
    }

    @Override
    public int length() {
        return this.pad.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.pad);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Pad: ").append(ls).append(indent).append("  data: ").append(ByteArrays.toHexString(this.pad, " ")).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.pad);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataPad other = (RadiotapDataPad)obj;
        return Arrays.equals(this.pad, other.pad);
    }

    public static final class Builder {
        private byte[] pad;

        public Builder() {
        }

        private Builder(RadiotapDataPad obj) {
            this.pad = obj.pad;
        }

        public Builder pad(byte[] pad) {
            this.pad = pad;
            return this;
        }

        public RadiotapDataPad build() {
            return new RadiotapDataPad(this);
        }
    }
}

