/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@FunctionalInterface
public interface ClickHouseSerializer {
    public static final ClickHouseSerializer DO_NOTHING = (v, o) -> {};
    public static final ClickHouseSerializer NOT_SUPPORTED = (v, o) -> {
        throw new IOException("Serialization is not supported");
    };
    public static final String TYPE_NAME = "Serializer";

    public static ClickHouseSerializer of(ClickHouseSerializer first, ClickHouseSerializer ... more) {
        LinkedList<ClickHouseSerializer> list = new LinkedList<ClickHouseSerializer>();
        if (first != null) {
            list.add(first);
        }
        if (more != null) {
            for (ClickHouseSerializer s : more) {
                if (s == null) continue;
                list.add(s);
            }
        }
        if (list.isEmpty()) {
            return DO_NOTHING;
        }
        return new CompositeSerializer(list.toArray(new ClickHouseSerializer[0]));
    }

    public static ClickHouseSerializer of(List<ClickHouseSerializer> list) {
        if (list == null) {
            return DO_NOTHING;
        }
        Iterator<ClickHouseSerializer> it = list.iterator();
        while (it.hasNext()) {
            ClickHouseSerializer s = it.next();
            if (s != null) continue;
            it.remove();
        }
        return list.isEmpty() ? DO_NOTHING : new CompositeSerializer(list.toArray(new ClickHouseSerializer[0]));
    }

    public void serialize(ClickHouseValue var1, ClickHouseOutputStream var2) throws IOException;

    public static class CompositeSerializer
    implements ClickHouseSerializer {
        protected final ClickHouseSerializer[] serializers;

        protected CompositeSerializer(ClickHouseSerializer[] serializers) {
            this.serializers = serializers;
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            int len = this.serializers.length;
            for (int i = 0; i < len; ++i) {
                this.serializers[i].serialize(value, output);
            }
        }
    }
}

