/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.MethodExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.QueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyMethodExecutionListener;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyMethodExecutionListenerAdapter;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CompositeProxyExecutionListener
implements ProxyExecutionListener {
    private final List<ProxyExecutionListener> listeners = new ArrayList<ProxyExecutionListener>();

    public CompositeProxyExecutionListener(ProxyExecutionListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    @Override
    public void beforeMethod(MethodExecutionInfo executionInfo) {
        this.listeners.forEach(listener -> listener.beforeMethod(executionInfo));
    }

    @Override
    public void afterMethod(MethodExecutionInfo executionInfo) {
        this.listeners.forEach(listener -> listener.afterMethod(executionInfo));
    }

    @Override
    public void beforeQuery(QueryExecutionInfo execInfo) {
        this.listeners.forEach(listener -> listener.beforeQuery(execInfo));
    }

    @Override
    public void afterQuery(QueryExecutionInfo execInfo) {
        this.listeners.forEach(listener -> listener.afterQuery(execInfo));
    }

    @Override
    public void eachQueryResult(QueryExecutionInfo execInfo) {
        this.listeners.forEach(listener -> listener.eachQueryResult(execInfo));
    }

    public boolean add(ProxyExecutionListener listener) {
        Assert.requireNonNull(listener, "listener must not be null");
        if (listener instanceof ProxyMethodExecutionListener) {
            return this.listeners.add(new ProxyMethodExecutionListenerAdapter((ProxyMethodExecutionListener)listener));
        }
        return this.listeners.add(listener);
    }

    public boolean addAll(Collection<ProxyExecutionListener> listeners) {
        Assert.requireNonNull(listeners, "listeners must not be null");
        boolean result = false;
        for (ProxyExecutionListener listener : listeners) {
            result |= this.add(listener);
        }
        return result;
    }

    public List<ProxyExecutionListener> getListeners() {
        return this.listeners;
    }
}

