/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.kafka;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.stream.job.LogDataTransfer;
import org.apache.ozhera.log.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerRunner.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final KafkaConsumer consumer;
    private final LogDataTransfer handleMessage;

    public KafkaConsumerRunner(KafkaConsumer consumer, LogDataTransfer handleMessage) {
        this.consumer = consumer;
        this.handleMessage = handleMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.closed.get()) {
                try {
                    ConsumerRecords records = this.consumer.poll(1000L);
                    for (ConsumerRecord record : records) {
                        if (!StringUtils.equals((CharSequence)((CharSequence)record.key()), (CharSequence)this.handleMessage.getSinkJobConfig().getTag())) continue;
                        log.debug("Thread:{} Consume partition:{} offset:{},message:{}", new Object[]{Thread.currentThread().getName(), record.partition(), record.offset(), record.value()});
                        String time = DateUtils.getTime();
                        String msg = (String)record.value();
                        this.handleMessage.handleMessage(MQSourceEnum.KAFKA.getName(), msg, time);
                    }
                }
                catch (Exception e) {
                    log.error("kafka consumer error", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("KafkaConsumerRunner send exception", (Throwable)e);
        }
        finally {
            this.consumer.close();
        }
    }

    public void shutdown() {
        this.closed.set(true);
        this.consumer.close(20L, TimeUnit.SECONDS);
    }
}

