/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.bo.MvcConfig;
import com.xiaomi.youpin.docean.common.MethodInvoker;
import com.xiaomi.youpin.docean.common.NamedThreadFactory;
import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.exception.DoceanException;
import com.xiaomi.youpin.docean.listener.event.Event;
import com.xiaomi.youpin.docean.listener.event.EventType;
import com.xiaomi.youpin.docean.mvc.Get;
import com.xiaomi.youpin.docean.mvc.HttpRequestMethod;
import com.xiaomi.youpin.docean.mvc.HttpResponseUtils;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import com.xiaomi.youpin.docean.mvc.MvcRequest;
import com.xiaomi.youpin.docean.mvc.MvcResponse;
import com.xiaomi.youpin.docean.mvc.MvcResult;
import com.xiaomi.youpin.docean.mvc.MvcRunnable;
import com.xiaomi.youpin.docean.mvc.MvcServlet;
import com.xiaomi.youpin.docean.mvc.Post;
import com.xiaomi.youpin.docean.mvc.util.ExceptionUtil;
import com.xiaomi.youpin.docean.mvc.util.GsonUtils;
import com.xiaomi.youpin.docean.mvc.util.Jump;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mvc {
    private static final Logger log = LoggerFactory.getLogger(Mvc.class);
    private ExecutorService executor;
    private ConcurrentHashMap<String, HttpRequestMethod> requestMethodMap = new ConcurrentHashMap();
    private Ioc ioc;
    private static Gson gson = new Gson();
    private MvcConfig mvcConfig = new MvcConfig();
    private MethodInvoker methodInvoker = new MethodInvoker();
    private String name = "mvc";

    private Mvc(Ioc ioc) {
        this.ioc = ioc;
        this.name = this.ioc.getName();
        this.setConfig(ioc);
        this.executor = this.createPool();
        this.initHttpRequestMethod();
    }

    private void setConfig(Ioc ioc) {
        this.mvcConfig.setAllowCross(Boolean.valueOf((String)ioc.getBean("$allow-cross-domain", "false")));
        this.mvcConfig.setDownload(Boolean.valueOf((String)ioc.getBean("$mvc-download", "false")));
        this.mvcConfig.setUseCglib(Boolean.valueOf((String)ioc.getBean("$cglib", "true")));
        this.mvcConfig.setOpenStaticFile(Boolean.valueOf((String)ioc.getBean("$openStaticFile", "false")));
        this.mvcConfig.setStaticFilePath((String)ioc.getBean("$staticFilePath", ""));
        this.mvcConfig.setResponseOriginalValue(Boolean.valueOf((String)ioc.getBean("$response-original-value", "false")));
        this.mvcConfig.setPoolSize(Integer.valueOf((String)ioc.getBean("$mvc-pool-size", String.valueOf(200))));
        this.mvcConfig.setVirtualThread(Boolean.valueOf((String)ioc.getBean("$virtual-threaad", "true")));
        this.mvcConfig.setResponseOriginalPath((String)ioc.getBean("$response-original-path", ""));
        ioc.publishEvent(new Event(EventType.mvcBegin, this.mvcConfig));
    }

    private ExecutorService createPool() {
        if (this.mvcConfig.isVirtualThread()) {
            return Executors.newVirtualThreadPerTaskExecutor();
        }
        return new ThreadPoolExecutor(this.mvcConfig.getPoolSize(), this.mvcConfig.getPoolSize(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(HttpServerConfig.HTTP_POOL_QUEUE_SIZE), new NamedThreadFactory("docean_mvc"));
    }

    private void initHttpRequestMethod() {
        this.ioc.beans().entrySet().stream().forEach(entry -> {
            Bean bean = (Bean)entry.getValue();
            if (bean.getType() == Bean.Type.controller.ordinal()) {
                this.registerControllerMethods(bean);
            }
            if (bean.getObj() instanceof MvcServlet) {
                this.initializeControllerMapping(bean);
            }
        });
        this.ioc.publishEvent(new Event(EventType.initControllerFinish, this.requestMethodMap));
        log.info("requestMethodMap size:{}", (Object)this.requestMethodMap.size());
    }

    private void initializeControllerMapping(Bean bean) {
        MvcServlet ms = (MvcServlet)bean.getObj();
        String path = ms.path();
        HttpRequestMethod hrm = new HttpRequestMethod();
        hrm.setPath(path);
        hrm.setObj(ms);
        hrm.setHttpMethod(ms.method());
        Safe.runAndLog(() -> hrm.setMethod(ms.getClass().getMethod("execute", Object.class)));
        this.ioc.publishEvent(new Event(EventType.initController, path));
        this.requestMethodMap.put(path, hrm);
    }

    private void registerControllerMethods(Bean bean) {
        Arrays.stream(bean.getClazz().getMethods()).forEach(m -> Optional.ofNullable(m.getAnnotation(RequestMapping.class)).ifPresent(rm -> {
            RequestMapping classMapping = bean.getClazz().getAnnotation(RequestMapping.class);
            Object path = rm.path();
            if (Optional.ofNullable(classMapping).isPresent()) {
                path = classMapping.path() + (String)path;
            }
            HttpRequestMethod hrm = new HttpRequestMethod();
            hrm.setTimeout(rm.timeout());
            hrm.setOriginalRes(rm.originalRes());
            hrm.setPath((String)path);
            hrm.setObj(bean.getObj());
            hrm.setMethod((Method)m);
            hrm.setHttpMethod(rm.method());
            hrm.setGenericSuperclassTypeArguments(Mvc.getGenericSuperclassTypeArguments(bean.getClazz()));
            this.ioc.publishEvent(new Event(EventType.initController, path));
            this.requestMethodMap.put((String)path, hrm);
        }));
    }

    public static Map<String, Class> getGenericSuperclassTypeArguments(Class clazz) {
        List list = Arrays.stream(clazz.getSuperclass().getTypeParameters()).map(it -> it.getName()).collect(Collectors.toList());
        if (list.size() == 0) {
            return Maps.newHashMap();
        }
        HashMap<String, Class> map = new HashMap<String, Class>();
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type argument = typeArguments[i];
                if (!(argument instanceof Class)) continue;
                map.put((String)list.get(i), (Class)argument);
            }
        }
        return map;
    }

    public static final Mvc ins() {
        return LazyHolder.ins;
    }

    public static final Mvc create(Ioc ioc) {
        return new Mvc(ioc);
    }

    public void dispatcher(MvcContext context, MvcRequest request, MvcResponse response) {
        context.setAllowCross(this.mvcConfig.isAllowCross());
        if (context.isSync()) {
            new MvcRunnable(this, context, request, response, this.requestMethodMap).run();
        } else {
            this.executor.submit(new MvcRunnable(this, context, request, response, this.requestMethodMap));
        }
    }

    public void dispatcher(HttpServerConfig config, ChannelHandlerContext ctx, FullHttpRequest httpRequest, String uri, byte[] body) {
        this.executor.submit(new MvcRunnable(this, config, ctx, httpRequest, uri, body, this.requestMethodMap));
    }

    public void callService(MvcContext context, MvcRequest request, MvcResponse response) {
        MvcRequest req = (MvcRequest)gson.fromJson(new String(request.getBody()), MvcRequest.class);
        request.setServiceName(req.getServiceName());
        request.setMethodName(req.getMethodName());
        request.setArguments(req.getArguments());
        Object controller = this.ioc.getBean(request.getServiceName());
        Object[] params = this.methodInvoker.getMethodParams(controller, request.getMethodName(), request.getArguments());
        MvcServlet ms = (MvcServlet)controller;
        HttpRequestMethod method = this.requestMethodMap.get(ms.path());
        Object res = this.mvcConfig.isUseCglib() ? this.methodInvoker.invokeFastMethod(controller, controller.getClass(), request.getMethodName(), params) : this.methodInvoker.invokeMethod(controller, method.getMethod(), params);
        MvcResult<Object> mr = new MvcResult<Object>();
        mr.setData(res);
        response.writeAndFlush(context, new Gson().toJson(mr));
    }

    public List<Class> mapMethodParametersToClasses(Method method, Map<String, Class> map) {
        return Arrays.stream(method.getParameters()).map(it -> {
            String name = it.getParameterizedType().getTypeName();
            if (it.getType() instanceof Object && map.containsKey(name)) {
                return (Class)map.get(name);
            }
            return it.getType();
        }).collect(Collectors.toList());
    }

    public void callMethod(MvcContext context, MvcRequest request, MvcResponse response, MvcResult<Object> result, HttpRequestMethod method) {
        Safe.run(() -> {
            Object[] params = this.getMethodParams(context, request, method);
            Object data = this.invokeControllerMethod(method, params);
            if (context.isSync()) {
                context.setResponse(data);
                return;
            }
            if (data instanceof MvcResult) {
                MvcResult mr = (MvcResult)data;
                if (mr.getCode() == -999) {
                    return;
                }
                if (mr.getCode() == HttpResponseStatus.FOUND.code()) {
                    Jump.jump(response, (String)mr.getData());
                    return;
                }
            }
            if (data instanceof FullHttpResponse) {
                FullHttpResponse res = (FullHttpResponse)data;
                response.getCtx().writeAndFlush((Object)HttpResponseUtils.create(res));
                return;
            }
            boolean needOriginalValue = this.isNeedOriginalValue(method);
            if (needOriginalValue) {
                String responseData = data instanceof String ? (String)data : gson.toJson(data);
                response.writeAndFlush(context, responseData);
            } else {
                result.setData(data);
                response.writeAndFlush(context, gson.toJson((Object)result));
            }
        }, ex -> {
            DoceanException de;
            int code;
            if (context.isSync()) {
                context.setResponse(ex);
                return;
            }
            ex = Throwables.getRootCause((Throwable)ex);
            Throwable unwrapThrowable = ExceptionUtil.unwrapThrowable(ex);
            result.setCode(500);
            int httpCode = 200;
            if (ex instanceof DoceanException && 0 != (code = (de = (DoceanException)ex).getCode())) {
                result.setCode(code);
                httpCode = code;
            }
            result.setMessage(unwrapThrowable.getMessage());
            response.writeAndFlush(context, gson.toJson((Object)result), httpCode);
        });
    }

    private boolean isNeedOriginalValue(HttpRequestMethod method) {
        if (method.isOriginalRes()) {
            return true;
        }
        boolean needOriginalValue = this.mvcConfig.isResponseOriginalValue();
        if (!needOriginalValue && StringUtils.isNotBlank(this.mvcConfig.getResponseOriginalPath())) {
            needOriginalValue = Arrays.stream(this.mvcConfig.getResponseOriginalPath().split(",")).anyMatch(i -> i.equals(method.getPath()));
        }
        return needOriginalValue;
    }

    private Object[] getMethodParams(MvcContext context, MvcRequest request, HttpRequestMethod method) {
        Object[] params = new Object[]{null};
        if (context.isWebsocket()) {
            params[0] = new String(request.getBody());
            return params;
        }
        if (Mvc.isSingleStringParameterMethod(method) && request.getMethod().toUpperCase().equals("POST")) {
            params[0] = new String(request.getBody());
        } else {
            JsonElement args = this.getArgs(method, request.getMethod().toLowerCase(Locale.ROOT), request, context);
            if (Mvc.isSingleMvcContextParameterMethod(method)) {
                params[0] = context;
            } else {
                try {
                    Class[] types = this.getClasses(method);
                    params = this.methodInvoker.getMethodParams(args, types, name -> {
                        Object obj = context.session().getAttribute((String)name);
                        if (null == obj) {
                            throw new DoceanException("You are required to log in first.", 401);
                        }
                        return obj;
                    });
                }
                catch (DoceanException doceanException) {
                    throw doceanException;
                }
                catch (Exception e) {
                    log.error("getMethodParams error,path:{},params:{},method:{}", new Object[]{context.getPath(), GsonUtils.gson.toJson(context.getParams()), request.getMethod().toLowerCase(Locale.ROOT), e});
                }
            }
        }
        return params;
    }

    private Class[] getClasses(HttpRequestMethod method) {
        List<Class> list = this.mapMethodParametersToClasses(method.getMethod(), method.getGenericSuperclassTypeArguments());
        Class[] types = list.toArray(new Class[0]);
        return types;
    }

    private Object invokeControllerMethod(HttpRequestMethod method, Object[] params) {
        Object data = this.mvcConfig.isUseCglib() ? this.methodInvoker.invokeFastMethod(method.getObj(), method.getMethod(), params) : this.methodInvoker.invokeMethod(method.getObj(), method.getMethod(), params);
        return data;
    }

    private static boolean isSingleMvcContextParameterMethod(HttpRequestMethod method) {
        return method.getMethod().getParameterTypes().length == 1 && method.getMethod().getParameterTypes()[0].equals(MvcContext.class);
    }

    private static boolean isSingleStringParameterMethod(HttpRequestMethod method) {
        return method.getMethod().getParameterTypes().length == 1 && method.getMethod().getParameterTypes()[0].equals(String.class);
    }

    private JsonElement getArgs(HttpRequestMethod method, String httpMethod, MvcRequest req, MvcContext context) {
        if (httpMethod.equalsIgnoreCase("get")) {
            return Get.getParams(method, req.getUri(), context);
        }
        if (httpMethod.equalsIgnoreCase("post")) {
            return Post.getParams(method, req.getBody(), context);
        }
        throw new DoceanException("don't support:" + httpMethod);
    }

    private void setMvcContext(MvcContext context, Object[] params) {
        if (params.length > 0 && null != params[0] && params[0].getClass() == MvcContext.class) {
            params[0] = context;
        }
    }

    public void destory() {
        this.methodInvoker.clear();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ConcurrentHashMap<String, HttpRequestMethod> getRequestMethodMap() {
        return this.requestMethodMap;
    }

    public Ioc getIoc() {
        return this.ioc;
    }

    public MvcConfig getMvcConfig() {
        return this.mvcConfig;
    }

    public MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    public String getName() {
        return this.name;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setRequestMethodMap(ConcurrentHashMap<String, HttpRequestMethod> requestMethodMap) {
        this.requestMethodMap = requestMethodMap;
    }

    public void setIoc(Ioc ioc) {
        this.ioc = ioc;
    }

    public void setMvcConfig(MvcConfig mvcConfig) {
        this.mvcConfig = mvcConfig;
    }

    public void setMethodInvoker(MethodInvoker methodInvoker) {
        this.methodInvoker = methodInvoker;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mvc)) {
            return false;
        }
        Mvc other = (Mvc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        ConcurrentHashMap<String, HttpRequestMethod> this$requestMethodMap = this.getRequestMethodMap();
        ConcurrentHashMap<String, HttpRequestMethod> other$requestMethodMap = other.getRequestMethodMap();
        if (this$requestMethodMap == null ? other$requestMethodMap != null : !((Object)this$requestMethodMap).equals(other$requestMethodMap)) {
            return false;
        }
        Ioc this$ioc = this.getIoc();
        Ioc other$ioc = other.getIoc();
        if (this$ioc == null ? other$ioc != null : !this$ioc.equals(other$ioc)) {
            return false;
        }
        MvcConfig this$mvcConfig = this.getMvcConfig();
        MvcConfig other$mvcConfig = other.getMvcConfig();
        if (this$mvcConfig == null ? other$mvcConfig != null : !((Object)this$mvcConfig).equals(other$mvcConfig)) {
            return false;
        }
        MethodInvoker this$methodInvoker = this.getMethodInvoker();
        MethodInvoker other$methodInvoker = other.getMethodInvoker();
        if (this$methodInvoker == null ? other$methodInvoker != null : !this$methodInvoker.equals(other$methodInvoker)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mvc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        ConcurrentHashMap<String, HttpRequestMethod> $requestMethodMap = this.getRequestMethodMap();
        result = result * 59 + ($requestMethodMap == null ? 43 : ((Object)$requestMethodMap).hashCode());
        Ioc $ioc = this.getIoc();
        result = result * 59 + ($ioc == null ? 43 : $ioc.hashCode());
        MvcConfig $mvcConfig = this.getMvcConfig();
        result = result * 59 + ($mvcConfig == null ? 43 : ((Object)$mvcConfig).hashCode());
        MethodInvoker $methodInvoker = this.getMethodInvoker();
        result = result * 59 + ($methodInvoker == null ? 43 : $methodInvoker.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Mvc(executor=" + String.valueOf(this.getExecutor()) + ", requestMethodMap=" + String.valueOf(this.getRequestMethodMap()) + ", ioc=" + String.valueOf(this.getIoc()) + ", mvcConfig=" + String.valueOf(this.getMvcConfig()) + ", methodInvoker=" + String.valueOf(this.getMethodInvoker()) + ", name=" + this.getName() + ")";
    }

    private static final class LazyHolder {
        private static final Mvc ins = new Mvc(Ioc.ins());

        private LazyHolder() {
        }
    }
}

