/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.webhook;

import com.xiaomi.youpin.docean.Ioc;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.CertificateSigningRequestResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.webhook.common.FileUtils;
import org.apache.ozhera.webhook.common.K8sUtilBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

@EnableAutoConfiguration
@ComponentScan(basePackages={"org.apache.ozhera.webhook"})
public class Bootstrap {
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private static K8sUtilBean k8sUtilBean;
    private static KubernetesClient kubernetesClient;
    private static String webhookConfigYaml;
    private static String HERA_NAMESPACE;
    public static final String DEFAULT_GROUP_ID = "DEFAULT_GROUP";
    private static final List<String> logAgentConditionNameSpaceLists;

    public static void main(String[] args) {
        try {
            Ioc.ins().init(new String[]{"run.mone.docean.plugin", "com.xiaomi.youpin.docean.plugin", "org.apache.ozhera.webhook"});
            k8sUtilBean = (K8sUtilBean)Ioc.ins().getBean(K8sUtilBean.class);
            kubernetesClient = (KubernetesClient)Ioc.ins().getBean(KubernetesClient.class);
            Bootstrap.createHeraEnvWebhook();
            SpringApplication.run(Bootstrap.class, (String[])args);
            Runtime.getRuntime().addShutdownHook(new Thread(Bootstrap::deleteWebHookConfig));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    private static void deleteWebHookConfig() {
        log.info("delete webhook begin ,namespace: {}, configYaml: {}", (Object)HERA_NAMESPACE, (Object)webhookConfigYaml);
        k8sUtilBean.applyYaml(webhookConfigYaml, HERA_NAMESPACE, "delete");
    }

    public static void createHeraEnvWebhook() {
        try {
            String app = "hera-webhook-server";
            String csrName = app + "." + HERA_NAMESPACE + ".svc";
            String dir = "/tmp/hera-webhook-tls/";
            String defaultP12Pwd = "mone";
            String csrShellFilePath = "/tmp/hera-webhook-tls-sh/generate_csr_by_openssl.sh";
            String csrArgs = Bootstrap.buildShellArgs(app, HERA_NAMESPACE, dir, csrName);
            Process process = Bootstrap.callScript(csrShellFilePath, csrArgs);
            if (process == null) {
                log.error("generate SSL file error!!");
                return;
            }
            String csrBase64 = Bootstrap.getCsrBase64(process);
            if (StringUtils.isEmpty((CharSequence)csrBase64)) {
                log.error("get csr base64 string is empty");
                return;
            }
            String certificate = Bootstrap.getCertificate(csrName, csrBase64);
            String pemShellFilePath = "/tmp/hera-webhook-tls-sh/generate_pem_p12_by_openssl.sh";
            String pemArgs = Bootstrap.buildShellArgs(app, dir, certificate, defaultP12Pwd);
            Bootstrap.callScript(pemShellFilePath, pemArgs);
            String webhookConfigYaml = FileUtils.readResourceFile("/hera_init/webhook/hera_webhook_config.yaml");
            Bootstrap.webhookConfigYaml = webhookConfigYaml = webhookConfigYaml.replace("${webhook_caBundle}", "'" + certificate + "'");
            k8sUtilBean.applyYaml(webhookConfigYaml, HERA_NAMESPACE, "add");
        }
        catch (Throwable t) {
            log.error("create hera env webhook error : ", t);
        }
    }

    private static Process callScript(String script, String args) {
        try {
            String cmd = "sh " + script + " " + args;
            log.info("callScript comand : " + cmd);
            return Runtime.getRuntime().exec(cmd, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException("call script error : ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getCsrBase64(Process process) {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = "";
            String csrLogPrefix = "csr base64 is :";
            do {
                if ((line = input.readLine()) == null) return null;
                log.info(line);
            } while (!line.startsWith(csrLogPrefix));
            String string = line.substring(csrLogPrefix.length());
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("call script error : ", e);
        }
    }

    private static String getCertificate(String csrName, String csrBase64) {
        CertificateSigningRequestList list = (CertificateSigningRequestList)kubernetesClient.certificates().v1().certificateSigningRequests().list();
        if (list != null) {
            for (CertificateSigningRequest csr : list.getItems()) {
                if (!csrName.equals(csr.getMetadata().getName())) continue;
                kubernetesClient.certificates().v1().certificateSigningRequests().delete((Object[])new CertificateSigningRequest[]{csr});
            }
        }
        String cstYaml = FileUtils.readResourceFile("/hera_init/webhook/csr/webhook_csr.yaml");
        cstYaml = cstYaml.replace("${CSR_NAME}", csrName).replace("${CSR_BASE64}", csrBase64);
        try {
            k8sUtilBean.applyYaml(cstYaml, null, "add");
            boolean isSuccessCreate = false;
            for (int i = 0; i < 30; ++i) {
                Resource csrResource = (Resource)kubernetesClient.certificates().v1().certificateSigningRequests().withName(csrName);
                if (csrResource != null && csrResource.get() != null) {
                    isSuccessCreate = true;
                    break;
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            if (!isSuccessCreate) {
                throw new RuntimeException("the csr not create success!");
            }
            ((CertificateSigningRequestResource)kubernetesClient.certificates().v1().certificateSigningRequests().withName(csrName)).approve();
            boolean isSuccessPresent = false;
            String certificate = null;
            for (int i = 0; i < 30; ++i) {
                certificate = ((CertificateSigningRequest)((CertificateSigningRequestResource)kubernetesClient.certificates().v1().certificateSigningRequests().withName(csrName)).get()).getStatus().getCertificate();
                if (StringUtils.isNotEmpty((CharSequence)certificate)) {
                    isSuccessPresent = true;
                    break;
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            if (!isSuccessPresent) {
                throw new RuntimeException("the csr not present success!");
            }
            return certificate;
        }
        catch (Throwable t) {
            throw new RuntimeException("load yaml error : ", t);
        }
    }

    private static String buildShellArgs(String ... args) {
        StringBuilder result = new StringBuilder();
        for (String arg : args) {
            result.append(arg).append(" ");
        }
        return result.toString().trim();
    }

    static {
        HERA_NAMESPACE = "ozhera-namespace";
        logAgentConditionNameSpaceLists = new ArrayList<String>();
    }
}

