/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.utils;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class KafkaUtils {
    private KafkaUtils() {
    }

    public static Properties getVpc9094KafkaProperties(String nameServer, String userName, String password) {
        String saslMechanism = "PLAIN";
        Properties props = new Properties();
        props.put("bootstrap.servers", nameServer);
        props.put("security.protocol", "SASL_PLAINTEXT");
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
            String prefix = "org.apache.kafka.common.security.scram.ScramLoginModule";
            if ("PLAIN".equalsIgnoreCase(saslMechanism)) {
                prefix = "org.apache.kafka.common.security.plain.PlainLoginModule";
            }
            String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\";", prefix, userName, password);
            props.put("sasl.jaas.config", jaasConfig);
        }
        props.put("sasl.mechanism", saslMechanism);
        return props;
    }

    public static Properties getDefaultKafkaProperties(String nameServer) {
        Properties props = new Properties();
        props.put("bootstrap.servers", nameServer);
        props.put("max.block.ms", (Object)30000);
        props.put("retries", (Object)5);
        props.put("reconnect.backoff.ms", (Object)3000);
        return props;
    }

    public static Properties getSslKafkaProperties(String nameServer, String userName, String password, String sslLocation) {
        String saslMechanism = "PLAIN";
        Properties props = new Properties();
        props.put("bootstrap.servers", nameServer);
        props.put("ssl.truststore.location", sslLocation);
        props.put("ssl.truststore.password", "KafkaOnsClient");
        props.put("security.protocol", "SASL_SSL");
        if (!StringUtils.isEmpty((CharSequence)userName) && !StringUtils.isEmpty((CharSequence)password)) {
            String prefix = "org.apache.kafka.common.security.scram.ScramLoginModule";
            if ("PLAIN".equalsIgnoreCase(saslMechanism)) {
                prefix = "org.apache.kafka.common.security.plain.PlainLoginModule";
            }
            String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\";", prefix, userName, password);
            props.put("sasl.jaas.config", jaasConfig);
        }
        props.put("sasl.mechanism", saslMechanism);
        props.put("ssl.endpoint.identification.algorithm", "");
        return props;
    }
}

