/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.alarmContact;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ozhera.prometheus.agent.Impl.RuleAlertDao;
import org.apache.ozhera.prometheus.agent.entity.RuleAlertEntity;
import org.apache.ozhera.prometheus.agent.result.alertManager.AlertManagerFireResult;
import org.apache.ozhera.prometheus.agent.result.alertManager.CommonLabels;
import org.apache.ozhera.prometheus.agent.result.alertManager.GroupLabels;
import org.apache.ozhera.prometheus.agent.service.FeishuService;
import org.apache.ozhera.prometheus.agent.service.alarmContact.BaseAlertContact;
import org.apache.ozhera.prometheus.agent.util.FreeMarkerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeishuAlertContact
extends BaseAlertContact {
    private static final Logger log = LoggerFactory.getLogger(FeishuAlertContact.class);
    @Autowired
    RuleAlertDao dao;
    @NacosValue(value="${hera.alertmanager.url}", autoRefreshed=true)
    private String silenceUrl;
    @Autowired
    private FeishuService feishuService;

    @Override
    public void Reach(AlertManagerFireResult fireResult) {
        List alerts = fireResult.getAlerts();
        GroupLabels groupLabels = fireResult.getGroupLabels();
        String alertName = groupLabels.getAlertname();
        log.info("SendAlert feishuReach begin send AlertName :{}", (Object)alertName);
        fireResult.getAlerts().stream().forEach(alert -> {
            try {
                String[] principals = this.dao.GetRuleAlertAtPeople(alertName);
                if (principals == null) {
                    log.info("SendAlert principals null alertName:{}", (Object)alertName);
                    return;
                }
                RuleAlertEntity ruleAlertEntity = this.dao.GetRuleAlertByAlertName(alert.getLabels().getAlertname());
                int priority = ruleAlertEntity.getPriority();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("priority", "P" + String.valueOf(priority));
                map.put("title", fireResult.getCommonAnnotations().getTitle());
                String alertOp = alert.getLabels().getAlert_op();
                String alertValue = alert.getLabels().getAlert_value();
                if (alertOp == null || alertOp.isEmpty()) {
                    alertOp = "";
                    alertValue = "";
                }
                map.put("alert_op", alertOp);
                map.put("alert_value", alertValue);
                map.put("application", alert.getLabels().getApplication());
                map.put("silence_url", this.silenceUrl);
                CommonLabels commonLabels = fireResult.getCommonLabels();
                Class<?> clazz = commonLabels.getClass();
                Field[] fields = clazz.getDeclaredFields();
                StringBuilder sb = new StringBuilder();
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object fieldValue = null;
                    try {
                        fieldValue = field.get(commonLabels);
                        if (fieldValue == null) continue;
                        map.put(fieldName, field.get(commonLabels));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                Map<String, Object> finalMap = this.transferNames(map);
                this.filterName(finalMap);
                finalMap.forEach((k, v) -> sb.append("**").append((String)k).append("**").append(": ").append(v).append("\n"));
                String content = sb.toString();
                finalMap.put("content", content);
                String freeMarkerRes = FreeMarkerUtil.getContent((String)"/feishu", (String)"feishuCart.ftl", finalMap);
                this.feishuService.sendFeishu(freeMarkerRes, principals, null, true);
            }
            catch (Exception e) {
                log.error("SendAlert.feishuReach error:{}", (Throwable)e);
            }
        });
        log.info("SendAlert success AlertName:{}", (Object)alertName);
    }
}

