/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.prometheus;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ozhera.prometheus.agent.Impl.RuleAlertDao;
import org.apache.ozhera.prometheus.agent.entity.RuleAlertEntity;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.enums.RuleAlertStatusEnum;
import org.apache.ozhera.prometheus.agent.param.alert.RuleAlertParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.result.alertManager.AlertManagerFireResult;
import org.apache.ozhera.prometheus.agent.service.alarmContact.DingAlertContact;
import org.apache.ozhera.prometheus.agent.service.alarmContact.FeishuAlertContact;
import org.apache.ozhera.prometheus.agent.service.alarmContact.MailAlertContact;
import org.apache.ozhera.prometheus.agent.vo.PageDataVo;
import org.nutz.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleAlertService {
    private static final Logger log = LoggerFactory.getLogger(RuleAlertService.class);
    @Autowired
    RuleAlertDao dao;
    @Autowired
    FeishuAlertContact feishuAlertContact;
    @Autowired
    MailAlertContact mailAlertContact;
    @Autowired(required=false)
    DingAlertContact dingAlertContact;
    @NacosValue(value="${hera.alertmanager.url}", autoRefreshed=true)
    private String silenceUrl;
    @NacosValue(value="${hera.alert.type}", autoRefreshed=true)
    private String alertTYPE;
    public static final Gson gson = new Gson();

    public Result CreateRuleAlert(RuleAlertParam param) {
        log.info("RuleAlertService.CreateRuleAlert  param : {}", (Object)gson.toJson((Object)param));
        try {
            if (param.getPromCluster() == null) {
                param.setPromCluster("public");
            }
            RuleAlertEntity ruleAlertEntity = new RuleAlertEntity();
            ruleAlertEntity.setName(param.getAlert() + "-" + param.getCname());
            ruleAlertEntity.setCname(param.getCname());
            ruleAlertEntity.setExpr(param.getExpr());
            ruleAlertEntity.setLabels(this.transLabel2String(param.getLabels()));
            ruleAlertEntity.setAnnotation(this.transAnnotation2String(param.getAnnotations()));
            ruleAlertEntity.setAlertFor(param.getForTime());
            ruleAlertEntity.setEnv(Strings.join((String)",", (Collection)param.getEnv()));
            ruleAlertEntity.setEnabled(param.getEnabled() == null ? 1 : param.getEnabled());
            ruleAlertEntity.setPriority(this.transPriority2Integer(param.getPriority()));
            ruleAlertEntity.setCreatedBy(String.join((CharSequence)",", param.getAlert_member()));
            ruleAlertEntity.setCreatedTime(new Date());
            ruleAlertEntity.setUpdatedTime(new Date());
            ruleAlertEntity.setDeletedBy("");
            ruleAlertEntity.setPromCluster(param.getPromCluster());
            ruleAlertEntity.setStatus(RuleAlertStatusEnum.PENDING.getDesc());
            ruleAlertEntity.setType("0");
            if (param.getAlert_member() != null) {
                ruleAlertEntity.setAlertMember(Strings.join((String)",", (Collection)param.getAlert_member()));
            }
            ruleAlertEntity.setAlertAtPeople(Strings.join((String)",", (Collection)param.getAlert_at_people()));
            ruleAlertEntity.setAlert_group(param.getGroup() == null ? "example" : param.getGroup());
            log.info("RuleAlertService.CreateRuleAlert ruleAlertEntity:{}", (Object)gson.toJson((Object)ruleAlertEntity));
            Long id = this.dao.CreateRuleAlert(ruleAlertEntity);
            log.info("RuleAlertService.CreateRuleAlert  res : {}", (Object)id);
            return Result.success((Object)id);
        }
        catch (Exception e) {
            log.error("RuleAlertService.CreateRuleAlert  fail, name: {},message: {}", (Object)param.getAlert(), (Object)e.getMessage());
            return Result.fail((ErrorCode)ErrorCode.unknownError, (Object)e.getMessage());
        }
    }

    public Result UpdateRuleAlert(String id, RuleAlertParam param) {
        log.info("RuleAlertService.UpdateRuleAlert  param : {}", (Object)gson.toJson((Object)param));
        try {
            RuleAlertEntity data = this.dao.GetRuleAlert(id);
            if (param.getCname() != null) {
                data.setCname(param.getCname());
            }
            if (param.getExpr() != null) {
                data.setExpr(param.getExpr());
            }
            if (param.getForTime() != null) {
                data.setAlertFor(param.getForTime());
            }
            if (param.getLabels() != null) {
                data.setLabels(this.transLabel2String(param.getLabels()));
            }
            if (param.getAnnotations() != null) {
                data.setAnnotation(this.transAnnotation2String(param.getAnnotations()));
            }
            if (param.getPriority() != null) {
                data.setPriority(this.transPriority2Integer(param.getPriority()));
            }
            if (param.getEnv() != null) {
                data.setEnv(Strings.join((String)",", (Collection)param.getEnv()));
            }
            if (param.getAlert_member() != null) {
                data.setAlertMember(Strings.join((String)",", (Collection)param.getAlert_member()));
            }
            if (param.getAlert_at_people() != null) {
                data.setAlertAtPeople(Strings.join((String)",", (Collection)param.getAlert_at_people()));
            }
            data.setUpdatedTime(new Date());
            log.info("RuleAlertService.UpdateRuleAlert data : {}", (Object)gson.toJson((Object)data));
            String res = this.dao.UpdateRuleAlert(id, data);
            return Result.success((Object)res);
        }
        catch (Exception e) {
            log.error("RuleAlertService.UpdateRuleAlert fail param : {}", (Object)gson.toJson((Object)param));
            return Result.fail((ErrorCode)ErrorCode.unknownError, (Object)e.getMessage());
        }
    }

    public Result DeleteRuleAlert(String id) {
        log.info("RuleAlertService.DeleteRuleAlert id : {}", (Object)id);
        try {
            int res = this.dao.DeleteRuleAlert(id);
            if (res != 1) {
                return Result.fail((ErrorCode)ErrorCode.OperationFailed);
            }
            log.info("RuleAlertService.DeleteRuleAlert res : {}", (Object)res);
            return Result.success((Object)res);
        }
        catch (Exception e) {
            log.error("RuleAlertService.DeleteRuleAlert fail, id : {}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.unknownError, (Object)e.getMessage());
        }
    }

    public Result GetRuleAlert(String id) {
        log.info("RuleAlertService.GetRuleAlert id : {}", (Object)id);
        RuleAlertEntity ruleAlertEntity = this.dao.GetRuleAlert(id);
        log.info("RuleAlertService.GetRuleAlert res : {}", (Object)gson.toJson((Object)ruleAlertEntity));
        return Result.success((Object)ruleAlertEntity);
    }

    public Result GetRuleAlertList(Integer pageSize, Integer pageNo) {
        log.info("RuleAlertService.GetRuleAlertList pageSize : {} pageNo : {}", (Object)pageSize, (Object)pageNo);
        List lists = this.dao.GetRuleAlertList(pageSize, pageNo);
        PageDataVo pdo = new PageDataVo();
        pdo.setPageNo(pageNo);
        pdo.setPageSize(pageSize);
        pdo.setTotal(this.dao.CountRuleAlert());
        pdo.setList(lists);
        log.info("RuleAlertService.GetRuleAlertList count : {}", (Object)pdo.getTotal());
        return Result.success((Object)pdo);
    }

    public Result EnabledRuleAlert(String id, String enabled) {
        log.info("RuleAlertService.EnabledRuleAlert id : {} enabled : {}", (Object)id, (Object)enabled);
        try {
            RuleAlertEntity ruleAlertEntity = this.dao.GetRuleAlert(id);
            if (ruleAlertEntity == null) {
                return Result.fail((ErrorCode)ErrorCode.NO_DATA_FOUND);
            }
            ruleAlertEntity.setEnabled(Integer.parseInt(enabled));
            String res = this.dao.UpdateRuleAlert(id, ruleAlertEntity);
            return Result.success((Object)res);
        }
        catch (Exception e) {
            log.error("RuleAlertService.EnabledRuleAlert fail id:{}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.unknownError, (Object)e.getMessage());
        }
    }

    public Result SendAlert(String body) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(body, JsonObject.class);
        AlertManagerFireResult fireResult = (AlertManagerFireResult)gson.fromJson(body, AlertManagerFireResult.class);
        switch (this.alertTYPE) {
            case "feishu": {
                this.feishuAlertContact.Reach(fireResult);
                break;
            }
            case "mail": {
                this.mailAlertContact.Reach(fireResult);
                break;
            }
            case "dingding": {
                this.dingAlertContact.Reach(fireResult);
                break;
            }
            default: {
                this.feishuAlertContact.Reach(fireResult);
            }
        }
        return Result.success((Object)"\u53d1\u9001\u544a\u8b66");
    }

    public List<RuleAlertEntity> GetAllRuleAlertList() {
        log.info("RuleAlertService.GetAllRuleAlertList");
        List list = this.dao.GetAllRuleAlertList();
        return list;
    }

    public List<RuleAlertEntity> GetAllCloudRuleAlertList(String status) {
        log.info("RuleAlertService.GetAllCloudRuleAlertList");
        List list = this.dao.GetAllCloudRuleAlertList(status);
        return list;
    }

    public void UpdateRuleAlertDeleteToDone(String alertName) {
        log.info("ScrapeJobService.UpdateRuleAlertDeleteToDone  status : {}", (Object)RuleAlertStatusEnum.DONE.getDesc());
        int affectRow = this.dao.UpdateRuleAlertDeleteToDone(alertName);
        log.info("ScrapeJobService.UpdateRuleAlertDeleteToDone affectRow num:{}", (Object)affectRow);
    }

    private String transLabel2String(Map<String, String> labels) {
        Object res = "";
        try {
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                res = (String)res + entry.getKey() + "=" + entry.getValue() + ",";
            }
            return ((String)res).substring(0, ((String)res).length() - 1);
        }
        catch (Exception e) {
            log.error("transLabel2String error:{}", (Object)e.getMessage());
            return "";
        }
    }

    private String transAnnotation2String(Map<String, String> annotations) {
        return gson.toJson(annotations);
    }

    private int transPriority2Integer(String priority) {
        try {
            String[] ps = priority.split("P");
            if (ps.length == 2) {
                return Integer.parseInt(ps[1]);
            }
            return 2;
        }
        catch (Exception e) {
            log.error("transPriority2Integer error:{}", (Object)e.getMessage());
            return 2;
        }
    }
}

