/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.grpc;

import java.util.Collections;
import org.apache.skywalking.apm.dependencies.io.grpc.Internal;
import org.apache.skywalking.apm.dependencies.io.grpc.ManagedChannelProvider;
import org.apache.skywalking.apm.dependencies.io.grpc.ServerBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.ServiceProviders;

@Internal
public abstract class ServerProvider {
    private static final ServerProvider provider = ServiceProviders.load(ServerProvider.class, Collections.emptyList(), ServerProvider.class.getClassLoader(), new ServiceProviders.PriorityAccessor<ServerProvider>(){

        @Override
        public boolean isAvailable(ServerProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(ServerProvider provider) {
            return provider.priority();
        }
    });

    public static ServerProvider provider() {
        if (provider == null) {
            throw new ManagedChannelProvider.ProviderNotFoundException("No functional server found. Try adding a dependency on the grpc-netty or grpc-netty-shaded artifact");
        }
        return provider;
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected abstract ServerBuilder<?> builderForPort(int var1);
}

