/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v1;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Map;
import org.apache.seata.core.compressor.Compressor;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.protocol.ProtocolConstants;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolEncoder;
import org.apache.seata.core.rpc.netty.v1.HeadMapSerializer;
import org.apache.seata.core.rpc.netty.v1.ProtocolRpcMessageV1;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolEncoderV1
extends MessageToByteEncoder
implements ProtocolEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolEncoderV1.class);

    @Override
    public void encode(RpcMessage message, ByteBuf out) {
        try {
            ProtocolRpcMessageV1 rpcMessage = new ProtocolRpcMessageV1();
            rpcMessage.rpcMsg2ProtocolMsg(message);
            int fullLength = 16;
            int headLength = 16;
            byte messageType = rpcMessage.getMessageType();
            out.writeBytes(ProtocolConstants.MAGIC_CODE_BYTES);
            out.writeByte(1);
            out.writerIndex(out.writerIndex() + 6);
            out.writeByte((int)messageType);
            out.writeByte((int)rpcMessage.getCodec());
            out.writeByte((int)rpcMessage.getCompressor());
            out.writeInt(rpcMessage.getId());
            Map<String, String> headMap = rpcMessage.getHeadMap();
            if (headMap != null && !headMap.isEmpty()) {
                int headMapBytesLength = HeadMapSerializer.getInstance().encode(headMap, out);
                headLength += headMapBytesLength;
                fullLength += headMapBytesLength;
            }
            byte[] bodyBytes = null;
            if (messageType != 3 && messageType != 4) {
                Serializer serializer = SerializerServiceLoader.load(SerializerType.getByCode(rpcMessage.getCodec()), (byte)1);
                bodyBytes = serializer.serialize(rpcMessage.getBody());
                Compressor compressor = CompressorFactory.getCompressor(rpcMessage.getCompressor());
                bodyBytes = compressor.compress(bodyBytes);
                fullLength += bodyBytes.length;
            }
            if (bodyBytes != null) {
                out.writeBytes(bodyBytes);
            }
            int writeIndex = out.writerIndex();
            out.writerIndex(writeIndex - fullLength + 3);
            out.writeInt(fullLength);
            out.writeShort(headLength);
            out.writerIndex(writeIndex);
        }
        catch (Throwable e) {
            LOGGER.error("Encode request error!", e);
            throw e;
        }
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        try {
            if (!(msg instanceof RpcMessage)) {
                throw new UnsupportedOperationException("Not support this class:" + msg.getClass());
            }
            this.encode((RpcMessage)msg, out);
        }
        catch (Throwable e) {
            LOGGER.error("Encode request error!", e);
        }
    }
}

