/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: ./pkg/remoting/mock/test_getty_session.go

// Package mock is a generated GoMock package.
package mock

import (
	net "net"
	reflect "reflect"
	time "time"

	getty "github.com/apache/dubbo-getty"
	gomock "github.com/golang/mock/gomock"
)

// MockTestSession is a mock of TestSession interface.
type MockTestSession struct {
	ctrl     *gomock.Controller
	recorder *MockTestSessionMockRecorder
}

// MockTestSessionMockRecorder is the mock recorder for MockTestSession.
type MockTestSessionMockRecorder struct {
	mock *MockTestSession
}

// NewMockTestSession creates a new mock instance.
func NewMockTestSession(ctrl *gomock.Controller) *MockTestSession {
	mock := &MockTestSession{ctrl: ctrl}
	mock.recorder = &MockTestSessionMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTestSession) EXPECT() *MockTestSessionMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockTestSession) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockTestSessionMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockTestSession)(nil).Close))
}

// CloseConn mocks base method.
func (m *MockTestSession) CloseConn(arg0 int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "CloseConn", arg0)
}

// CloseConn indicates an expected call of CloseConn.
func (mr *MockTestSessionMockRecorder) CloseConn(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseConn", reflect.TypeOf((*MockTestSession)(nil).CloseConn), arg0)
}

// Conn mocks base method.
func (m *MockTestSession) Conn() net.Conn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Conn")
	ret0, _ := ret[0].(net.Conn)
	return ret0
}

// Conn indicates an expected call of Conn.
func (mr *MockTestSessionMockRecorder) Conn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Conn", reflect.TypeOf((*MockTestSession)(nil).Conn))
}

// EndPoint mocks base method.
func (m *MockTestSession) EndPoint() getty.EndPoint {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EndPoint")
	ret0, _ := ret[0].(getty.EndPoint)
	return ret0
}

// EndPoint indicates an expected call of EndPoint.
func (mr *MockTestSessionMockRecorder) EndPoint() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EndPoint", reflect.TypeOf((*MockTestSession)(nil).EndPoint))
}

// GetActive mocks base method.
func (m *MockTestSession) GetActive() time.Time {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActive")
	ret0, _ := ret[0].(time.Time)
	return ret0
}

// GetActive indicates an expected call of GetActive.
func (mr *MockTestSessionMockRecorder) GetActive() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActive", reflect.TypeOf((*MockTestSession)(nil).GetActive))
}

// GetAttribute mocks base method.
func (m *MockTestSession) GetAttribute(arg0 interface{}) interface{} {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAttribute", arg0)
	ret0, _ := ret[0].(interface{})
	return ret0
}

// GetAttribute indicates an expected call of GetAttribute.
func (mr *MockTestSessionMockRecorder) GetAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAttribute", reflect.TypeOf((*MockTestSession)(nil).GetAttribute), arg0)
}

// ID mocks base method.
func (m *MockTestSession) ID() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// ID indicates an expected call of ID.
func (mr *MockTestSessionMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockTestSession)(nil).ID))
}

// IncReadPkgNum mocks base method.
func (m *MockTestSession) IncReadPkgNum() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "IncReadPkgNum")
}

// IncReadPkgNum indicates an expected call of IncReadPkgNum.
func (mr *MockTestSessionMockRecorder) IncReadPkgNum() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IncReadPkgNum", reflect.TypeOf((*MockTestSession)(nil).IncReadPkgNum))
}

// IncWritePkgNum mocks base method.
func (m *MockTestSession) IncWritePkgNum() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "IncWritePkgNum")
}

// IncWritePkgNum indicates an expected call of IncWritePkgNum.
func (mr *MockTestSessionMockRecorder) IncWritePkgNum() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IncWritePkgNum", reflect.TypeOf((*MockTestSession)(nil).IncWritePkgNum))
}

// IsClosed mocks base method.
func (m *MockTestSession) IsClosed() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsClosed")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsClosed indicates an expected call of IsClosed.
func (mr *MockTestSessionMockRecorder) IsClosed() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsClosed", reflect.TypeOf((*MockTestSession)(nil).IsClosed))
}

// LocalAddr mocks base method.
func (m *MockTestSession) LocalAddr() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LocalAddr")
	ret0, _ := ret[0].(string)
	return ret0
}

// LocalAddr indicates an expected call of LocalAddr.
func (mr *MockTestSessionMockRecorder) LocalAddr() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LocalAddr", reflect.TypeOf((*MockTestSession)(nil).LocalAddr))
}

// ReadTimeout mocks base method.
func (m *MockTestSession) ReadTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// ReadTimeout indicates an expected call of ReadTimeout.
func (mr *MockTestSessionMockRecorder) ReadTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadTimeout", reflect.TypeOf((*MockTestSession)(nil).ReadTimeout))
}

// RemoteAddr mocks base method.
func (m *MockTestSession) RemoteAddr() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoteAddr")
	ret0, _ := ret[0].(string)
	return ret0
}

// RemoteAddr indicates an expected call of RemoteAddr.
func (mr *MockTestSessionMockRecorder) RemoteAddr() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoteAddr", reflect.TypeOf((*MockTestSession)(nil).RemoteAddr))
}

// RemoveAttribute mocks base method.
func (m *MockTestSession) RemoveAttribute(arg0 interface{}) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "RemoveAttribute", arg0)
}

// RemoveAttribute indicates an expected call of RemoveAttribute.
func (mr *MockTestSessionMockRecorder) RemoveAttribute(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveAttribute", reflect.TypeOf((*MockTestSession)(nil).RemoveAttribute), arg0)
}

// Reset mocks base method.
func (m *MockTestSession) Reset() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Reset")
}

// Reset indicates an expected call of Reset.
func (mr *MockTestSessionMockRecorder) Reset() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Reset", reflect.TypeOf((*MockTestSession)(nil).Reset))
}

// Send mocks base method.
func (m *MockTestSession) Send(arg0 interface{}) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Send", arg0)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Send indicates an expected call of Send.
func (mr *MockTestSessionMockRecorder) Send(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Send", reflect.TypeOf((*MockTestSession)(nil).Send), arg0)
}

// SetAttribute mocks base method.
func (m *MockTestSession) SetAttribute(arg0, arg1 interface{}) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetAttribute", arg0, arg1)
}

// SetAttribute indicates an expected call of SetAttribute.
func (mr *MockTestSessionMockRecorder) SetAttribute(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAttribute", reflect.TypeOf((*MockTestSession)(nil).SetAttribute), arg0, arg1)
}

// SetCompressType mocks base method.
func (m *MockTestSession) SetCompressType(arg0 getty.CompressType) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetCompressType", arg0)
}

// SetCompressType indicates an expected call of SetCompressType.
func (mr *MockTestSessionMockRecorder) SetCompressType(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCompressType", reflect.TypeOf((*MockTestSession)(nil).SetCompressType), arg0)
}

// SetCronPeriod mocks base method.
func (m *MockTestSession) SetCronPeriod(arg0 int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetCronPeriod", arg0)
}

// SetCronPeriod indicates an expected call of SetCronPeriod.
func (mr *MockTestSessionMockRecorder) SetCronPeriod(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCronPeriod", reflect.TypeOf((*MockTestSession)(nil).SetCronPeriod), arg0)
}

// SetEventListener mocks base method.
func (m *MockTestSession) SetEventListener(arg0 getty.EventListener) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetEventListener", arg0)
}

// SetEventListener indicates an expected call of SetEventListener.
func (mr *MockTestSessionMockRecorder) SetEventListener(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEventListener", reflect.TypeOf((*MockTestSession)(nil).SetEventListener), arg0)
}

// SetMaxMsgLen mocks base method.
func (m *MockTestSession) SetMaxMsgLen(arg0 int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetMaxMsgLen", arg0)
}

// SetMaxMsgLen indicates an expected call of SetMaxMsgLen.
func (mr *MockTestSessionMockRecorder) SetMaxMsgLen(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMaxMsgLen", reflect.TypeOf((*MockTestSession)(nil).SetMaxMsgLen), arg0)
}

// SetName mocks base method.
func (m *MockTestSession) SetName(arg0 string) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetName", arg0)
}

// SetName indicates an expected call of SetName.
func (mr *MockTestSessionMockRecorder) SetName(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetName", reflect.TypeOf((*MockTestSession)(nil).SetName), arg0)
}

// SetPkgHandler mocks base method.
func (m *MockTestSession) SetPkgHandler(arg0 getty.ReadWriter) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetPkgHandler", arg0)
}

// SetPkgHandler indicates an expected call of SetPkgHandler.
func (mr *MockTestSessionMockRecorder) SetPkgHandler(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPkgHandler", reflect.TypeOf((*MockTestSession)(nil).SetPkgHandler), arg0)
}

// SetReadTimeout mocks base method.
func (m *MockTestSession) SetReadTimeout(arg0 time.Duration) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetReadTimeout", arg0)
}

// SetReadTimeout indicates an expected call of SetReadTimeout.
func (mr *MockTestSessionMockRecorder) SetReadTimeout(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReadTimeout", reflect.TypeOf((*MockTestSession)(nil).SetReadTimeout), arg0)
}

// SetReader mocks base method.
func (m *MockTestSession) SetReader(arg0 getty.Reader) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetReader", arg0)
}

// SetReader indicates an expected call of SetReader.
func (mr *MockTestSessionMockRecorder) SetReader(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReader", reflect.TypeOf((*MockTestSession)(nil).SetReader), arg0)
}

// SetSession mocks base method.
func (m *MockTestSession) SetSession(arg0 getty.Session) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetSession", arg0)
}

// SetSession indicates an expected call of SetSession.
func (mr *MockTestSessionMockRecorder) SetSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSession", reflect.TypeOf((*MockTestSession)(nil).SetSession), arg0)
}

// SetWaitTime mocks base method.
func (m *MockTestSession) SetWaitTime(arg0 time.Duration) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetWaitTime", arg0)
}

// SetWaitTime indicates an expected call of SetWaitTime.
func (mr *MockTestSessionMockRecorder) SetWaitTime(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWaitTime", reflect.TypeOf((*MockTestSession)(nil).SetWaitTime), arg0)
}

// SetWriteTimeout mocks base method.
func (m *MockTestSession) SetWriteTimeout(arg0 time.Duration) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetWriteTimeout", arg0)
}

// SetWriteTimeout indicates an expected call of SetWriteTimeout.
func (mr *MockTestSessionMockRecorder) SetWriteTimeout(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteTimeout", reflect.TypeOf((*MockTestSession)(nil).SetWriteTimeout), arg0)
}

// SetWriter mocks base method.
func (m *MockTestSession) SetWriter(arg0 getty.Writer) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetWriter", arg0)
}

// SetWriter indicates an expected call of SetWriter.
func (mr *MockTestSessionMockRecorder) SetWriter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriter", reflect.TypeOf((*MockTestSession)(nil).SetWriter), arg0)
}

// Stat mocks base method.
func (m *MockTestSession) Stat() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Stat")
	ret0, _ := ret[0].(string)
	return ret0
}

// Stat indicates an expected call of Stat.
func (mr *MockTestSessionMockRecorder) Stat() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stat", reflect.TypeOf((*MockTestSession)(nil).Stat))
}

// UpdateActive mocks base method.
func (m *MockTestSession) UpdateActive() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateActive")
}

// UpdateActive indicates an expected call of UpdateActive.
func (mr *MockTestSessionMockRecorder) UpdateActive() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActive", reflect.TypeOf((*MockTestSession)(nil).UpdateActive))
}

// WriteBytes mocks base method.
func (m *MockTestSession) WriteBytes(arg0 []byte) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBytes", arg0)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// WriteBytes indicates an expected call of WriteBytes.
func (mr *MockTestSessionMockRecorder) WriteBytes(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBytes", reflect.TypeOf((*MockTestSession)(nil).WriteBytes), arg0)
}

// WriteBytesArray mocks base method.
func (m *MockTestSession) WriteBytesArray(arg0 ...[]byte) (int, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range arg0 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WriteBytesArray", varargs...)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// WriteBytesArray indicates an expected call of WriteBytesArray.
func (mr *MockTestSessionMockRecorder) WriteBytesArray(arg0 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBytesArray", reflect.TypeOf((*MockTestSession)(nil).WriteBytesArray), arg0...)
}

// WritePkg mocks base method.
func (m *MockTestSession) WritePkg(pkg interface{}, timeout time.Duration) (int, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WritePkg", pkg, timeout)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// WritePkg indicates an expected call of WritePkg.
func (mr *MockTestSessionMockRecorder) WritePkg(pkg, timeout interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WritePkg", reflect.TypeOf((*MockTestSession)(nil).WritePkg), pkg, timeout)
}

// WriteTimeout mocks base method.
func (m *MockTestSession) WriteTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// WriteTimeout indicates an expected call of WriteTimeout.
func (mr *MockTestSessionMockRecorder) WriteTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTimeout", reflect.TypeOf((*MockTestSession)(nil).WriteTimeout))
}
