/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.tsfile.file.metadata.IDeviceID;

public class SDBMHashExecutor
extends SeriesPartitionExecutor {
    public SDBMHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 0;
        for (int i = 0; i < device.length(); ++i) {
            hash = device.charAt(i) + (hash << 6) + (hash << 16) - hash;
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(IDeviceID deviceID) {
        int hash = 0;
        int segmentNum = deviceID.segmentNum();
        for (int segmentID = 0; segmentID < segmentNum; ++segmentID) {
            Object segment = deviceID.segment(segmentID);
            if (segment instanceof String) {
                String segmentStr = (String)segment;
                for (int i = 0; i < segmentStr.length(); ++i) {
                    hash = segmentStr.charAt(i) + (hash << 6) + (hash << 16) - hash;
                }
            } else {
                hash = 65536 + (hash << 6) + (hash << 16) - hash;
            }
            if (segmentID >= segmentNum - 1) continue;
            hash = 46 + (hash << 6) + (hash << 16) - hash;
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

