/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iotdb.commons.path.PartialPath;

public class ExtendedPartialPath
extends PartialPath {
    private final Map<Integer, List<Function<String, Boolean>>> matchFunctions = new HashMap<Integer, List<Function<String, Boolean>>>();
    private final boolean isRestrict;

    public ExtendedPartialPath(String[] nodes, boolean isRestrict) {
        super(nodes);
        this.isRestrict = isRestrict;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean match(int index, String value) {
        if (!this.matchFunctions.containsKey(index)) {
            return true;
        }
        return this.matchFunctions.get(index).stream().allMatch(function -> (Boolean)function.apply(value));
    }

    public void addMatchFunction(int index, Function<String, Boolean> matchFunction) {
        this.matchFunctions.computeIfAbsent(index, k -> new ArrayList()).add(matchFunction);
    }

    public boolean isNormalPath() {
        return this.matchFunctions.isEmpty();
    }

    @Override
    public String toString() {
        return "ExtendedPartialPath{fullPath=" + this.getFullPath() + ", matchFunctions=" + this.matchFunctions + ", isRestrict=" + this.isRestrict + '}';
    }
}

