/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class TablePattern {
    private final boolean isTableModelDataAllowedToBeCaptured;
    private final Pattern databasePattern;
    private final Pattern tablePattern;

    public TablePattern(boolean isTableModelDataAllowedToBeCaptured, String databasePatternString, String tablePatternString) {
        this.isTableModelDataAllowedToBeCaptured = isTableModelDataAllowedToBeCaptured;
        this.databasePattern = databasePatternString == null || databasePatternString.trim().equals(".*") ? null : Pattern.compile(databasePatternString);
        this.tablePattern = tablePatternString == null || tablePatternString.trim().equals(".*") ? null : Pattern.compile(tablePatternString);
    }

    public boolean isTableModelDataAllowedToBeCaptured() {
        return this.isTableModelDataAllowedToBeCaptured;
    }

    public boolean hasUserSpecifiedDatabasePatternOrTablePattern() {
        return this.databasePattern != null || this.tablePattern != null;
    }

    public boolean coversDb(String database) {
        return !this.hasUserSpecifiedDatabasePatternOrTablePattern() || this.databasePattern != null && this.databasePattern.matcher(database).matches() && this.tablePattern == null;
    }

    public boolean matchesDatabase(String database) {
        return this.databasePattern == null || this.databasePattern.matcher(database).matches();
    }

    public boolean matchesTable(String table) {
        return this.tablePattern == null || this.tablePattern.matcher(table).matches();
    }

    public String getDatabasePattern() {
        return this.databasePattern == null ? ".*" : this.databasePattern.pattern();
    }

    public String getTablePattern() {
        return this.tablePattern == null ? ".*" : this.tablePattern.pattern();
    }

    public boolean hasTablePattern() {
        return this.tablePattern != null;
    }

    public static TablePattern parsePipePatternFromSourceParameters(PipeParameters sourceParameters) {
        boolean isTableModelDataAllowedToBeCaptured = TablePattern.isTableModelDataAllowToBeCaptured(sourceParameters);
        String databaseNamePattern = sourceParameters.getStringOrDefault(Arrays.asList("extractor.database-name", "source.database-name", "extractor.database", "source.database"), ".*");
        String tableNamePattern = sourceParameters.getStringOrDefault(Arrays.asList("extractor.table-name", "source.table-name", "extractor.table", "source.table"), ".*");
        try {
            return new TablePattern(isTableModelDataAllowedToBeCaptured, databaseNamePattern, tableNamePattern);
        }
        catch (Exception e) {
            throw new PipeException("Illegal database or table pattern. Detail: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isTableModelDataAllowToBeCaptured(PipeParameters sourceParameters) {
        return sourceParameters.getBooleanOrDefault(Arrays.asList("extractor.mode.double-living", "source.mode.double-living"), false) || sourceParameters.getBooleanOrDefault(Arrays.asList("extractor.capture.table", "source.capture.table"), !sourceParameters.getStringOrDefault("__system.sql-dialect", "tree").equals("tree"));
    }

    public String toString() {
        return "TablePattern{isTableModelDataAllowedToBeCaptured=" + this.isTableModelDataAllowedToBeCaptured + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + '}';
    }
}

