/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ProxiedAuthorizationV2RequestControl
extends Control {
    @NotNull
    public static final String PROXIED_AUTHORIZATION_V2_REQUEST_OID = "2.16.840.1.113730.3.4.18";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_ID = "authorization-id";
    private static final long serialVersionUID = 1054244283964851067L;
    @NotNull
    private final String authorizationID;

    public ProxiedAuthorizationV2RequestControl(@NotNull String authorizationID) {
        super(PROXIED_AUTHORIZATION_V2_REQUEST_OID, true, new ASN1OctetString(authorizationID));
        Validator.ensureNotNull(authorizationID);
        this.authorizationID = authorizationID;
    }

    public ProxiedAuthorizationV2RequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXY_V2_NO_VALUE.get());
        }
        this.authorizationID = value.stringValue();
    }

    @NotNull
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PROXIED_AUTHZ_V2_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", PROXIED_AUTHORIZATION_V2_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PROXIED_AUTHZ_V2_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_AUTHORIZATION_ID, this.authorizationID))));
    }

    @NotNull
    public static ProxiedAuthorizationV2RequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new ProxiedAuthorizationV2RequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String authorizationID = valueObject.getFieldAsString(JSON_FIELD_AUTHORIZATION_ID);
        if (authorizationID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV2_JSON_MISSING_AUTHZ_ID.get(controlObject.toSingleLineString(), JSON_FIELD_AUTHORIZATION_ID));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_AUTHORIZATION_ID)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV2_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new ProxiedAuthorizationV2RequestControl(authorizationID);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV2RequestControl(authorizationID='");
        buffer.append(this.authorizationID);
        buffer.append("')");
    }
}

