/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RestoreTask
extends Task {
    @NotNull
    static final String RESTORE_TASK_CLASS = "com.unboundid.directory.server.tasks.RestoreTask";
    @NotNull
    private static final String ATTR_BACKUP_DIRECTORY = "ds-backup-directory-path";
    @NotNull
    private static final String ATTR_BACKUP_ID = "ds-backup-id";
    @NotNull
    private static final String ATTR_ENCRYPTION_PASSPHRASE_FILE = "ds-task-restore-encryption-passphrase-file";
    @NotNull
    private static final String ATTR_VERIFY_ONLY = "ds-task-restore-verify-only";
    @NotNull
    private static final String OC_RESTORE_TASK = "ds-task-restore";
    @NotNull
    private static final TaskProperty PROPERTY_BACKUP_DIRECTORY = new TaskProperty("ds-backup-directory-path", TaskMessages.INFO_DISPLAY_NAME_BACKUP_DIRECTORY.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_DIRECTORY_RESTORE.get(), String.class, true, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_BACKUP_ID = new TaskProperty("ds-backup-id", TaskMessages.INFO_DISPLAY_NAME_BACKUP_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_ID_RESTORE.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_ENCRYPTION_PASSPHRASE_FILE = new TaskProperty("ds-task-restore-encryption-passphrase-file", TaskMessages.INFO_DISPLAY_NAME_ENCRYPTION_PASSPHRASE_FILE.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPTION_PASSPHRASE_FILE.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_VERIFY_ONLY = new TaskProperty("ds-task-restore-verify-only", TaskMessages.INFO_DISPLAY_NAME_VERIFY_ONLY.get(), TaskMessages.INFO_DESCRIPTION_VERIFY_ONLY.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = -8441221098187125379L;
    private final boolean verifyOnly;
    @NotNull
    private final String backupDirectory;
    @Nullable
    private final String encryptionPassphraseFile;
    @Nullable
    private final String backupID;

    public RestoreTask() {
        this.verifyOnly = false;
        this.backupDirectory = null;
        this.backupID = null;
        this.encryptionPassphraseFile = null;
    }

    public RestoreTask(@Nullable String taskID, @NotNull String backupDirectory, @Nullable String backupID, boolean verifyOnly) {
        this(taskID, backupDirectory, backupID, verifyOnly, null, null, null, null, null);
    }

    public RestoreTask(@Nullable String taskID, @NotNull String backupDirectory, @Nullable String backupID, boolean verifyOnly, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, backupDirectory, backupID, verifyOnly, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public RestoreTask(@Nullable String taskID, @NotNull String backupDirectory, @Nullable String backupID, boolean verifyOnly, @Nullable String encryptionPassphraseFile, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, backupDirectory, backupID, verifyOnly, encryptionPassphraseFile, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public RestoreTask(@Nullable String taskID, @NotNull String backupDirectory, @Nullable String backupID, boolean verifyOnly, @Nullable String encryptionPassphraseFile, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, RESTORE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(backupDirectory);
        this.backupDirectory = backupDirectory;
        this.backupID = backupID;
        this.verifyOnly = verifyOnly;
        this.encryptionPassphraseFile = encryptionPassphraseFile;
    }

    public RestoreTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.backupDirectory = entry.getAttributeValue(ATTR_BACKUP_DIRECTORY);
        if (this.backupDirectory == null) {
            throw new TaskException(TaskMessages.ERR_RESTORE_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backupID = entry.getAttributeValue(ATTR_BACKUP_ID);
        this.verifyOnly = RestoreTask.parseBooleanValue(entry, ATTR_VERIFY_ONLY, false);
        this.encryptionPassphraseFile = entry.getAttributeValue(ATTR_ENCRYPTION_PASSPHRASE_FILE);
    }

    public RestoreTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(RESTORE_TASK_CLASS, properties);
        boolean v = false;
        String b = null;
        String f = null;
        String i = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_DIRECTORY)) {
                b = RestoreTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_ID)) {
                i = RestoreTask.parseString(p, values, i);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_VERIFY_ONLY)) {
                v = RestoreTask.parseBoolean(p, values, v);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_ENCRYPTION_PASSPHRASE_FILE)) continue;
            f = RestoreTask.parseString(p, values, f);
        }
        if (b == null) {
            throw new TaskException(TaskMessages.ERR_RESTORE_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backupDirectory = b;
        this.backupID = i;
        this.verifyOnly = v;
        this.encryptionPassphraseFile = f;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_RESTORE.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_RESTORE.get();
    }

    @NotNull
    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    @Nullable
    public String getBackupID() {
        return this.backupID;
    }

    public boolean verifyOnly() {
        return this.verifyOnly;
    }

    @Nullable
    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_RESTORE_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(10);
        attrs.add(new Attribute(ATTR_BACKUP_DIRECTORY, this.backupDirectory));
        attrs.add(new Attribute(ATTR_VERIFY_ONLY, String.valueOf(this.verifyOnly)));
        if (this.backupID != null) {
            attrs.add(new Attribute(ATTR_BACKUP_ID, this.backupID));
        }
        if (this.encryptionPassphraseFile != null) {
            attrs.add(new Attribute(ATTR_ENCRYPTION_PASSPHRASE_FILE, this.encryptionPassphraseFile));
        }
        return attrs;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKUP_DIRECTORY, PROPERTY_BACKUP_ID, PROPERTY_VERIFY_ONLY, PROPERTY_ENCRYPTION_PASSPHRASE_FILE);
        return Collections.unmodifiableList(propList);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        props.put(PROPERTY_BACKUP_DIRECTORY, Collections.singletonList(this.backupDirectory));
        if (this.backupID == null) {
            props.put(PROPERTY_BACKUP_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_BACKUP_ID, Collections.singletonList(this.backupID));
        }
        props.put(PROPERTY_VERIFY_ONLY, Collections.singletonList(this.verifyOnly));
        if (this.encryptionPassphraseFile == null) {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.emptyList());
        } else {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.singletonList(this.encryptionPassphraseFile));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

