/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidReplicaDirectoriesException;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class PartitionRegistration {
    public final int[] replicas;
    public final Uuid[] directories;
    public final int[] isr;
    public final int[] removingReplicas;
    public final int[] addingReplicas;
    public final int[] elr;
    public final int[] lastKnownElr;
    public final int leader;
    public final LeaderRecoveryState leaderRecoveryState;
    public final int leaderEpoch;
    public final int partitionEpoch;

    public static boolean electionWasUnclean(byte leaderRecoveryState) {
        return leaderRecoveryState == LeaderRecoveryState.RECOVERING.value();
    }

    private static List<Uuid> checkDirectories(PartitionRecord record) {
        if (record.directories() != null && !record.directories().isEmpty() && record.replicas().size() != record.directories().size()) {
            throw new InvalidReplicaDirectoriesException(record);
        }
        return record.directories();
    }

    private static List<Uuid> checkDirectories(PartitionChangeRecord record) {
        if (record.replicas() != null && record.directories() != null && !record.directories().isEmpty() && record.replicas().size() != record.directories().size()) {
            throw new InvalidReplicaDirectoriesException(record);
        }
        return record.directories();
    }

    private static boolean migratingDirectories(Uuid[] directories) {
        if (directories == null) {
            return true;
        }
        for (Uuid directory : directories) {
            if (DirectoryId.MIGRATING.equals((Object)directory)) continue;
            return false;
        }
        return true;
    }

    private static Uuid[] defaultToMigrating(Uuid[] directories, int numReplicas) {
        if (PartitionRegistration.migratingDirectories(directories)) {
            return DirectoryId.migratingArray((int)numReplicas);
        }
        return directories;
    }

    public PartitionRegistration(PartitionRecord record) {
        this(Replicas.toArray(record.replicas()), PartitionRegistration.defaultToMigrating(Uuid.toArray(PartitionRegistration.checkDirectories(record)), record.replicas().size()), Replicas.toArray(record.isr()), Replicas.toArray(record.removingReplicas()), Replicas.toArray(record.addingReplicas()), record.leader(), LeaderRecoveryState.of(record.leaderRecoveryState()), record.leaderEpoch(), record.partitionEpoch(), Replicas.toArray(record.eligibleLeaderReplicas()), Replicas.toArray(record.lastKnownElr()));
    }

    private PartitionRegistration(int[] replicas, Uuid[] directories, int[] isr, int[] removingReplicas, int[] addingReplicas, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch, int[] elr, int[] lastKnownElr) {
        Objects.requireNonNull(directories);
        if (directories.length > 0 && directories.length != replicas.length) {
            throw new IllegalArgumentException("The lengths for replicas and directories do not match.");
        }
        this.replicas = replicas;
        this.directories = directories;
        this.isr = isr;
        this.removingReplicas = removingReplicas;
        this.addingReplicas = addingReplicas;
        this.leader = leader;
        this.leaderRecoveryState = leaderRecoveryState;
        this.leaderEpoch = leaderEpoch;
        this.partitionEpoch = partitionEpoch;
        this.elr = elr == null ? new int[]{} : elr;
        this.lastKnownElr = lastKnownElr == null ? new int[]{} : lastKnownElr;
    }

    public PartitionRegistration merge(PartitionChangeRecord record) {
        int newLeaderEpoch;
        int newLeader;
        int[] newAddingReplicas;
        int[] newReplicas = record.replicas() == null ? this.replicas : Replicas.toArray(record.replicas());
        Uuid[] newDirectories = PartitionRegistration.defaultToMigrating(record.directories() == null ? this.directories : Uuid.toArray(PartitionRegistration.checkDirectories(record)), newReplicas.length);
        int[] newIsr = record.isr() == null ? this.isr : Replicas.toArray(record.isr());
        int[] newRemovingReplicas = record.removingReplicas() == null ? this.removingReplicas : Replicas.toArray(record.removingReplicas());
        int[] nArray = newAddingReplicas = record.addingReplicas() == null ? this.addingReplicas : Replicas.toArray(record.addingReplicas());
        if (record.leader() == -2) {
            newLeader = this.leader;
            newLeaderEpoch = this.leaderEpoch;
        } else {
            newLeader = record.leader();
            newLeaderEpoch = this.leaderEpoch + 1;
        }
        LeaderRecoveryState newLeaderRecoveryState = this.leaderRecoveryState.changeTo(record.leaderRecoveryState());
        int[] newElr = record.eligibleLeaderReplicas() == null ? this.elr : Replicas.toArray(record.eligibleLeaderReplicas());
        int[] newLastKnownElr = record.lastKnownElr() == null ? this.lastKnownElr : Replicas.toArray(record.lastKnownElr());
        return new PartitionRegistration(newReplicas, newDirectories, newIsr, newRemovingReplicas, newAddingReplicas, newLeader, newLeaderRecoveryState, newLeaderEpoch, this.partitionEpoch + 1, newElr, newLastKnownElr);
    }

    public String diff(PartitionRegistration prev) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (!Arrays.equals(this.replicas, prev.replicas)) {
            builder.append(prefix).append("replicas: ").append(Arrays.toString(prev.replicas)).append(" -> ").append(Arrays.toString(this.replicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.directories, prev.directories)) {
            builder.append(prefix).append("directories: ").append(Arrays.toString(prev.directories)).append(" -> ").append(Arrays.toString(this.directories));
            prefix = ", ";
        }
        if (!Arrays.equals(this.isr, prev.isr)) {
            builder.append(prefix).append("isr: ").append(Arrays.toString(prev.isr)).append(" -> ").append(Arrays.toString(this.isr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.removingReplicas, prev.removingReplicas)) {
            builder.append(prefix).append("removingReplicas: ").append(Arrays.toString(prev.removingReplicas)).append(" -> ").append(Arrays.toString(this.removingReplicas));
            prefix = ", ";
        }
        if (!Arrays.equals(this.addingReplicas, prev.addingReplicas)) {
            builder.append(prefix).append("addingReplicas: ").append(Arrays.toString(prev.addingReplicas)).append(" -> ").append(Arrays.toString(this.addingReplicas));
            prefix = ", ";
        }
        if (this.leader != prev.leader) {
            builder.append(prefix).append("leader: ").append(prev.leader).append(" -> ").append(this.leader);
            prefix = ", ";
        }
        if (this.leaderRecoveryState != prev.leaderRecoveryState) {
            builder.append(prefix).append("leaderRecoveryState: ").append((Object)prev.leaderRecoveryState).append(" -> ").append((Object)this.leaderRecoveryState);
            prefix = ", ";
        }
        if (this.leaderEpoch != prev.leaderEpoch) {
            builder.append(prefix).append("leaderEpoch: ").append(prev.leaderEpoch).append(" -> ").append(this.leaderEpoch);
            prefix = ", ";
        }
        if (!Arrays.equals(this.elr, prev.elr)) {
            builder.append(prefix).append("elr: ").append(Arrays.toString(prev.elr)).append(" -> ").append(Arrays.toString(this.elr));
            prefix = ", ";
        }
        if (!Arrays.equals(this.lastKnownElr, prev.lastKnownElr)) {
            builder.append(prefix).append("lastKnownElr: ").append(Arrays.toString(prev.lastKnownElr)).append(" -> ").append(Arrays.toString(this.lastKnownElr));
            prefix = ", ";
        }
        if (this.partitionEpoch != prev.partitionEpoch) {
            builder.append(prefix).append("partitionEpoch: ").append(prev.partitionEpoch).append(" -> ").append(this.partitionEpoch);
        }
        return builder.toString();
    }

    public void maybeLogPartitionChange(Logger log, String description, PartitionRegistration prev) {
        if (PartitionRegistration.electionWasUnclean(this.leaderRecoveryState.value())) {
            log.info("UNCLEAN partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        } else if (log.isDebugEnabled()) {
            log.debug("partition change for {}: {}", (Object)description, (Object)this.diff(prev));
        }
    }

    public boolean hasLeader() {
        return this.leader != -1;
    }

    public boolean hasPreferredLeader() {
        return this.leader == this.preferredReplica();
    }

    public int preferredReplica() {
        return this.replicas.length == 0 ? -1 : this.replicas[0];
    }

    public Uuid directory(int replica) {
        for (int i = 0; i < this.replicas.length; ++i) {
            if (this.replicas[i] != replica) continue;
            return this.directories[i];
        }
        throw new IllegalArgumentException("Replica " + replica + " is not assigned to this partition.");
    }

    public ApiMessageAndVersion toRecord(Uuid topicId, int partitionId, ImageWriterOptions options) {
        PartitionRecord record = new PartitionRecord().setPartitionId(partitionId).setTopicId(topicId).setReplicas(Replicas.toList(this.replicas)).setIsr(Replicas.toList(this.isr)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setLeader(this.leader).setLeaderRecoveryState(this.leaderRecoveryState.value()).setLeaderEpoch(this.leaderEpoch).setPartitionEpoch(this.partitionEpoch);
        if (options.isEligibleLeaderReplicasEnabled()) {
            if (this.elr.length > 0) {
                record.setEligibleLeaderReplicas(Replicas.toList(this.elr));
            }
            if (this.lastKnownElr.length > 0) {
                record.setLastKnownElr(Replicas.toList(this.lastKnownElr));
            }
        }
        if (options.metadataVersion() == null) {
            options.handleLoss("the metadata version");
            return new ApiMessageAndVersion((ApiMessage)record, 0);
        }
        if (options.metadataVersion().isDirectoryAssignmentSupported()) {
            record.setDirectories(Uuid.toList((Uuid[])this.directories));
        } else {
            for (Uuid directory : this.directories) {
                if (DirectoryId.MIGRATING.equals((Object)directory)) continue;
                options.handleLoss("the directory assignment state of one or more replicas");
                break;
            }
        }
        return new ApiMessageAndVersion((ApiMessage)record, options.metadataVersion().partitionRecordVersion());
    }

    public LeaderAndIsrRequest.PartitionState toLeaderAndIsrPartitionState(TopicPartition tp, boolean isNew) {
        return new LeaderAndIsrRequest.PartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(-1).setLeader(this.leader).setLeaderEpoch(this.leaderEpoch).setIsr(Replicas.toList(this.isr)).setPartitionEpoch(this.partitionEpoch).setReplicas(Replicas.toList(this.replicas)).setAddingReplicas(Replicas.toList(this.addingReplicas)).setRemovingReplicas(Replicas.toList(this.removingReplicas)).setLeaderRecoveryState(this.leaderRecoveryState.value()).setIsNew(isNew);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.replicas), Arrays.hashCode(this.isr), Arrays.hashCode(this.removingReplicas), Arrays.hashCode(this.directories), Arrays.hashCode(this.elr), Arrays.hashCode(this.lastKnownElr), Arrays.hashCode(this.addingReplicas), this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch});
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionRegistration)) {
            return false;
        }
        PartitionRegistration other = (PartitionRegistration)o;
        return Arrays.equals(this.replicas, other.replicas) && Arrays.equals(this.directories, other.directories) && Arrays.equals(this.isr, other.isr) && Arrays.equals(this.removingReplicas, other.removingReplicas) && Arrays.equals(this.addingReplicas, other.addingReplicas) && Arrays.equals(this.elr, other.elr) && Arrays.equals(this.lastKnownElr, other.lastKnownElr) && this.leader == other.leader && this.leaderRecoveryState == other.leaderRecoveryState && this.leaderEpoch == other.leaderEpoch && this.partitionEpoch == other.partitionEpoch;
    }

    public String toString() {
        return "PartitionRegistration(replicas=" + Arrays.toString(this.replicas) + ", directories=" + Arrays.toString(this.directories) + ", isr=" + Arrays.toString(this.isr) + ", removingReplicas=" + Arrays.toString(this.removingReplicas) + ", addingReplicas=" + Arrays.toString(this.addingReplicas) + ", elr=" + Arrays.toString(this.elr) + ", lastKnownElr=" + Arrays.toString(this.lastKnownElr) + ", leader=" + this.leader + ", leaderRecoveryState=" + String.valueOf((Object)this.leaderRecoveryState) + ", leaderEpoch=" + this.leaderEpoch + ", partitionEpoch=" + this.partitionEpoch + ")";
    }

    public static class Builder {
        private int[] replicas;
        private Uuid[] directories;
        private int[] isr;
        private int[] removingReplicas = Replicas.NONE;
        private int[] addingReplicas = Replicas.NONE;
        private int[] elr = Replicas.NONE;
        private int[] lastKnownElr = Replicas.NONE;
        private Integer leader;
        private LeaderRecoveryState leaderRecoveryState;
        private Integer leaderEpoch;
        private Integer partitionEpoch;

        public Builder setReplicas(int[] replicas) {
            this.replicas = replicas;
            return this;
        }

        public Builder setDirectories(Uuid[] directories) {
            this.directories = directories;
            return this;
        }

        public Builder setIsr(int[] isr) {
            this.isr = isr;
            return this;
        }

        public Builder setRemovingReplicas(int[] removingReplicas) {
            this.removingReplicas = removingReplicas;
            return this;
        }

        public Builder setAddingReplicas(int[] addingReplicas) {
            this.addingReplicas = addingReplicas;
            return this;
        }

        public Builder setElr(int[] elr) {
            this.elr = elr;
            return this;
        }

        public Builder setLastKnownElr(int[] lastKnownElr) {
            this.lastKnownElr = lastKnownElr;
            return this;
        }

        public Builder setLeader(Integer leader) {
            this.leader = leader;
            return this;
        }

        public Builder setLeaderRecoveryState(LeaderRecoveryState leaderRecoveryState) {
            this.leaderRecoveryState = leaderRecoveryState;
            return this;
        }

        public Builder setLeaderEpoch(Integer leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setPartitionEpoch(Integer partitionEpoch) {
            this.partitionEpoch = partitionEpoch;
            return this;
        }

        public PartitionRegistration build() {
            if (this.replicas == null) {
                throw new IllegalStateException("You must set replicas.");
            }
            if (this.directories == null) {
                throw new IllegalStateException("You must set directories.");
            }
            if (this.directories.length != this.replicas.length) {
                throw new IllegalStateException("The lengths for replicas and directories do not match.");
            }
            if (this.isr == null) {
                throw new IllegalStateException("You must set isr.");
            }
            if (this.removingReplicas == null) {
                throw new IllegalStateException("You must set removing replicas.");
            }
            if (this.addingReplicas == null) {
                throw new IllegalStateException("You must set adding replicas.");
            }
            if (this.leader == null) {
                throw new IllegalStateException("You must set leader.");
            }
            if (this.leaderRecoveryState == null) {
                throw new IllegalStateException("You must set leader recovery state.");
            }
            if (this.leaderEpoch == null) {
                throw new IllegalStateException("You must set leader epoch.");
            }
            if (this.partitionEpoch == null) {
                throw new IllegalStateException("You must set partition epoch.");
            }
            if (this.elr == null) {
                throw new IllegalStateException("You must set ELR.");
            }
            if (this.lastKnownElr == null) {
                throw new IllegalStateException("You must set last known elr.");
            }
            return new PartitionRegistration(this.replicas, this.directories, this.isr, this.removingReplicas, this.addingReplicas, this.leader, this.leaderRecoveryState, this.leaderEpoch, this.partitionEpoch, this.elr, this.lastKnownElr);
        }
    }
}

