/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import org.apache.kyuubi.operation.ExecutionMode$;
import org.apache.kyuubi.operation.ParseMode$;
import org.apache.kyuubi.operation.PhysicalMode$;
import org.apache.kyuubi.operation.PlanOnlyMode;
import org.apache.kyuubi.operation.PlanOnlyMode$;
import org.apache.kyuubi.operation.UnknownMode$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0005\n\u0001?!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005+\u0001\t\u0015\r\u0011\"\u0011,\u0011!I\u0004A!A!\u0002\u0013a\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\")!\u000b\u0001C\u0001'\"91\f\u0001b\u0001\n\u0013a\u0006BB2\u0001A\u0003%Q\fC\u0004e\u0001\t\u0007I\u0011B\u0016\t\r\u0015\u0004\u0001\u0015!\u0003-\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0015m\u0011\u0015\u0001\b\u0001\"\u0015m\u0011\u0015\t\b\u0001\"\u0003s\u0005E\u0001F.\u00198P]2L8\u000b^1uK6,g\u000e\u001e\u0006\u0003'Q\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005U1\u0012!\u00024mS:\\'BA\f\u0019\u0003\u0019)gnZ5oK*\u0011\u0011DG\u0001\u0007Wf,XOY5\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\t!#\u0003\u0002$%\tqa\t\\5oW>\u0003XM]1uS>t\u0017aB:fgNLwN\u001c\t\u0003M!j\u0011a\n\u0006\u0003IaI!!K\u0014\u0003\u000fM+7o]5p]\u0006I1\u000f^1uK6,g\u000e^\u000b\u0002YA\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014AC:uCR,W.\u001a8uA\u0005!Qn\u001c3f!\tad(D\u0001>\u0015\t\u0019\u0002$\u0003\u0002@{\ta\u0001\u000b\\1o\u001f:d\u00170T8eK\u0006a\u0011/^3ssRKW.Z8viB\u0011!iQ\u0007\u0002e%\u0011AI\r\u0002\u0005\u0019>tw-A\u0007sKN,H\u000e^'bqJ{wo\u001d\t\u0003\u0005\u001eK!\u0001\u0013\u001a\u0003\u0007%sG/\u0001\nsKN,H\u000e\u001e$fi\u000eDG+[7f_V$\bCA&Q\u001b\u0005a%BA'O\u0003!!WO]1uS>t'BA(3\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003#2\u0013\u0001\u0002R;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fQ+fk\u0016-Z5B\u0011\u0011\u0005\u0001\u0005\u0006I!\u0001\r!\n\u0005\u0006U!\u0001\r\u0001\f\u0005\u0006u!\u0001\ra\u000f\u0005\u0006\u0001\"\u0001\r!\u0011\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006\u0013\"\u0001\rAS\u0001\r_B,'/\u0019;j_:dunZ\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001-P\u0001\u0004Y><\u0017B\u00012`\u00051y\u0005/\u001a:bi&|g\u000eT8h\u00035y\u0007/\u001a:bi&|g\u000eT8hA\u0005iA.\u001b8f'\u0016\u0004\u0018M]1u_J\fa\u0002\\5oKN+\u0007/\u0019:bi>\u0014\b%A\bhKR|\u0005/\u001a:bi&|g\u000eT8h+\u0005A\u0007c\u0001\"j;&\u0011!N\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013\t,gm\u001c:f%VtG#A7\u0011\u0005\ts\u0017BA83\u0005\u0011)f.\u001b;\u0002\u0017I,h.\u00138uKJt\u0017\r\\\u0001\u0011Kb\u0004H.Y5o\u001fB,'/\u0019;j_:$\"!\\:\t\u000b)\u0002\u0002\u0019\u0001\u0017")
public class PlanOnlyStatement
extends FlinkOperation {
    private final String statement;
    private final PlanOnlyMode mode;
    private final long queryTimeout;
    private final int resultMaxRows;
    private final Duration resultFetchTimeout;
    private final OperationLog operationLog;
    private final String lineSeparator;

    @Override
    public String statement() {
        return this.statement;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        super.beforeRun();
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor(this.queryTimeout);
        try {
            Operation operation;
            java.util.List operations = this.executor().getTableEnvironment().getParser().parse(this.statement());
            Preconditions.checkArgument(operations.size() == 1, "Plan-only mode supports single statement only", new Object[]{null});
            Operation operation2 = operation = (Operation)operations.get(0);
            if (operation2 instanceof SetOperation ? true : (operation2 instanceof ResetOperation ? true : (operation2 instanceof AddJarOperation ? true : (operation2 instanceof RemoveJarOperation ? true : operation2 instanceof ShowJarsOperation)))) {
                ResultFetcher resultFetcher = this.executor().executeStatement(new OperationHandle(this.getHandle().identifier()), this.statement());
                this.resultSet_$eq(ResultSetUtil$.MODULE$.fromResultFetcher(resultFetcher, this.resultMaxRows, this.resultFetchTimeout));
            } else {
                this.explainOperation(this.statement());
            }
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
    }

    private void explainOperation(String statement) {
        String string;
        TableEnvironmentInternal tableEnv = this.executor().getTableEnvironment();
        String[] explainPlans = tableEnv.explainSql(statement, new ExplainDetail[0]).split(new StringBuilder(0).append(this.lineSeparator()).append(this.lineSeparator()).toString());
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[0].split(new StringBuilder(26).append("== Abstract Syntax Tree ==").append(this.lineSeparator()).toString())[1];
        } else if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[1].split(new StringBuilder(29).append("== Optimized Physical Plan ==").append(this.lineSeparator()).toString())[1];
        } else if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[2].split(new StringBuilder(30).append("== Optimized Execution Plan ==").append(this.lineSeparator()).toString())[1];
        } else {
            if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
                throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
            }
            throw PlanOnlyMode$.MODULE$.notSupportedModeError(this.mode, "Flink SQL");
        }
        String operationPlan = string;
        this.resultSet_$eq(ResultSetUtil$.MODULE$.stringListToResultSet((List<String>)new .colon.colon((Object)operationPlan, (List)Nil$.MODULE$), "plan"));
    }

    public PlanOnlyStatement(Session session, String statement, PlanOnlyMode mode, long queryTimeout, int resultMaxRows, Duration resultFetchTimeout) {
        this.statement = statement;
        this.mode = mode;
        this.queryTimeout = queryTimeout;
        this.resultMaxRows = resultMaxRows;
        this.resultFetchTimeout = resultFetchTimeout;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.lineSeparator = System.lineSeparator();
    }
}

