/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.sql.zorder;

import java.io.Serializable;
import org.apache.kyuubi.sql.KyuubiSQLExtensionException;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class ZorderBytesUtils$ {
    public static ZorderBytesUtils$ MODULE$;

    static {
        new ZorderBytesUtils$();
    }

    private final int BIT_8_MASK() {
        return 128;
    }

    private final int BIT_16_MASK() {
        return 32768;
    }

    private final int BIT_32_MASK() {
        return Integer.MIN_VALUE;
    }

    private final long BIT_64_MASK() {
        return Long.MIN_VALUE;
    }

    public byte[] interleaveBits(Object[] inputs) {
        byte[] byArray;
        int n = inputs.length;
        switch (n) {
            case 1: {
                byArray = this.longToByte(this.toLong(inputs[0]));
                break;
            }
            case 2: {
                byArray = this.interleave2Longs(this.toLong(inputs[0]), this.toLong(inputs[1]));
                break;
            }
            case 3: {
                byArray = this.interleave3Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]));
                break;
            }
            case 4: {
                byArray = this.interleave4Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]), this.toLong(inputs[3]));
                break;
            }
            case 5: {
                byArray = this.interleave5Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]), this.toLong(inputs[3]), this.toLong(inputs[4]));
                break;
            }
            case 6: {
                byArray = this.interleave6Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]), this.toLong(inputs[3]), this.toLong(inputs[4]), this.toLong(inputs[5]));
                break;
            }
            case 7: {
                byArray = this.interleave7Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]), this.toLong(inputs[3]), this.toLong(inputs[4]), this.toLong(inputs[5]), this.toLong(inputs[6]));
                break;
            }
            case 8: {
                byArray = this.interleave8Longs(this.toLong(inputs[0]), this.toLong(inputs[1]), this.toLong(inputs[2]), this.toLong(inputs[3]), this.toLong(inputs[4]), this.toLong(inputs[5]), this.toLong(inputs[6]), this.toLong(inputs[7]));
                break;
            }
            default: {
                byArray = this.interleaveBitsDefault((byte[][])Predef$.MODULE$.genericArrayOps((Object)inputs).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toByteArray(a), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
                break;
            }
        }
        return byArray;
    }

    private byte[] interleave2Longs(long l1, long l2) {
        byte[] result = new byte[16];
        for (int i = 0; i < 8; ++i) {
            short tmp1 = (short)(l1 >> i * 8 & 0xFFL);
            short tmp2 = (short)(l2 >> i * 8 & 0xFFL);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int x_masked = tmp1 & 1 << j;
                int y_masked = tmp2 & 1 << j;
                z |= x_masked << j;
                z |= y_masked << j + 1;
            }
            result[(7 - i) * 2 + 1] = (byte)(z & 0xFF);
            result[(7 - i) * 2] = (byte)(z >> 8 & 0xFF);
        }
        return result;
    }

    private byte[] interleave3Longs(long l1, long l2, long l3) {
        byte[] result = new byte[24];
        for (int i = 0; i < 8; ++i) {
            int tmp1 = (int)(l1 >> i * 8 & 0xFFL);
            int tmp2 = (int)(l2 >> i * 8 & 0xFFL);
            int tmp3 = (int)(l3 >> i * 8 & 0xFFL);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int r1_mask = tmp1 & 1 << j;
                int r2_mask = tmp2 & 1 << j;
                int r3_mask = tmp3 & 1 << j;
                z |= r1_mask << 2 * j | r2_mask << 2 * j + 1 | r3_mask << 2 * j + 2;
            }
            result[(7 - i) * 3 + 2] = (byte)(z & 0xFF);
            result[(7 - i) * 3 + 1] = (byte)(z >> 8 & 0xFF);
            result[(7 - i) * 3] = (byte)(z >> 16 & 0xFF);
        }
        return result;
    }

    private byte[] interleave4Longs(long l1, long l2, long l3, long l4) {
        byte[] result = new byte[32];
        for (int i = 0; i < 8; ++i) {
            int tmp1 = (int)(l1 >> i * 8 & 0xFFL);
            int tmp2 = (int)(l2 >> i * 8 & 0xFFL);
            int tmp3 = (int)(l3 >> i * 8 & 0xFFL);
            int tmp4 = (int)(l4 >> i * 8 & 0xFFL);
            int z = 0;
            for (int j = 0; j < 8; ++j) {
                int r1_mask = tmp1 & 1 << j;
                int r2_mask = tmp2 & 1 << j;
                int r3_mask = tmp3 & 1 << j;
                int r4_mask = tmp4 & 1 << j;
                z |= r1_mask << 3 * j | r2_mask << 3 * j + 1 | r3_mask << 3 * j + 2 | r4_mask << 3 * j + 3;
            }
            result[(7 - i) * 4 + 3] = (byte)(z & 0xFF);
            result[(7 - i) * 4 + 2] = (byte)(z >> 8 & 0xFF);
            result[(7 - i) * 4 + 1] = (byte)(z >> 16 & 0xFF);
            result[(7 - i) * 4] = (byte)(z >> 24 & 0xFF);
        }
        return result;
    }

    private byte[] interleave5Longs(long l1, long l2, long l3, long l4, long l5) {
        byte[] result = new byte[40];
        for (int i = 0; i < 8; ++i) {
            long tmp1 = l1 >> i * 8 & 0xFFL;
            long tmp2 = l2 >> i * 8 & 0xFFL;
            long tmp3 = l3 >> i * 8 & 0xFFL;
            long tmp4 = l4 >> i * 8 & 0xFFL;
            long tmp5 = l5 >> i * 8 & 0xFFL;
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = tmp1 & (long)(1 << j);
                long r2_mask = tmp2 & (long)(1 << j);
                long r3_mask = tmp3 & (long)(1 << j);
                long r4_mask = tmp4 & (long)(1 << j);
                long r5_mask = tmp5 & (long)(1 << j);
                z |= r1_mask << 4 * j | r2_mask << 4 * j + 1 | r3_mask << 4 * j + 2 | r4_mask << 4 * j + 3 | r5_mask << 4 * j + 4;
            }
            result[(7 - i) * 5 + 4] = (byte)(z & 0xFFL);
            result[(7 - i) * 5 + 3] = (byte)(z >> 8 & 0xFFL);
            result[(7 - i) * 5 + 2] = (byte)(z >> 16 & 0xFFL);
            result[(7 - i) * 5 + 1] = (byte)(z >> 24 & 0xFFL);
            result[(7 - i) * 5] = (byte)(z >> 32 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave6Longs(long l1, long l2, long l3, long l4, long l5, long l6) {
        byte[] result = new byte[48];
        for (int i = 0; i < 8; ++i) {
            long tmp1 = l1 >> i * 8 & 0xFFL;
            long tmp2 = l2 >> i * 8 & 0xFFL;
            long tmp3 = l3 >> i * 8 & 0xFFL;
            long tmp4 = l4 >> i * 8 & 0xFFL;
            long tmp5 = l5 >> i * 8 & 0xFFL;
            long tmp6 = l6 >> i * 8 & 0xFFL;
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = tmp1 & (long)(1 << j);
                long r2_mask = tmp2 & (long)(1 << j);
                long r3_mask = tmp3 & (long)(1 << j);
                long r4_mask = tmp4 & (long)(1 << j);
                long r5_mask = tmp5 & (long)(1 << j);
                long r6_mask = tmp6 & (long)(1 << j);
                z |= r1_mask << 5 * j | r2_mask << 5 * j + 1 | r3_mask << 5 * j + 2 | r4_mask << 5 * j + 3 | r5_mask << 5 * j + 4 | r6_mask << 5 * j + 5;
            }
            result[(7 - i) * 6 + 5] = (byte)(z & 0xFFL);
            result[(7 - i) * 6 + 4] = (byte)(z >> 8 & 0xFFL);
            result[(7 - i) * 6 + 3] = (byte)(z >> 16 & 0xFFL);
            result[(7 - i) * 6 + 2] = (byte)(z >> 24 & 0xFFL);
            result[(7 - i) * 6 + 1] = (byte)(z >> 32 & 0xFFL);
            result[(7 - i) * 6] = (byte)(z >> 40 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave7Longs(long l1, long l2, long l3, long l4, long l5, long l6, long l7) {
        byte[] result = new byte[56];
        for (int i = 0; i < 8; ++i) {
            long tmp1 = l1 >> i * 8 & 0xFFL;
            long tmp2 = l2 >> i * 8 & 0xFFL;
            long tmp3 = l3 >> i * 8 & 0xFFL;
            long tmp4 = l4 >> i * 8 & 0xFFL;
            long tmp5 = l5 >> i * 8 & 0xFFL;
            long tmp6 = l6 >> i * 8 & 0xFFL;
            long tmp7 = l7 >> i * 8 & 0xFFL;
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = tmp1 & (long)(1 << j);
                long r2_mask = tmp2 & (long)(1 << j);
                long r3_mask = tmp3 & (long)(1 << j);
                long r4_mask = tmp4 & (long)(1 << j);
                long r5_mask = tmp5 & (long)(1 << j);
                long r6_mask = tmp6 & (long)(1 << j);
                long r7_mask = tmp7 & (long)(1 << j);
                z |= r1_mask << 6 * j | r2_mask << 6 * j + 1 | r3_mask << 6 * j + 2 | r4_mask << 6 * j + 3 | r5_mask << 6 * j + 4 | r6_mask << 6 * j + 5 | r7_mask << 6 * j + 6;
            }
            result[(7 - i) * 7 + 6] = (byte)(z & 0xFFL);
            result[(7 - i) * 7 + 5] = (byte)(z >> 8 & 0xFFL);
            result[(7 - i) * 7 + 4] = (byte)(z >> 16 & 0xFFL);
            result[(7 - i) * 7 + 3] = (byte)(z >> 24 & 0xFFL);
            result[(7 - i) * 7 + 2] = (byte)(z >> 32 & 0xFFL);
            result[(7 - i) * 7 + 1] = (byte)(z >> 40 & 0xFFL);
            result[(7 - i) * 7] = (byte)(z >> 48 & 0xFFL);
        }
        return result;
    }

    private byte[] interleave8Longs(long l1, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        byte[] result = new byte[64];
        for (int i = 0; i < 8; ++i) {
            long tmp1 = l1 >> i * 8 & 0xFFL;
            long tmp2 = l2 >> i * 8 & 0xFFL;
            long tmp3 = l3 >> i * 8 & 0xFFL;
            long tmp4 = l4 >> i * 8 & 0xFFL;
            long tmp5 = l5 >> i * 8 & 0xFFL;
            long tmp6 = l6 >> i * 8 & 0xFFL;
            long tmp7 = l7 >> i * 8 & 0xFFL;
            long tmp8 = l8 >> i * 8 & 0xFFL;
            long z = 0L;
            for (int j = 0; j < 8; ++j) {
                long r1_mask = tmp1 & (long)(1 << j);
                long r2_mask = tmp2 & (long)(1 << j);
                long r3_mask = tmp3 & (long)(1 << j);
                long r4_mask = tmp4 & (long)(1 << j);
                long r5_mask = tmp5 & (long)(1 << j);
                long r6_mask = tmp6 & (long)(1 << j);
                long r7_mask = tmp7 & (long)(1 << j);
                long r8_mask = tmp8 & (long)(1 << j);
                z |= r1_mask << 7 * j | r2_mask << 7 * j + 1 | r3_mask << 7 * j + 2 | r4_mask << 7 * j + 3 | r5_mask << 7 * j + 4 | r6_mask << 7 * j + 5 | r7_mask << 7 * j + 6 | r8_mask << 7 * j + 7;
            }
            result[(7 - i) * 8 + 7] = (byte)(z & 0xFFL);
            result[(7 - i) * 8 + 6] = (byte)(z >> 8 & 0xFFL);
            result[(7 - i) * 8 + 5] = (byte)(z >> 16 & 0xFFL);
            result[(7 - i) * 8 + 4] = (byte)(z >> 24 & 0xFFL);
            result[(7 - i) * 8 + 3] = (byte)(z >> 32 & 0xFFL);
            result[(7 - i) * 8 + 2] = (byte)(z >> 40 & 0xFFL);
            result[(7 - i) * 8 + 1] = (byte)(z >> 48 & 0xFFL);
            result[(7 - i) * 8] = (byte)(z >> 56 & 0xFFL);
        }
        return result;
    }

    public byte[] interleaveBitsDefault(byte[][] arrays) {
        IntRef totalLength = IntRef.create((int)0);
        IntRef maxLength = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrays)).foreach((Function1 & Serializable & scala.Serializable)array -> {
            ZorderBytesUtils$.$anonfun$interleaveBitsDefault$1(totalLength, maxLength, array);
            return BoxedUnit.UNIT;
        });
        byte[] result = new byte[totalLength.elem];
        IntRef resultBit = IntRef.create((int)0);
        for (int bit = 0; bit < maxLength.elem; ++bit) {
            int bytePos = bit / 8;
            int bitPos = bit % 8;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrays)).foreach((Function1 & Serializable & scala.Serializable)arr -> {
                ZorderBytesUtils$.$anonfun$interleaveBitsDefault$2(bytePos, totalLength, resultBit, result, bitPos, arr);
                return BoxedUnit.UNIT;
            });
        }
        return result;
    }

    public byte updatePos(byte a, int apos, byte b, int bpos) {
        byte temp = (byte)(b & 1 << bpos);
        if (apos > bpos) {
            temp = (byte)(temp << apos - bpos);
        } else if (apos < bpos) {
            temp = (byte)(temp >> bpos - apos);
        }
        byte atemp = (byte)(a & 1 << apos);
        if (atemp == temp) {
            return a;
        }
        return (byte)(a ^ 1 << apos);
    }

    public long toLong(Object a) {
        long l;
        Object object = a;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            l = (long)(bl ? 1 : 0) ^ Long.MIN_VALUE;
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            l = (long)by ^ Long.MIN_VALUE;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            l = (long)s ^ Long.MIN_VALUE;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            l = (long)n ^ Long.MIN_VALUE;
        } else if (object instanceof Long) {
            long l2 = BoxesRunTime.unboxToLong((Object)object);
            l = l2 ^ Long.MIN_VALUE;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            l = (long)Float.floatToRawIntBits(f) ^ Long.MIN_VALUE;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            l = Double.doubleToRawLongBits(d) ^ Long.MIN_VALUE;
        } else if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            l = uTF8String.getPrefix();
        } else if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            l = decimal.toLong() ^ Long.MIN_VALUE;
        } else {
            if (object instanceof Object) {
                Object object2 = object;
                throw new KyuubiSQLExtensionException(new StringBuilder(26).append("Unsupported z-order type: ").append(object2.getClass()).toString());
            }
            throw new MatchError(object);
        }
        return l;
    }

    public byte[] toByteArray(Object a) {
        byte[] byArray;
        Object object = a;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            byArray = this.booleanToByte(bl);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            byArray = this.byteToByte(by);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            byArray = this.shortToByte(s);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            byArray = this.intToByte(n);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            byArray = this.longToByte(l);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            byArray = this.floatToByte(f);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            byArray = this.doubleToByte(d);
        } else if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            byArray = this.paddingTo8Byte(uTF8String.getBytes());
        } else if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            byArray = this.longToByte(decimal.toLong());
        } else {
            if (object instanceof Object) {
                Object object2 = object;
                throw new KyuubiSQLExtensionException(new StringBuilder(26).append("Unsupported z-order type: ").append(object2.getClass()).toString());
            }
            throw new MatchError(object);
        }
        return byArray;
    }

    public byte[] booleanToByte(boolean a) {
        return a ? this.byteToByte((byte)1) : this.byteToByte((byte)0);
    }

    public byte[] byteToByte(byte a) {
        byte tmp = (byte)(a ^ 0x80);
        return new byte[]{tmp};
    }

    public byte[] shortToByte(short a) {
        int tmp = a ^ 0x8000;
        return new byte[]{(byte)(tmp >> 8 & 0xFF), (byte)(tmp & 0xFF)};
    }

    /*
     * WARNING - void declaration
     */
    public byte[] intToByte(int a) {
        void var2_2;
        byte[] result = new byte[4];
        int tmp = a ^ Integer.MIN_VALUE;
        for (int i = 0; i <= 3; ++i) {
            int offset = i * 8;
            result[3 - i] = (byte)(tmp >> offset & 0xFF);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] longToByte(long a) {
        void var3_2;
        byte[] result = new byte[8];
        long tmp = a ^ Long.MIN_VALUE;
        for (int i = 0; i <= 7; ++i) {
            int offset = i * 8;
            result[7 - i] = (byte)(tmp >> offset & 0xFFL);
        }
        return var3_2;
    }

    public byte[] floatToByte(float a) {
        int fi = Float.floatToRawIntBits(a);
        return this.intToByte(fi);
    }

    public byte[] doubleToByte(double a) {
        long dl = Double.doubleToRawLongBits(a);
        return this.longToByte(dl);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] paddingTo8Byte(byte[] a) {
        byte[] byArray;
        int len = a.length;
        if (len == 8) {
            byArray = a;
        } else if (len > 8) {
            void var3_3;
            byte[] result = new byte[8];
            System.arraycopy(a, 0, result, 0, 8);
            byArray = var3_3;
        } else {
            byte[] result = new byte[8];
            System.arraycopy(a, 0, result, 8 - len, len);
            byArray = result;
        }
        return byArray;
    }

    public byte[] defaultByteArrayValue(DataType dataType) {
        return this.toByteArray(this.defaultValue(dataType));
    }

    public Object defaultValue(DataType dataType) {
        Comparable<Boolean> comparable;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToBoolean((boolean)true);
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToByte((byte)127);
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToShort((short)Short.MAX_VALUE);
        } else {
            boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2);
            if (bl) {
                comparable = BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE);
            } else {
                boolean bl2 = LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DecimalType);
                if (bl2) {
                    comparable = BoxesRunTime.boxToLong((long)Long.MAX_VALUE);
                } else if (FloatType$.MODULE$.equals(dataType2)) {
                    comparable = BoxesRunTime.boxToFloat((float)Float.MAX_VALUE);
                } else if (DoubleType$.MODULE$.equals(dataType2)) {
                    comparable = BoxesRunTime.boxToDouble((double)Double.MAX_VALUE);
                } else if (StringType$.MODULE$.equals(dataType2)) {
                    comparable = UTF8String.fromBytes((byte[])this.longToByte(Long.MAX_VALUE));
                } else {
                    if (dataType2 != null) {
                        DataType dataType3 = dataType2;
                        throw new KyuubiSQLExtensionException(new StringBuilder(26).append("Unsupported z-order type: ").append(dataType3.catalogString()).toString());
                    }
                    throw new MatchError((Object)dataType2);
                }
            }
        }
        return comparable;
    }

    public static final /* synthetic */ void $anonfun$interleaveBitsDefault$1(IntRef totalLength$1, IntRef maxLength$1, byte[] array) {
        totalLength$1.elem += array.length;
        maxLength$1.elem = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxLength$1.elem), array.length * 8);
    }

    public static final /* synthetic */ void $anonfun$interleaveBitsDefault$2(int bytePos$1, IntRef totalLength$1, IntRef resultBit$1, byte[] result$1, int bitPos$1, byte[] arr) {
        block0: {
            int len = arr.length;
            if (bytePos$1 >= len) break block0;
            int resultBytePos = totalLength$1.elem - 1 - resultBit$1.elem / 8;
            int resultBitPos = resultBit$1.elem % 8;
            result$1[resultBytePos] = MODULE$.updatePos(result$1[resultBytePos], resultBitPos, arr[len - 1 - bytePos$1], bitPos$1);
            ++resultBit$1.elem;
        }
    }

    private ZorderBytesUtils$() {
        MODULE$ = this;
    }
}

