/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.util;

import java.io.Serializable;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.ctl.util.DateTimeUtils$;
import org.apache.kyuubi.ctl.util.Tabulator$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Render$ {
    public static Render$ MODULE$;
    private final String[] batchColumnNames;

    static {
        new Render$();
    }

    public String renderServiceNodesInfo(String title, Seq<ServiceNodeInfo> serviceNodeInfo) {
        String[] header = (String[])((Object[])new String[]{"Namespace", "Host", "Port", "Version"});
        String[][] rows = (String[][])((TraversableOnce)((TraversableLike)serviceNodeInfo.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.nodeName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)sn -> (String[])((Object[])new String[]{sn.namespace(), sn.host(), Integer.toString(sn.port()), (String)sn.version().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")}), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    public String renderBatchListInfo(GetBatchesResponse batchListInfo) {
        String title = new StringBuilder(25).append("Batch List (from ").append(batchListInfo.getFrom()).append(" total ").append(batchListInfo.getTotal()).append(")").toString();
        String[][] rows = (String[][])((TraversableOnce)((TraversableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchListInfo.getBatches()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getCreateTime()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)batch -> MODULE$.buildBatchRow((Batch)batch), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        return Tabulator$.MODULE$.format(title, this.batchColumnNames(), rows);
    }

    public String renderBatchInfo(Batch batch) {
        String title = new StringBuilder(15).append("Batch Report (").append(batch.getId()).append(")").toString();
        String[] header = (String[])((Object[])new String[]{"Key", "Value"});
        String[][] rows = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.batchColumnNames())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.buildBatchRow(batch)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String[] stringArray = (String[])((Object[])new String[]{k, v});
            return stringArray;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        return Tabulator$.MODULE$.format(title, header, rows);
    }

    private String[] batchColumnNames() {
        return this.batchColumnNames;
    }

    private String[] buildBatchRow(Batch batch) {
        return (String[])((Object[])new String[]{batch.getId(), batch.getBatchType(), batch.getName(), batch.getUser(), batch.getState(), this.buildBatchAppInfo(batch).mkString("\n"), batch.getKyuubiInstance(), ((TraversableOnce)new .colon.colon((Object)DateTimeUtils$.MODULE$.millisToDateString(batch.getCreateTime(), "yyyy-MM-dd HH:mm:ss"), (List)new .colon.colon((Object)DateTimeUtils$.MODULE$.millisToDateString(batch.getEndTime(), "yyyy-MM-dd HH:mm:ss"), (List)Nil$.MODULE$))).mkString("\n~\n")});
    }

    private List<String> buildBatchAppInfo(Batch batch) {
        ListBuffer batchAppInfo = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)batch.getAppId()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> batchAppInfo.$plus$eq((Object)new StringBuilder(8).append("App Id: ").append(batch.getAppId()).toString()));
        Option$.MODULE$.apply((Object)batch.getAppUrl()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> batchAppInfo.$plus$eq((Object)new StringBuilder(9).append("App Url: ").append(batch.getAppUrl()).toString()));
        Option$.MODULE$.apply((Object)batch.getAppState()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> batchAppInfo.$plus$eq((Object)new StringBuilder(11).append("App State: ").append(batch.getAppState()).toString()));
        Option$.MODULE$.apply((Object)batch.getAppDiagnostic()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Render$.$anonfun$buildBatchAppInfo$4(x$6))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> batchAppInfo.$plus$eq((Object)new StringBuilder(16).append("App Diagnostic: ").append(batch.getAppDiagnostic()).toString()));
        return batchAppInfo.toList();
    }

    public static final /* synthetic */ boolean $anonfun$buildBatchAppInfo$4(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    private Render$() {
        MODULE$ = this;
        this.batchColumnNames = (String[])((Object[])new String[]{"Batch Id", "Type", "Name", "User", "State", "Batch App Info", "Kyuubi Instance", "Time Range"});
    }
}

