/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ExecPoolStatistic;
import org.apache.kyuubi.client.api.v1.dto.GetColumnsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetCrossReferenceRequest;
import org.apache.kyuubi.client.api.v1.dto.GetFunctionsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetPrimaryKeysRequest;
import org.apache.kyuubi.client.api.v1.dto.GetSchemasRequest;
import org.apache.kyuubi.client.api.v1.dto.GetTablesRequest;
import org.apache.kyuubi.client.api.v1.dto.InfoDetail;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.client.api.v1.dto.SessionHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenCount;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenRequest;
import org.apache.kyuubi.client.api.v1.dto.StatementRequest;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rme!B\u000b\u0017\u0001Y\u0011\u0003\"B\u0019\u0001\t\u0003\u0019\u0004\"\u0002\u001c\u0001\t\u00079\u0004\"B&\u0001\t\u0013a\u0005\"\u0002)\u0001\t\u0003\t\u0006bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002p\u0002!\t!!=\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!1\t\u0001\u0005\u0002\t\u0015\u0003b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqA!2\u0001\t\u0003\u00119\rC\u0004\u0003f\u0002!\tAa:\t\u000f\tu\b\u0001\"\u0001\u0003\u0000\"91Q\u0004\u0001\u0005\u0002\r}\u0001bBB\u001f\u0001\u0011\u00051q\b\u0005\b\u0007;\u0002A\u0011AB0\u0005A\u0019Vm]:j_:\u001c(+Z:pkJ\u001cWM\u0003\u0002\u00181\u0005\u0011a/\r\u0006\u00033i\t1!\u00199j\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0003;y\taa[=vk\nL'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001cB\u0001A\u0012*[A\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0016\u000e\u0003aI!\u0001\f\r\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0002/_5\tA$\u0003\u000219\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003Q\u0002\"!\u000e\u0001\u000e\u0003Y\tq\u0002^8TKN\u001c\u0018n\u001c8IC:$G.\u001a\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u000f\u0002\u000fM,7o]5p]&\u0011QH\u000f\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000b}\u0012\u0001\u0019\u0001!\u0002\u0007M$(\u000f\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007\u0016j\u0011\u0001\u0012\u0006\u0003\u000bJ\na\u0001\u0010:p_Rt\u0014BA$&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d+\u0013AD:fgNLwN\\'b]\u0006<WM]\u000b\u0002\u001bB\u0011\u0011HT\u0005\u0003\u001fj\u0012abU3tg&|g.T1oC\u001e,'/\u0001\u0005tKN\u001c\u0018n\u001c8t)\u0005\u0011\u0006cA*Y7:\u0011AK\u0016\b\u0003\u0007VK\u0011AJ\u0005\u0003/\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\n\u00191+Z9\u000b\u0005]+\u0003C\u0001/d\u001b\u0005i&B\u00010`\u0003\r!Go\u001c\u0006\u0003/\u0001T!!G1\u000b\u0005\td\u0012AB2mS\u0016tG/\u0003\u0002e;\nY1+Z:tS>tG)\u0019;bQ\t!a\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006\u0011!o\u001d\u0006\u0003W2\f!a^:\u000b\u00035\fQA[1wCbL!a\u001c5\u0003\u0007\u001d+E\u000b\u000b\b\u0005c\u0006\r\u0011QAA\u0005\u0003\u0017\tI$a\u000f\u0011\u0005I|X\"A:\u000b\u0005Q,\u0018!\u0003:fgB|gn]3t\u0015\t1x/A\u0006b]:|G/\u0019;j_:\u001c(B\u0001=z\u0003\ry\u0017m\u001d\u0006\u0003un\f!A^\u001a\u000b\u0005ql\u0018aB:xC\u001e<WM\u001d\u0006\u0002}\u0006\u0011\u0011n\\\u0005\u0004\u0003\u0003\u0019(aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f#!a\u0002\u0002\u0007I\u0002\u0004'A\u0004d_:$XM\u001c;-\u0005\u000551FCA\b\u00037\ti\"!\t\u0002$A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016U\fQ!\\3eS\u0006LA!!\u0007\u0002\u0014\t91i\u001c8uK:$\u0018!C7fI&\fG+\u001f9fC\t\ty\"\u0001\tbaBd\u0017nY1uS>twF[:p]\u0006)\u0011M\u001d:bs.2\u0011QEA\u0016\u0003[\u0001B!!\u0005\u0002(%!\u0011\u0011FA\n\u0005-\t%O]1z'\u000eDW-\\1\u0002\rM\u001c\u0007.Z7bW\u0019\ty#!\u000e\u00028A!\u0011\u0011CA\u0019\u0013\u0011\t\u0019$a\u0005\u0003\rM\u001b\u0007.Z7b\u00039IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u001c\u0013aW\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002>\u0005\ts-\u001a;!i\",\u0007\u0005\\5ti\u0002zg\rI1mY\u0002b\u0017N^3!g\u0016\u001c8/[8og\u0006Y1/Z:tS>t\u0017J\u001c4p)\u0011\t\u0019%a\u0014\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u001d\u0003\u0019)g/\u001a8ug&!\u0011QJA$\u0005-Y\u00150^;cS\u00163XM\u001c;\t\r\u0005ES\u00011\u0001A\u0003A\u0019Xm]:j_:D\u0015M\u001c3mKN#(\u000f\u000b\u0005\u0002P\u0005U\u00131LA/!\r9\u0017qK\u0005\u0004\u00033B'!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\t\ty&A\u0007tKN\u001c\u0018n\u001c8IC:$G.\u001a\u0015\b\u000b\u0005\r\u00141LA5!\r9\u0017QM\u0005\u0004\u0003OB'\u0001\u0002)bi\"\f#!a\u001b\u0002\u001fm\u001cXm]:j_:D\u0015M\u001c3mKvD#!\u00024)\u001d\u0015\t\u00181AA\u0003\u0003\u0013\t\t(!\u000f\u0002z1\u0012\u00111O\u0016\u000b\u0003\u001f\tY\"!\b\u0002,\u0005U4FBA\u0018\u0003k\t9h\t\u0002\u0002D\u0005\u0012\u00111P\u00012O\u0016$\b%\u0019\u0011tKN\u001c\u0018n\u001c8!KZ,g\u000e\u001e\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3s\u0003\u001d9W\r^%oM>$b!!!\u0002\b\u0006-\u0005c\u0001/\u0002\u0004&\u0019\u0011QQ/\u0003\u0015%sgm\u001c#fi\u0006LG\u000e\u0003\u0004\u0002R\u0019\u0001\r\u0001\u0011\u0015\t\u0003\u000f\u000b)&a\u0017\u0002^!9\u0011Q\u0012\u0004A\u0002\u0005=\u0015\u0001C5oM>$\u0016\u0010]3\u0011\u0007\u0011\n\t*C\u0002\u0002\u0014\u0016\u00121!\u00138uQ!\tY)!\u0016\u0002\\\u0005]\u0015EAAGQ\u001d1\u00111MA.\u00037\u000b#!!(\u0002?m\u001cXm]:j_:D\u0015M\u001c3mKv|\u0013N\u001c4p_mLgNZ8UsB,W\u0010\u000b\u0002\u0007M\"ra!]A\u0002\u0003\u000b\tI!a)\u0002:\u0005-FFAASW)\ty!a\u0007\u0002\u001e\u0005-\u0012qU\u0016\u0007\u0003_\t)$!+$\u0005\u0005\u0005\u0015EAAW\u0003Y;W\r\u001e\u0011bA%tgm\u001c:nCRLwN\u001c\u0011eKR\f\u0017\u000e\u001c\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3sA\u0005tG\rI1!gB,7-\u001b4jG\u0002JgNZ8s[\u0006$\u0018n\u001c8!if\u0004X-\u0001\u0007tKN\u001c\u0018n\u001c8D_VtG\u000f\u0006\u0002\u00024B\u0019A,!.\n\u0007\u0005]VL\u0001\tTKN\u001c\u0018n\u001c8Pa\u0016t7i\\;oi\":q!a\u0019\u0002\\\u0005m\u0016EAA_\u0003\u0015\u0019w.\u001e8uQ\t9a\r\u000b\b\bc\u0006\r\u0011QAA\u0005\u0003\u0007\fI$a3-\u0005\u0005\u00157FCA\b\u00037\ti\"a\u000b\u0002H.2\u0011qFA\u001b\u0003\u0013\u001c#!a-\"\u0005\u00055\u0017AI$fi\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!_B,g\u000eI:fgNLwN\u001c\u0011d_VtG/A\tfq\u0016\u001c\u0007k\\8m'R\fG/[:uS\u000e$\"!a5\u0011\u0007q\u000b).C\u0002\u0002Xv\u0013\u0011#\u0012=fGB{w\u000e\\*uCRL7\u000f^5dQ\u001dA\u00111MA.\u00037\f#!!8\u0002%\u0015DXm\u0019)p_2|3\u000f^1uSN$\u0018n\u0019\u0015\u0003\u0011\u0019Dc\u0002C9\u0002\u0004\u0005\u0015\u0011\u0011BAr\u0003s\tY\u000f\f\u0002\u0002f.R\u0011qBA\u000e\u0003;\tY#a:,\r\u0005=\u0012QGAuG\t\t\u0019.\t\u0002\u0002n\u0006Qs)\u001a;!gR\fG/[:uS\u000e\u0004\u0013N\u001c4pA=4\u0007EY1dW\u001e\u0014x.\u001e8eA\u0015DXmY;u_J\u001c\u0018aC8qK:\u001cVm]:j_:$B!a=\u0002xB\u0019A,!>\n\u0005uj\u0006bBA}\u0013\u0001\u0007\u00111`\u0001\be\u0016\fX/Z:u!\ra\u0016Q`\u0005\u0004\u0003\u007fl&AE*fgNLwN\\(qK:\u0014V-];fgRDs!\u0003B\u0002\u00037\u0012I\u0001E\u0002h\u0005\u000bI1Aa\u0002i\u0005!\u0019uN\\:v[\u0016\u001cHFAA\u000fQ\rI!Q\u0002\t\u0004O\n=\u0011b\u0001B\tQ\n!\u0001kT*UQ9I\u0011/a\u0001\u0002\u0006\u0005%!QCA\u001d\u00053a#Aa\u0006,\r\u0005=\u00111DA\u000fC\t\u0011Y\"\u0001\fPa\u0016t\u0007f\u0019:fCR,\u0017\u0006I1!g\u0016\u001c8/[8o\u00031\u0019Gn\\:f'\u0016\u001c8/[8o)\u0011\u0011\tC!\f\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\ni\u0003\u0011\u0019wN]3\n\t\t-\"Q\u0005\u0002\t%\u0016\u001c\bo\u001c8tK\"1\u0011\u0011\u000b\u0006A\u0002\u0001C\u0003B!\f\u0002V\u0005m\u0013Q\f\u0015\b\u0015\u0005\r\u00141LA5Q\rQ!Q\u0007\t\u0004O\n]\u0012b\u0001B\u001dQ\n1A)\u0012'F)\u0016CcBC9\u0002\u0004\u0005\u0015\u0011\u0011\u0002B\u001f\u0003s\u0011y\u0004\f\u0002\u0003\u0018\u0005\u0012!\u0011I\u0001\u0010\u00072|7/\u001a\u0011bAM,7o]5p]\u0006\u0001R\r_3dkR,7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0005\u000f\u0012\u0019Fa\u0016\u0011\t\t%#qJ\u0007\u0003\u0005\u0017R1A!\u0014\u001d\u0003%y\u0007/\u001a:bi&|g.\u0003\u0003\u0003R\t-#aD(qKJ\fG/[8o\u0011\u0006tG\r\\3\t\r\u0005E3\u00021\u0001AQ!\u0011\u0019&!\u0016\u0002\\\u0005u\u0003bBA}\u0017\u0001\u0007!\u0011\f\t\u00049\nm\u0013b\u0001B/;\n\u00012\u000b^1uK6,g\u000e\u001e*fcV,7\u000f\u001e\u0015\b\u0017\u0005\r\u00141\fB1C\t\u0011\u0019'\u0001\u0013|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7oL:uCR,W.\u001a8uQ\rY!Q\u0002\u0015\u000f\u0017E\f\u0019!!\u0002\u0002\n\t%\u0014\u0011\bB9Y\t\u0011Yg\u000b\u0006\u0002\u0010\u0005m\u0011QDA\u0016\u0005[Zc!a\f\u00026\t=4E\u0001B$C\t\u0011\u0019(A\u0018De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004S\tW#D+R+ul\u0015+B)\u0016kUI\u0014+!if\u0004X-A\u0006hKR$\u0016\u0010]3J]\u001a|G\u0003\u0002B$\u0005sBa!!\u0015\r\u0001\u0004\u0001\u0005\u0006\u0003B=\u0003+\nY&!\u0018)\u000f1\t\u0019'a\u0017\u0003\u0000\u0005\u0012!\u0011Q\u0001$wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018usB,\u0017J\u001c4pQ\ra!Q\u0002\u0015\u000f\u0019E\f\u0019!!\u0002\u0002\n\t\u001d\u0015\u0011\bBEY\t\u0011Y'\t\u0002\u0003\f\u0006Y3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#v\fV-Q\u000b~KeJR(!if\u0004X-A\u0006hKR\u001c\u0015\r^1m_\u001e\u001cH\u0003\u0002B$\u0005#Ca!!\u0015\u000e\u0001\u0004\u0001\u0005\u0006\u0003BI\u0003+\nY&!\u0018)\u000f5\t\u0019'a\u0017\u0003\u0018\u0006\u0012!\u0011T\u0001$wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018dCR\fGn\\4tQ\ri!Q\u0002\u0015\u000f\u001bE\f\u0019!!\u0002\u0002\n\t}\u0015\u0011\bBQY\t\u0011Y'\t\u0002\u0003$\u0006Q3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#vlQ!U\u00032{ui\u0015\u0011usB,\u0017AC4fiN\u001b\u0007.Z7bgR1!q\tBU\u0005[Ca!!\u0015\u000f\u0001\u0004\u0001\u0005\u0006\u0003BU\u0003+\nY&!\u0018\t\u000f\u0005eh\u00021\u0001\u00030B\u0019AL!-\n\u0007\tMVLA\tHKR\u001c6\r[3nCN\u0014V-];fgRDsADA2\u00037\u00129,\t\u0002\u0003:\u0006\u00113p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\u001a8\r[3nCND3A\u0004B\u0007Q9q\u0011/a\u0001\u0002\u0006\u0005%!qXA\u001d\u0005\u0003d#Aa\u001b\"\u0005\t\r\u0017!K\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0T\u0007\"+U*Q*!if\u0004X-A\u0005hKR$\u0016M\u00197fgR1!q\tBe\u0005\u001bDa!!\u0015\u0010\u0001\u0004\u0001\u0005\u0006\u0003Be\u0003+\nY&!\u0018\t\u000f\u0005ex\u00021\u0001\u0003PB\u0019AL!5\n\u0007\tMWL\u0001\tHKR$\u0016M\u00197fgJ+\u0017/^3ti\":q\"a\u0019\u0002\\\t]\u0017E\u0001Bm\u0003\u0005Z8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_Q\f'\r\\3tQ\ry!Q\u0002\u0015\u000f\u001fE\f\u0019!!\u0002\u0002\n\t}\u0017\u0011\bBqY\t\u0011Y'\t\u0002\u0003d\u0006A3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#v\fV!C\u0019\u0016\u001b\u0006\u0005^=qK\u0006iq-\u001a;UC\ndW\rV=qKN$BAa\u0012\u0003j\"1\u0011\u0011\u000b\tA\u0002\u0001C\u0003B!;\u0002V\u0005m\u0013Q\f\u0015\b!\u0005\r\u00141\fBxC\t\u0011\t0A\u0013|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7o\f;bE2,G+\u001f9fg\"\u001a\u0001C!\u0004)\u001dA\t\u00181AA\u0003\u0003\u0013\u001190!\u000f\u0003z2\u0012!1N\u0011\u0003\u0005w\fQf\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+Ek\u0018+B\u00052+u\fV-Q\u000bN\u0003C/\u001f9f\u0003)9W\r^\"pYVlgn\u001d\u000b\u0007\u0005\u000f\u001a\ta!\u0002\t\r\u0005E\u0013\u00031\u0001AQ!\u0019\t!!\u0016\u0002\\\u0005u\u0003bBA}#\u0001\u00071q\u0001\t\u00049\u000e%\u0011bAB\u0006;\n\tr)\u001a;D_2,XN\\:SKF,Xm\u001d;)\u000fE\t\u0019'a\u0017\u0004\u0010\u0005\u00121\u0011C\u0001#wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018d_2,XN\\:)\u0007E\u0011i\u0001\u000b\b\u0012c\u0006\r\u0011QAA\u0005\u0007/\tId!\u0007-\u0005\t-\u0014EAB\u000e\u0003%\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{6i\u0014'V\u001b:\u001b\u0006\u0005^=qK\u0006aq-\u001a;Gk:\u001cG/[8ogR1!qIB\u0011\u0007KAa!!\u0015\u0013\u0001\u0004\u0001\u0005\u0006CB\u0011\u0003+\nY&!\u0018\t\u000f\u0005e(\u00031\u0001\u0004(A\u0019Al!\u000b\n\u0007\r-RLA\nHKR4UO\\2uS>t7OU3rk\u0016\u001cH\u000fK\u0004\u0013\u0003G\nYfa\f\"\u0005\rE\u0012\u0001J>tKN\u001c\u0018n\u001c8IC:$G.Z?0_B,'/\u0019;j_:\u001cxFZ;oGRLwN\\:)\u0007I\u0011i\u0001\u000b\b\u0013c\u0006\r\u0011QAA\u0005\u0007o\tId!\u000f-\u0005\t-\u0014EAB\u001e\u0003-\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{f)\u0016(D)&{ej\u0015\u0011usB,\u0017AD4fiB\u0013\u0018.\\1ss.+\u0017p\u001d\u000b\u0007\u0005\u000f\u001a\te!\u0012\t\r\u0005E3\u00031\u0001AQ!\u0019\t%!\u0016\u0002\\\u0005u\u0003bBA}'\u0001\u00071q\t\t\u00049\u000e%\u0013bAB&;\n)r)\u001a;Qe&l\u0017M]=LKf\u001c(+Z9vKN$\bfB\n\u0002d\u0005m3qJ\u0011\u0003\u0007#\nae_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|\u0003O]5nCJL8*Z=tQ\r\u0019\"Q\u0002\u0015\u000f'E\f\u0019!!\u0002\u0002\n\r]\u0013\u0011HB-Y\t\u0011Y'\t\u0002\u0004\\\u0005i3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#v\f\u0015*J\u001b\u0006\u0013\u0016lX&F3\u0002\"\u0018\u0010]3\u0002#\u001d,Go\u0011:pgN\u0014VMZ3sK:\u001cW\r\u0006\u0004\u0003H\r\u00054Q\r\u0005\u0007\u0003#\"\u0002\u0019\u0001!)\u0011\r\u0005\u0014QKA.\u0003;Bq!!?\u0015\u0001\u0004\u00199\u0007E\u0002]\u0007SJ1aa\u001b^\u0005a9U\r^\"s_N\u001c(+\u001a4fe\u0016t7-\u001a*fcV,7\u000f\u001e\u0015\b)\u0005\r\u00141LB8C\t\u0019\t(A\u0015|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7oL2s_N\u001c(+\u001a4fe\u0016t7-\u001a\u0015\u0004)\t5\u0001F\u0004\u000br\u0003\u0007\t)!!\u0003\u0004x\u0005e2\u0011\u0010\u0017\u0003\u0005W\n#aa\u001f\u0002c\r\u0013X-\u0019;fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8!o&$\b\u000eI$F)~\u001b%kT*T?J+e)\u0012*F\u001d\u000e+\u0005\u0005^=qK\":\u0001aa \u0002\\\r\u0015\u0005cA4\u0004\u0002&\u001911\u00115\u0003\u0011A\u0013x\u000eZ;dKNd#!!\b)\u000f\u0001\u0019Ii!&\u0004\u0018B!11RBI\u001b\t\u0019iIC\u0002\u0004\u0010V\fA\u0001^1hg&!11SBG\u0005\r!\u0016mZ\u0001\u0005]\u0006lW-\t\u0002\u0004\u001a\u000691+Z:tS>t\u0007")
public class SessionsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    public org.apache.kyuubi.session.SessionHandle toSessionHandle(String str) {
        return SessionHandle$.MODULE$.fromUUID(str);
    }

    private SessionManager sessionManager() {
        return this.fe().be().sessionManager();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    public Seq<SessionData> sessions() {
        return ((TraversableOnce)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)session -> new SessionData(session.handle().identifier().toString(), session.user(), session.ipAddress(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)session.conf()).asJava(), Predef$.MODULE$.long2Long(session.createTime()), Predef$.MODULE$.long2Long(session.lastAccessTime() - session.createTime()), Predef$.MODULE$.long2Long(session.getNoOperationTime())), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiEvent.class))}, description="get a session event via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public KyuubiEvent sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        KyuubiEvent kyuubiEvent;
        try {
            kyuubiEvent = (KyuubiEvent)((KyuubiSession)this.sessionManager().getSession(this.toSessionHandle(sessionHandleStr))).getSessionEvent().get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString(), e);
                throw new NotFoundException(new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString());
            }
            throw throwable;
        }
        return kyuubiEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=InfoDetail.class))}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        try {
            TGetInfoType info = TGetInfoType.findByValue((int)infoType);
            TGetInfoValue infoValue = this.fe().be().getInfo(this.toSessionHandle(sessionHandleStr), info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString());
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionOpenCount.class))}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.sessionManager().getOpenSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExecPoolStatistic.class))}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.sessionManager().getExecPoolSize(), this.sessionManager().getActiveCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    @Consumes(value={"application/json"})
    public SessionHandle openSession(SessionOpenRequest request) {
        String userName = this.fe().getUserName((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        org.apache.kyuubi.session.SessionHandle handle = this.fe().be().openSession(TProtocolVersion.findByValue((int)request.getProtocolVersion()), userName, request.getPassword(), ipAddress, ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        return new SessionHandle(handle.identifier());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        this.fe().be().closeSession(this.toSessionHandle(sessionHandleStr));
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().executeStatement(this.toSessionHandle(sessionHandleStr), request.getStatement(), Predef$.MODULE$.Map().empty(), request.isRunAsync(), Predef$.MODULE$.Long2long(request.getQueryTimeout()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error executing statement";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTypeInfo(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting type information";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCatalogs(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting catalogs";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        try {
            OperationHandle operationHandle2;
            operationHandle = operationHandle2 = this.fe().be().getSchemas(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting schemas";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTables(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getTableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting tables";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTableTypes(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting table types";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getColumns(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getColumnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting columns";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getFunctions(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getFunctionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting functions";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_PRIMARY_KEY type")
    @POST
    @Path(value="{sessionHandle}/operations/primaryKeys")
    public OperationHandle getPrimaryKeys(@PathParam(value="sessionHandle") String sessionHandleStr, GetPrimaryKeysRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getPrimaryKeys(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting primary keys";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CROSS_REFERENCE type")
    @POST
    @Path(value="{sessionHandle}/operations/crossReference")
    public OperationHandle getCrossReference(@PathParam(value="sessionHandle") String sessionHandleStr, GetCrossReferenceRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCrossReference(this.toSessionHandle(sessionHandleStr), request.getPrimaryCatalog(), request.getPrimarySchema(), request.getPrimaryTable(), request.getForeignCatalog(), request.getForeignSchema(), request.getForeignTable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting cross reference";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

