/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.security.sasl.AuthenticationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthSchemes$;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler$;
import org.apache.kyuubi.server.http.authentication.KerberosUtil$;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\r\u001a\u0001\u0019BQ!\u000e\u0001\u0005\u0002YB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0005\"C%\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011%Q\u0005\u00011AA\u0002\u0013%1\nC\u0005S\u0001\u0001\u0007\t\u0019!C\u0005'\"IQ\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0014\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0011\u001d\u0011\u0007\u00011A\u0005\n\rDa!\u001a\u0001!B\u0013A\u0006\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0011%\u0019\b\u00011AA\u0002\u0013%A\u000fC\u0005w\u0001\u0001\u0007\t\u0011)Q\u0005Q\"Iq\u000f\u0001a\u0001\u0002\u0004%Ia\u001a\u0005\nq\u0002\u0001\r\u00111A\u0005\neD\u0011b\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u00025\t\u000fq\u0004!\u0019!C!{\"9\u00111\u0002\u0001!\u0002\u0013q\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u0002B\u0001!\t!a\u0011\u0003;-+'OY3s_N\fU\u000f\u001e5f]RL7-\u0019;j_:D\u0015M\u001c3mKJT!AG\u000e\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011A$H\u0001\u0005QR$\bO\u0003\u0002\u001f?\u000511/\u001a:wKJT!\u0001I\u0011\u0002\r-LX/\u001e2j\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M!\u0001aJ\u00172!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afL\u0007\u00023%\u0011\u0001'\u0007\u0002\u0016\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u0006tG\r\\3s!\t\u00114'D\u0001 \u0013\t!tDA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00059\u0004C\u0001\u0018\u0001\u0003)97o]'b]\u0006<WM]\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005U\u001e\u001c8O\u0003\u0002@G\u0005!\u0011.\u001a;g\u0013\t\tEH\u0001\u0006H'Nk\u0015M\\1hKJ\fabZ:t\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002E\u000fB\u0011\u0001&R\u0005\u0003\r&\u0012A!\u00168ji\"9\u0001jAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u0005Yqm]:NC:\fw-\u001a:!\u0003\u0011\u0019wN\u001c4\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!aT\u0010\u0002\r\r|gNZ5h\u0013\t\tfJ\u0001\u0006LsV,(-[\"p]\u001a\f\u0001bY8oM~#S-\u001d\u000b\u0003\tRCq\u0001\u0013\u0004\u0002\u0002\u0003\u0007A*A\u0003d_:4\u0007%A\u0007tKJ4XM]*vE*,7\r^\u000b\u00021B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u0005CV$\bN\u0003\u0002^=\u0006A1/Z2ve&$\u0018PC\u0001`\u0003\u0015Q\u0017M^1y\u0013\t\t'LA\u0004Tk\nTWm\u0019;\u0002#M,'O^3s'V\u0014'.Z2u?\u0012*\u0017\u000f\u0006\u0002EI\"9\u0001*CA\u0001\u0002\u0004A\u0016AD:feZ,'oU;cU\u0016\u001cG\u000fI\u0001\u0007W\u0016LH/\u00192\u0016\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6*\u001b\u0005a'BA7&\u0003\u0019a$o\\8u}%\u0011q.K\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pS\u0005Q1.Z=uC\n|F%Z9\u0015\u0005\u0011+\bb\u0002%\r\u0003\u0003\u0005\r\u0001[\u0001\bW\u0016LH/\u00192!\u0003%\u0001(/\u001b8dSB\fG.A\u0007qe&t7-\u001b9bY~#S-\u001d\u000b\u0003\tjDq\u0001S\b\u0002\u0002\u0003\u0007\u0001.\u0001\u0006qe&t7-\u001b9bY\u0002\n!\"Y;uQN\u001b\u0007.Z7f+\u0005q\bcA@\u0002\u00069\u0019a&!\u0001\n\u0007\u0005\r\u0011$A\u0006BkRD7k\u00195f[\u0016\u001c\u0018\u0002BA\u0004\u0003\u0013\u0011!\"Q;uQN\u001b\u0007.Z7f\u0015\r\t\u0019!G\u0001\fCV$\bnU2iK6,\u0007%A\fbkRDWM\u001c;jG\u0006$\u0018n\u001c8TkB\u0004xN\u001d;fIV\u0011\u0011\u0011\u0003\t\u0004Q\u0005M\u0011bAA\u000bS\t9!i\\8mK\u0006t\u0017\u0001B5oSR$2\u0001RA\u000e\u0011\u0015QE\u00031\u0001M\u0003\u001d!Wm\u001d;s_f$\u0012\u0001R\u0001\rCV$\b.\u001a8uS\u000e\fG/\u001a\u000b\u0006Q\u0006\u0015\u0012q\u0007\u0005\b\u0003O1\u0002\u0019AA\u0015\u0003\u001d\u0011X-];fgR\u0004B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u00049\u0005=\"bAA\u0019=\u000691/\u001a:wY\u0016$\u0018\u0002BA\u001b\u0003[\u0011!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\"9\u0011\u0011\b\fA\u0002\u0005m\u0012\u0001\u0003:fgB|gn]3\u0011\t\u0005-\u0012QH\u0005\u0005\u0003\u007f\tiCA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX-\u0001\tsk:<\u0016\u000e\u001e5Qe&t7-\u001b9bYR9\u0001.!\u0012\u0002J\u0005e\u0003BBA$/\u0001\u0007\u0001.A\btKJ4XM\u001d)sS:\u001c\u0017\u000e]1m\u0011\u001d\tYe\u0006a\u0001\u0003\u001b\n1b\u00197jK:$Hk\\6f]B)\u0001&a\u0014\u0002T%\u0019\u0011\u0011K\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0007!\n)&C\u0002\u0002X%\u0012AAQ=uK\"9\u0011\u0011H\fA\u0002\u0005m\u0002")
public class KerberosAuthenticationHandler
implements AuthenticationHandler,
Logging {
    private GSSManager gssManager;
    private KyuubiConf conf;
    private Subject serverSubject;
    private String keytab;
    private String principal;
    private final Enumeration.Value authScheme;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public boolean matchAuthScheme(String authorization) {
        return AuthenticationHandler.matchAuthScheme$(this, authorization);
    }

    @Override
    public String getAuthorization(HttpServletRequest request) {
        return AuthenticationHandler.getAuthorization$(this, request);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private GSSManager gssManager() {
        return this.gssManager;
    }

    private void gssManager_$eq(GSSManager x$1) {
        this.gssManager = x$1;
    }

    private KyuubiConf conf() {
        return this.conf;
    }

    private void conf_$eq(KyuubiConf x$1) {
        this.conf = x$1;
    }

    private Subject serverSubject() {
        return this.serverSubject;
    }

    private void serverSubject_$eq(Subject x$1) {
        this.serverSubject = x$1;
    }

    private String keytab() {
        return this.keytab;
    }

    private void keytab_$eq(String x$1) {
        this.keytab = x$1;
    }

    private String principal() {
        return this.principal;
    }

    private void principal_$eq(String x$1) {
        this.principal = x$1;
    }

    @Override
    public Enumeration.Value authScheme() {
        return this.authScheme;
    }

    @Override
    public boolean authenticationSupported() {
        return !this.keytab().isEmpty() && !this.principal().isEmpty();
    }

    @Override
    public void init(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.keytab_$eq((String)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_SPNEGO_KEYTAB())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        this.principal_$eq((String)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_SPNEGO_PRINCIPAL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        if (this.authenticationSupported()) {
            File keytabFile = new File(this.keytab());
            if (!keytabFile.exists()) {
                throw new ServletException(new StringBuilder(24).append("Keytab[").append(this.keytab()).append("] does not exists").toString());
            }
            if (!this.principal().startsWith("HTTP/")) {
                throw new ServletException(new StringBuilder(44).append("SPNEGO principal[").append(this.principal()).append("] does not start with HTTP/").toString());
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Using keytab ").append(this.keytab()).append(", for principal ").append(this.principal()).toString());
            this.serverSubject().getPrivateCredentials().add(KeyTab.getInstance(keytabFile));
            this.serverSubject().getPrincipals().add(new KerberosPrincipal(this.principal()));
            if (!KerberosName.hasRulesBeenSet()) {
                KerberosName.setRules((String)"DEFAULT");
            }
            try {
                this.gssManager_$eq(Subject.doAs(this.serverSubject(), new PrivilegedExceptionAction<GSSManager>(null){

                    public GSSManager run() {
                        return GSSManager.getInstance();
                    }
                }));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        this.keytab_$eq(null);
        this.serverSubject_$eq(null);
    }

    @Override
    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String authUser = null;
        String authorization = this.getAuthorization(request);
        byte[] clientToken = Base64.getDecoder().decode(authorization);
        try {
            String serverPrincipal = KerberosUtil$.MODULE$.getTokenServerName(clientToken);
            if (!serverPrincipal.startsWith("HTTP/")) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Invalid server principal ").append(serverPrincipal).append(" decoded from client request").toString());
            }
            authUser = Subject.doAs(this.serverSubject(), new PrivilegedExceptionAction<String>(this, serverPrincipal, clientToken, response){
                private final /* synthetic */ KerberosAuthenticationHandler $outer;
                private final String serverPrincipal$1;
                private final byte[] clientToken$1;
                private final HttpServletResponse response$1;

                public String run() {
                    return this.$outer.runWithPrincipal(this.serverPrincipal$1, this.clientToken$1, this.response$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.serverPrincipal$1 = serverPrincipal$1;
                    this.clientToken$1 = clientToken$1;
                    this.response$1 = response$1;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception exception = ex.getException();
            if (exception instanceof IOException) {
                IOException iOException = (IOException)exception;
                throw iOException;
            }
            if (exception != null) {
                Exception exception2 = exception;
                throw new AuthenticationException("SPNEGO authentication failed", exception2);
            }
            throw new MatchError((Object)exception);
        }
        catch (Exception e) {
            throw new AuthenticationException("SPNEGO authentication failed", e);
        }
        return authUser;
    }

    public String runWithPrincipal(String serverPrincipal, byte[] clientToken, HttpServletResponse response) {
        GSSContext gssContext = null;
        GSSCredential gssCreds = null;
        String authUser = null;
        try {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("SPNEGO initialized with server principal ").append(serverPrincipal).toString());
            gssCreds = this.gssManager().createCredential(this.gssManager().createName(serverPrincipal, KerberosUtil$.MODULE$.NT_GSS_KRB5_PRINCIPAL_OID()), Integer.MAX_VALUE, (Oid[])((Object[])new Oid[]{KerberosUtil$.MODULE$.GSS_SPNEGO_MECH_OID(), KerberosUtil$.MODULE$.GSS_KRB5_MECH_OID()}), 2);
            gssContext = this.gssManager().createContext(gssCreds);
            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
            if (serverToken != null && serverToken.length > 0) {
                String authenticate = Base64.getEncoder().encodeToString(serverToken);
                response.setHeader(AuthenticationHandler$.MODULE$.WWW_AUTHENTICATE(), new StringBuilder(1).append(AuthSchemes$.MODULE$.NEGOTIATE()).append(" ").append(authenticate).toString());
            }
            if (!gssContext.isEstablished()) {
                response.setStatus(401);
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "SPNEGO in progress");
            } else {
                String userName;
                String clientPrincipal = ((Object)gssContext.getSrcName()).toString();
                KerberosName kerberosName = new KerberosName(clientPrincipal);
                authUser = userName = kerberosName.getShortName();
                response.setStatus(200);
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("SPNEGO completed for client principal ").append(clientPrincipal).toString());
            }
        }
        finally {
            if (gssContext != null) {
                gssContext.dispose();
            }
            if (gssCreds != null) {
                gssCreds.dispose();
            }
        }
        return authUser;
    }

    public KerberosAuthenticationHandler() {
        AuthenticationHandler.$init$(this);
        Logging.$init$((Logging)this);
        this.serverSubject = new Subject();
        this.authScheme = AuthSchemes$.MODULE$.NEGOTIATE();
    }
}

