/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.ApplicationState$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.runtime.BoxesRunTime;

public final class KubernetesApplicationOperation$
implements Logging {
    public static KubernetesApplicationOperation$ MODULE$;
    private final String LABEL_KYUUBI_UNIQUE_KEY;
    private final String SPARK_APP_ID_LABEL;
    private final String KUBERNETES_SERVICE_HOST;
    private final String KUBERNETES_SERVICE_PORT;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KubernetesApplicationOperation$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String LABEL_KYUUBI_UNIQUE_KEY() {
        return this.LABEL_KYUUBI_UNIQUE_KEY;
    }

    public String SPARK_APP_ID_LABEL() {
        return this.SPARK_APP_ID_LABEL;
    }

    public String KUBERNETES_SERVICE_HOST() {
        return this.KUBERNETES_SERVICE_HOST;
    }

    public String KUBERNETES_SERVICE_PORT() {
        return this.KUBERNETES_SERVICE_PORT;
    }

    public String toLabel(String tag) {
        return new StringBuilder(8).append("label: ").append(this.LABEL_KYUUBI_UNIQUE_KEY()).append("=").append(tag).toString();
    }

    public Enumeration.Value toApplicationState(Pod pod, Enumeration.Value appStateSource, String appStateContainer) {
        return (Enumeration.Value)this.toApplicationStateAndError(pod, appStateSource, appStateContainer)._1();
    }

    public Tuple2<Enumeration.Value, Option<String>> toApplicationStateAndError(Pod pod, Enumeration.Value appStateSource, String appStateContainer) {
        None$ none$;
        String podName = pod.getMetadata().getName();
        Enumeration.Value value = appStateSource;
        Enumeration.Value value2 = KyuubiConf.KubernetesApplicationStateSource$.MODULE$.CONTAINER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            none$ = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)cs -> BoxesRunTime.boxToBoolean((boolean)appStateContainer.equalsIgnoreCase(cs.getName()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getState());
        } else {
            Enumeration.Value value4 = KyuubiConf.KubernetesApplicationStateSource$.MODULE$.POD();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)value);
            }
        }
        None$ containerStateToBuildAppState = none$;
        Enumeration.Value applicationState = (Enumeration.Value)containerStateToBuildAppState.map((Function1 & Serializable & scala.Serializable)containerState -> MODULE$.containerStateToApplicationState((ContainerState)containerState)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.podStateToApplicationState(pod.getStatus().getPhase()));
        Option applicationError = (Option)containerStateToBuildAppState.map((Function1 & Serializable & scala.Serializable)cs -> MODULE$.containerStateToApplicationError((ContainerState)cs).map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(3).append(podName).append("/").append(appStateContainer).append("[").append((String)r).append("]").toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)pod.getStatus().getReason()).map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(2).append(podName).append("[").append((String)r).append("]").toString()));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)applicationState), (Object)applicationError);
    }

    public Enumeration.Value containerStateToApplicationState(ContainerState containerState) {
        if (containerState.getWaiting() != null) {
            return ApplicationState$.MODULE$.PENDING();
        }
        if (containerState.getRunning() != null) {
            return ApplicationState$.MODULE$.RUNNING();
        }
        if (containerState.getTerminated() == null) {
            return ApplicationState$.MODULE$.UNKNOWN();
        }
        if (BoxesRunTime.equalsNumObject((Number)containerState.getTerminated().getExitCode(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return ApplicationState$.MODULE$.FINISHED();
        }
        return ApplicationState$.MODULE$.FAILED();
    }

    public Option<String> containerStateToApplicationError(ContainerState containerState) {
        return Option$.MODULE$.apply((Object)containerState.getWaiting()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getReason()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)containerState.getTerminated()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getReason()));
    }

    public Enumeration.Value podStateToApplicationState(String podState) {
        String string = podState;
        if ("Pending".equals(string)) {
            return ApplicationState$.MODULE$.PENDING();
        }
        if ("Running".equals(string)) {
            return ApplicationState$.MODULE$.RUNNING();
        }
        if ("Succeeded".equals(string)) {
            return ApplicationState$.MODULE$.FINISHED();
        }
        if ("Failed".equals(string) ? true : "Error".equals(string)) {
            return ApplicationState$.MODULE$.FAILED();
        }
        if ("Unknown".equals(string)) {
            return ApplicationState$.MODULE$.UNKNOWN();
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("The spark driver pod state: ").append(podState).append(" is not supported, ").append("mark the application state as UNKNOWN.").toString());
        return ApplicationState$.MODULE$.UNKNOWN();
    }

    private KubernetesApplicationOperation$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.LABEL_KYUUBI_UNIQUE_KEY = "kyuubi-unique-tag";
        this.SPARK_APP_ID_LABEL = "spark-app-selector";
        this.KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
        this.KUBERNETES_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    }
}

