/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.inprocess;

import java.io.IOException;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.grpc.ExperimentalApi;
import org.apache.kyuubi.shade.io.grpc.inprocess.InProcessServer;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8626")
public final class AnonymousInProcessSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = -8567592561863414695L;
    @Nullable
    @GuardedBy(value="this")
    private InProcessServer server;

    @Nullable
    synchronized InProcessServer getServer() {
        return this.server;
    }

    synchronized void setServer(InProcessServer server) throws IOException {
        if (this.server != null) {
            throw new IOException("Server instance already registered");
        }
        this.server = server;
    }

    synchronized void clearServer(InProcessServer server) {
        Preconditions.checkState(this.server == server);
        this.server = null;
    }
}

