/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl.future;

import java.util.function.Function;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.FutureInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Listener;
import org.apache.kyuubi.shade.io.vertx.core.impl.future.Operation;

class Transformation<T, U>
extends Operation<U>
implements Listener<T> {
    private final Future<T> future;
    private final Function<AsyncResult<T>, Future<U>> mapper;

    Transformation(ContextInternal context, Future<T> future, Function<AsyncResult<T>, Future<U>> mapper) {
        super(context);
        this.future = future;
        this.mapper = mapper;
    }

    @Override
    public void onSuccess(T value) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    @Override
    public void onFailure(Throwable failure) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    private Listener<U> newListener() {
        return new Listener<U>(){

            @Override
            public void onSuccess(U value) {
                Transformation.this.tryComplete(value);
            }

            @Override
            public void onFailure(Throwable failure) {
                Transformation.this.tryFail(failure);
            }
        };
    }
}

