/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class CompletableMerge
extends Completable {
    final Publisher<? extends CompletableSource> source;
    final int maxConcurrency;
    final boolean delayErrors;

    public CompletableMerge(Publisher<? extends CompletableSource> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.maxConcurrency = maxConcurrency;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(s, this.maxConcurrency, this.delayErrors);
        this.source.subscribe((Subscriber)parent);
    }

    static final class CompletableMergeSubscriber
    extends AtomicInteger
    implements Subscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = -2108443387387077490L;
        final CompletableObserver actual;
        final int maxConcurrency;
        final boolean delayErrors;
        final AtomicThrowable error;
        final CompositeDisposable set;
        Subscription s;

        CompletableMergeSubscriber(CompletableObserver actual, int maxConcurrency, boolean delayErrors) {
            this.actual = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.error = new AtomicThrowable();
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request((long)this.maxConcurrency);
                }
            }
        }

        public void onNext(CompletableSource t) {
            this.getAndIncrement();
            MergeInnerObserver inner = new MergeInnerObserver();
            this.set.add(inner);
            t.subscribe(inner);
        }

        public void onError(Throwable t) {
            if (!this.delayErrors) {
                this.set.dispose();
                if (this.error.addThrowable(t)) {
                    if (this.getAndSet(0) > 0) {
                        this.actual.onError(this.error.terminate());
                    }
                } else {
                    RxJavaPlugins.onError(t);
                }
            } else if (this.error.addThrowable(t)) {
                if (this.decrementAndGet() == 0) {
                    this.actual.onError(this.error.terminate());
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    this.actual.onError(this.error.terminate());
                } else {
                    this.actual.onComplete();
                }
            }
        }

        void innerError(MergeInnerObserver inner, Throwable t) {
            this.set.delete(inner);
            if (!this.delayErrors) {
                this.s.cancel();
                this.set.dispose();
                if (this.error.addThrowable(t)) {
                    if (this.getAndSet(0) > 0) {
                        this.actual.onError(this.error.terminate());
                    }
                } else {
                    RxJavaPlugins.onError(t);
                }
            } else if (this.error.addThrowable(t)) {
                if (this.decrementAndGet() == 0) {
                    this.actual.onError(this.error.terminate());
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.s.request(1L);
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        void innerComplete(MergeInnerObserver inner) {
            this.set.delete(inner);
            if (this.decrementAndGet() == 0) {
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onComplete();
                }
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.s.request(1L);
            }
        }

        final class MergeInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 251330541679988317L;

            MergeInnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onError(Throwable e) {
                CompletableMergeSubscriber.this.innerError(this, e);
            }

            @Override
            public void onComplete() {
                CompletableMergeSubscriber.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

