/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.PreconditionsBuilder;
import io.fabric8.kubernetes.api.model.PreconditionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeleteOptionsFluent<A extends DeleteOptionsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private PreconditionsBuilder preconditions;
    private String propagationPolicy;
    private Map<String, Object> additionalProperties;

    public DeleteOptionsFluent() {
    }

    public DeleteOptionsFluent(DeleteOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeleteOptions instance) {
        DeleteOptions deleteOptions = instance = instance != null ? instance : new DeleteOptions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDryRun(instance.getDryRun());
            this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
            this.withKind(instance.getKind());
            this.withOrphanDependents(instance.getOrphanDependents());
            this.withPreconditions(instance.getPreconditions());
            this.withPropagationPolicy(instance.getPropagationPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)((Object)this);
    }

    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)((Object)this);
    }

    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDryRun(String ... items) {
        if (this.dryRun == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDryRun() {
        return this.dryRun;
    }

    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)((Object)this);
    }

    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
            this._visitables.remove((Object)"dryRun");
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)((Object)this);
    }

    public boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    public Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    public A withPreconditions(Preconditions preconditions) {
        this._visitables.remove((Object)"preconditions");
        if (preconditions != null) {
            this.preconditions = new PreconditionsBuilder(preconditions);
            this._visitables.get((Object)"preconditions").add(this.preconditions);
        } else {
            this.preconditions = null;
            this._visitables.get((Object)"preconditions").remove((Object)this.preconditions);
        }
        return (A)((Object)this);
    }

    public boolean hasPreconditions() {
        return this.preconditions != null;
    }

    public A withNewPreconditions(String resourceVersion, String uid) {
        return this.withPreconditions(new Preconditions(resourceVersion, uid));
    }

    public PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNested(null);
    }

    public PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
        return new PreconditionsNested(item);
    }

    public PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(null));
    }

    public PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(new PreconditionsBuilder().build()));
    }

    public PreconditionsNested<A> editOrNewPreconditionsLike(Preconditions item) {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(item));
    }

    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)((Object)this);
    }

    public boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptionsFluent that = (DeleteOptionsFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.dryRun, that.dryRun)) {
            return false;
        }
        if (!Objects.equals(this.gracePeriodSeconds, that.gracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.orphanDependents, that.orphanDependents)) {
            return false;
        }
        if (!Objects.equals((Object)this.preconditions, (Object)that.preconditions)) {
            return false;
        }
        if (!Objects.equals(this.propagationPolicy, that.propagationPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun + ",");
        }
        if (this.gracePeriodSeconds != null) {
            sb.append("gracePeriodSeconds:");
            sb.append(this.gracePeriodSeconds + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.orphanDependents != null) {
            sb.append("orphanDependents:");
            sb.append(this.orphanDependents + ",");
        }
        if (this.preconditions != null) {
            sb.append("preconditions:");
            sb.append((Object)((Object)this.preconditions) + ",");
        }
        if (this.propagationPolicy != null) {
            sb.append("propagationPolicy:");
            sb.append(this.propagationPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withOrphanDependents() {
        return this.withOrphanDependents(true);
    }

    public class PreconditionsNested<N>
    extends PreconditionsFluent<PreconditionsNested<N>>
    implements Nested<N> {
        PreconditionsBuilder builder;

        PreconditionsNested(Preconditions item) {
            this.builder = new PreconditionsBuilder(this, item);
        }

        public N and() {
            return (N)DeleteOptionsFluent.this.withPreconditions(this.builder.build());
        }

        public N endPreconditions() {
            return this.and();
        }
    }
}

