/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe;

import java.time.Duration;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadBuilder;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadConfig;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadFullException;
import org.apache.kyuubi.shade.dev.failsafe.Policy;
import org.apache.kyuubi.shade.dev.failsafe.internal.BulkheadImpl;

public interface Bulkhead<R>
extends Policy<R> {
    public static <R> BulkheadBuilder<R> builder(int maxConcurrency) {
        return new BulkheadBuilder(maxConcurrency);
    }

    public static <R> BulkheadBuilder<R> builder(BulkheadConfig<R> config) {
        return new BulkheadBuilder<R>(config);
    }

    public static <R> Bulkhead<R> of(int maxConcurrency) {
        return new BulkheadImpl(new BulkheadConfig(maxConcurrency));
    }

    @Override
    public BulkheadConfig<R> getConfig();

    public void acquirePermit() throws InterruptedException;

    default public void acquirePermit(Duration maxWaitTime) throws InterruptedException {
        if (!this.tryAcquirePermit(maxWaitTime)) {
            throw new BulkheadFullException(this);
        }
    }

    public boolean tryAcquirePermit();

    public boolean tryAcquirePermit(Duration var1) throws InterruptedException;

    public void releasePermit();
}

