/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}f\u0001\u0002!B\u0001)C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006;\u0002!IA\u0018\u0005\u0006;\u0002!\t!\u0019\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019i\u0007\u0001)A\u0005I\"9a\u000e\u0001b\u0001\n\u0003y\u0007B\u0002<\u0001A\u0003%\u0001\u000fC\u0004x\u0001\t\u0007I\u0011\u0001=\t\r}\u0004\u0001\u0015!\u0003z\u0011%\t\t\u0001\u0001a\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0001\u0002\u001e!A\u0011\u0011\u0006\u0001!B\u0013\t)\u0001C\u0006\u0002,\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0002bCA\u001e\u0001\u0001\u0007\t\u0019!C\u0001\u0003{A1\"!\u0011\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00020!Q\u00111\t\u0001\t\u0006\u0004%\t!!\u0012\t\u0015\u0005\u0015\u0004\u0001#b\u0001\n\u0003\t9\u0007C\u0005\u0002p\u0001\u0001\r\u0011\"\u0003\u0002r!I\u00111\u0010\u0001A\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u0003\u0003\u0001\u0015)\u0003\u0002t!I\u00111\u0011\u0001A\u0002\u0013%\u0011\u0011\u000f\u0005\n\u0003\u000b\u0003\u0001\u0019!C\u0005\u0003\u000fC\u0001\"a#\u0001A\u0003&\u00111\u000f\u0005\r\u0003O\u0001\u0001\u0013!EDB\u0013%\u0011Q\u0012\u0005\u000b\u0003W\u0003\u0001R1A\u0005\u0002\u00055\u0006BCAX\u0001!\u0015\r\u0011\"\u0001\u00022\"I\u00111\u0017\u0001A\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003\u0013\u0004\u0001\u0019!C\u0001\u0003\u0017D\u0001\"a4\u0001A\u0003&\u0011q\u0017\u0005\n\u0003#\u0004!\u0019!C\u0005\u0003'D\u0001\"a7\u0001A\u0003%\u0011Q\u001b\u0005\b\u0003;\u0004A\u0011IAp\u0011\u001d\t\t\u0010\u0001C)\u0003gDqAa\f\u0001\t\u0003\u0012\t\u0004C\u0004\u0003D\u0001!\tE!\u0012\t\u000f\t-\u0003\u0001\"\u0001\u0003N!I!q\u0012\u0001\u0012\u0002\u0013\u0005!\u0011\u0013\u0005\t\u0005O\u0003A\u0011A\"\u0003*\"9!q\u0015\u0001\u0005\u0002\t=\u0006b\u0002Bi\u0001\u0011\u0005!1\u001b\u0005\b\u0005;\u0004A\u0011\u0001Bp\u0011\u001d\u0011)\u000f\u0001C\u0001\u0005ODqAa;\u0001\t\u0003\u0011i\u000fC\u0004\u0003r\u0002!\tAa=\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!91q\u0001\u0001\u0005\u0002\r%\u0001bBB\f\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007k\u0001A\u0011AB\u001c\u0011\u001d\u0019Y\u0004\u0001C\u0001\u0007{Aqaa\u0017\u0001\t\u0003\u001ai\u0006C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\r%\u0004\u0001\"\u0001\u0004l!91\u0011\u000f\u0001\u0005R\rM\u0004bBB;\u0001\u0011%1q\u000f\u0005\t\u0007w\u0002A\u0011A\"\u0004~!A1Q\u0011\u0001\u0005\u0002\r\u001b9\t\u0003\u0005\u0004\f\u0002!\taQB?\u0011!\u0019i\t\u0001C\u0001\u0007\u000e=\u0005\u0002CBJ\u0001\u0011\u00051i! \t\u0011\rU\u0005\u0001\"\u0001D\u0007/Cqaa'\u0001\t\u0013\u0019i\nC\u0004\u00048\u0002!Ia!\u0018\t\u000f\re\u0006\u0001\"\u0003\u0004<\n!2*_;vE&\u001cVm]:j_:l\u0015M\\1hKJT!AQ\"\u0002\u000fM,7o]5p]*\u0011A)R\u0001\u0007Wf,XOY5\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\u0002\u0001'\t\u00011\n\u0005\u0002M\u001b6\t\u0011)\u0003\u0002O\u0003\nq1+Z:tS>tW*\u00198bO\u0016\u0014\u0018\u0001\u00028b[\u0016\u0004\"!\u0015.\u000f\u0005IC\u0006CA*W\u001b\u0005!&BA+J\u0003\u0019a$o\\8u})\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tIf+\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0002\u0004\"\u0001\u0014\u0001\t\u000b=\u0013\u0001\u0019\u0001)\u0015\u0003}\u000ba\u0001]1sg\u0016\u0014X#\u00013\u0011\u0005\u0015\\W\"\u00014\u000b\u0005\u001dD\u0017AB:feZ,'O\u0003\u0002cS*\u0011!nQ\u0001\u0004gFd\u0017B\u00017g\u00051Y\u00150^;cSB\u000b'o]3s\u0003\u001d\u0001\u0018M]:fe\u0002\n\u0001c\u001c9fe\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]\"\u0002\u0013=\u0004XM]1uS>t\u0017BA;s\u0005YY\u00150^;cS>\u0003XM]1uS>tW*\u00198bO\u0016\u0014\u0018!E8qKJ\fG/[8o\u001b\u0006t\u0017mZ3sA\u0005\u00112M]3eK:$\u0018.\u00197t\u001b\u0006t\u0017mZ3s+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?D\u0003-\u0019'/\u001a3f]RL\u0017\r\\:\n\u0005y\\(\u0001\u0007%bI>|\u0007o\u0011:fI\u0016tG/[1mg6\u000bg.Y4fe\u0006\u00192M]3eK:$\u0018.\u00197t\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u0006A1\u0011qAA\u0005\u0003\u001bi\u0011AV\u0005\u0004\u0003\u00171&AB(qi&|g\u000e\u0005\u0003\u0002\u0010\u0005]QBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u00115,G/\u00193bi\u0006T!aZ\"\n\t\u0005e\u0011\u0011\u0003\u0002\u0010\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u0019R.\u001a;bI\u0006$\u0018-T1oC\u001e,'o\u0018\u0013fcR!\u0011qDA\u0013!\u0011\t9!!\t\n\u0007\u0005\rbK\u0001\u0003V]&$\b\"CA\u0014\u0017\u0005\u0005\t\u0019AA\u0003\u0003\rAH%M\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n!#\u00199qY&\u001c\u0017\r^5p]6\u000bg.Y4feV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG\"\u0002\r\u0015tw-\u001b8f\u0013\u0011\tI$a\r\u00031-KX/\u001e2j\u0003B\u0004H.[2bi&|g.T1oC\u001e,'/\u0001\fbaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014x\fJ3r)\u0011\ty\"a\u0010\t\u0013\u0005\u001db\"!AA\u0002\u0005=\u0012aE1qa2L7-\u0019;j_:l\u0015M\\1hKJ\u0004\u0013AE:fgNLwN\\\"p]\u001a\fEM^5t_J,\"!a\u0012\u0011\r\u0005%\u00131KA-\u001d\u0011\tY%a\u0014\u000f\u0007M\u000bi%C\u0001X\u0013\r\t\tFV\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)&a\u0016\u0003\u0007M+\u0017OC\u0002\u0002RY\u0003B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\u001a\u0015A\u00029mk\u001eLg.\u0003\u0003\u0002d\u0005u#AE*fgNLwN\\\"p]\u001a\fEM^5t_J\fQb\u001a:pkB\u0004&o\u001c<jI\u0016\u0014XCAA5!\u0011\tY&a\u001b\n\t\u00055\u0014Q\f\u0002\u000e\u000fJ|W\u000f\u001d)s_ZLG-\u001a:\u0002\u000f1LW.\u001b;feV\u0011\u00111\u000f\t\u0007\u0003\u000f\tI!!\u001e\u0011\u00071\u000b9(C\u0002\u0002z\u0005\u0013abU3tg&|g\u000eT5nSR,'/A\u0006mS6LG/\u001a:`I\u0015\fH\u0003BA\u0010\u0003\u007fB\u0011\"a\n\u0014\u0003\u0003\u0005\r!a\u001d\u0002\u00111LW.\u001b;fe\u0002\nABY1uG\"d\u0015.\\5uKJ\f\u0001CY1uG\"d\u0015.\\5uKJ|F%Z9\u0015\t\u0005}\u0011\u0011\u0012\u0005\n\u0003O1\u0012\u0011!a\u0001\u0003g\nQBY1uG\"d\u0015.\\5uKJ\u0004SCAAH!!\t9!!%\u0002\u0016\u0006\u0015\u0016bAAJ-\n1A+\u001e9mKJ\u0002B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\ty*\u0001\u0003kCZ\f\u0017\u0002BAR\u00033\u0013!\u0002\u0015:jm\u0006$XmS3z!\u0011\t9*a*\n\t\u0005%\u0016\u0011\u0014\u0002\n!V\u0014G.[2LKf\f\u0011c]5h]&tw\r\u0015:jm\u0006$XmS3z+\t\t)*\u0001\ttS\u001et\u0017N\\4Qk\nd\u0017nY&fsV\u0011\u0011QU\u0001\u001eK:<\u0017N\\3Ti\u0006\u0014H/\u001e9Qe>\u001cWm]:TK6\f\u0007\u000f[8sKV\u0011\u0011q\u0017\t\u0007\u0003\u000f\tI!!/\u0011\t\u0005m\u0016QY\u0007\u0003\u0003{SA!a0\u0002B\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0017QT\u0001\u0005kRLG.\u0003\u0003\u0002H\u0006u&!C*f[\u0006\u0004\bn\u001c:f\u0003\u0005*gnZ5oKN#\u0018M\u001d;vaB\u0013xnY3tgN+W.\u00199i_J,w\fJ3r)\u0011\ty\"!4\t\u0013\u0005\u001dB$!AA\u0002\u0005]\u0016AH3oO&tWm\u0015;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3!\u0003q)gnZ5oK\u000e{gN\\3di&|g.\u00117jm\u0016\u001c\u0005.Z2lKJ,\"!!6\u0011\t\u0005m\u0016q[\u0005\u0005\u00033\fiL\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fQ$\u001a8hS:,7i\u001c8oK\u000e$\u0018n\u001c8BY&4Xm\u00115fG.,'\u000fI\u0001\u000bS:LG/[1mSj,G\u0003BA\u0010\u0003CDq!a9!\u0001\u0004\t)/\u0001\u0003d_:4\u0007\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-8)\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003_\fIO\u0001\u0006LsV,(-[\"p]\u001a\fQb\u0019:fCR,7+Z:tS>tG\u0003DA{\u0003w\u0014YBa\b\u0003$\t\u001d\u0002c\u0001'\u0002x&\u0019\u0011\u0011`!\u0003\u000fM+7o]5p]\"9\u0011Q`\u0011A\u0002\u0005}\u0018\u0001\u00039s_R|7m\u001c7\u0011\t\t\u0005!qC\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u00051A\u000f\u001b:jMRTAA!\u0003\u0003\f\u0005\u0019!\u000f]2\u000b\t\t5!qB\u0001\bg\u0016\u0014h/[2f\u0015\u0011\u0011\tBa\u0005\u0002\t!Lg/\u001a\u0006\u0004\u0005+\u0019\u0015AB:iC\u0012,G-\u0003\u0003\u0003\u001a\t\r!\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0011\u0019\u0011i\"\ta\u0001!\u0006!Qo]3s\u0011\u0019\u0011\t#\ta\u0001!\u0006A\u0001/Y:to>\u0014H\r\u0003\u0004\u0003&\u0005\u0002\r\u0001U\u0001\nSB\fE\r\u001a:fgNDq!a9\"\u0001\u0004\u0011I\u0003E\u0003R\u0005W\u0001\u0006+C\u0002\u0003.q\u00131!T1q\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\u0019\tM\"\u0011\bB\u001e\u0005{\u0011yD!\u0011\u0011\u00071\u0013)$C\u0002\u00038\u0005\u0013QbU3tg&|g\u000eS1oI2,\u0007bBA\u007fE\u0001\u0007\u0011q \u0005\u0007\u0005;\u0011\u0003\u0019\u0001)\t\r\t\u0005\"\u00051\u0001Q\u0011\u0019\u0011)C\ta\u0001!\"9\u00111\u001d\u0012A\u0002\t%\u0012\u0001D2m_N,7+Z:tS>tG\u0003BA\u0010\u0005\u000fBqA!\u0013$\u0001\u0004\u0011\u0019$A\u0007tKN\u001c\u0018n\u001c8IC:$G.Z\u0001\u0013GJ,\u0017\r^3CCR\u001c\u0007nU3tg&|g\u000e\u0006\r\u0003P\tU#q\u000bB-\u00057\u0012iF!\u0019\u0003h\t-$q\u000eB;\u0005\u000b\u00032\u0001\u0014B)\u0013\r\u0011\u0019&\u0011\u0002\u0013\u0017f,XOY5CCR\u001c\u0007nU3tg&|g\u000e\u0003\u0004\u0003\u001e\u0011\u0002\r\u0001\u0015\u0005\u0007\u0005C!\u0003\u0019\u0001)\t\r\t\u0015B\u00051\u0001Q\u0011\u001d\t\u0019\u000f\na\u0001\u0005SAaAa\u0018%\u0001\u0004\u0001\u0016!\u00032bi\u000eDG+\u001f9f\u0011\u001d\u0011\u0019\u0007\na\u0001\u0005K\n\u0011BY1uG\"t\u0015-\\3\u0011\u000b\u0005\u001d\u0011\u0011\u0002)\t\r\t%D\u00051\u0001Q\u0003!\u0011Xm]8ve\u000e,\u0007B\u0002B7I\u0001\u0007\u0001+A\u0005dY\u0006\u001c8OT1nK\"9!\u0011\u000f\u0013A\u0002\tM\u0014!\u00032bi\u000eD\u0017I]4t!\u0015\tI%a\u0015Q\u0011%\t\u0019\u0002\nI\u0001\u0002\u0004\u00119\b\u0005\u0004\u0002\b\u0005%!\u0011\u0010\t\u0005\u0005w\u0012\t)\u0004\u0002\u0003~)!!qPA\t\u0003\r\t\u0007/[\u0005\u0005\u0005\u0007\u0013iH\u0001\u0005NKR\fG-\u0019;b\u0011\u001d\u00119\t\na\u0001\u0005\u0013\u000bAB\u001a:p[J+7m\u001c<fef\u0004B!a\u0002\u0003\f&\u0019!Q\u0012,\u0003\u000f\t{w\u000e\\3b]\u0006i2M]3bi\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8oI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0003\u0014*\"!q\u000fBKW\t\u00119\n\u0005\u0003\u0003\u001a\n\rVB\u0001BN\u0015\u0011\u0011iJa(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BQ-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015&1\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E8qK:\u0014\u0015\r^2i'\u0016\u001c8/[8o)\u0011\u0011\u0019Da+\t\u000f\t5f\u00051\u0001\u0003P\u0005a!-\u0019;dQN+7o]5p]RQ!1\u0007BY\u0005g\u0013)La.\t\r\tuq\u00051\u0001Q\u0011\u0019\u0011\tc\na\u0001!\"1!QE\u0014A\u0002ACqA!/(\u0001\u0004\u0011Y,\u0001\u0007cCR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003>\n5WB\u0001B`\u0015\u0011\u0011\tMa1\u0002\u0007\u0011$xN\u0003\u0003\u0003F\n\u001d\u0017A\u0001<2\u0015\u0011\u0011yH!3\u000b\u0007\t-7)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005\u001f\u0014yL\u0001\u0007CCR\u001c\u0007NU3rk\u0016\u001cH/\u0001\u000bj]&$\u0018.\u00197ju\u0016\u0014\u0015\r^2i'R\fG/\u001a\u000b\n!\nU'q\u001bBm\u00057DaA!\b)\u0001\u0004\u0001\u0006B\u0002B\u0013Q\u0001\u0007\u0001\u000bC\u0004\u0002d\"\u0002\rA!\u000b\t\u000f\te\u0006\u00061\u0001\u0003<\u0006yq-\u001a;CCR\u001c\u0007nU3tg&|g\u000e\u0006\u0003\u0003b\n\r\bCBA\u0004\u0003\u0013\u0011y\u0005C\u0004\u0003J%\u0002\rAa\r\u0002\u001d%t7/\u001a:u\u001b\u0016$\u0018\rZ1uCR!\u0011q\u0004Bu\u0011\u001d\t\u0019B\u000ba\u0001\u0005s\na\"\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002 \t=\bbBA\nW\u0001\u0007!\u0011P\u0001\u001cO\u0016$X*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u001d*fiJL(+\u001a4\u0015\t\tU(Q \t\u0007\u0003\u000f\tIAa>\u0011\t\u0005=!\u0011`\u0005\u0005\u0005w\f\tB\u0001\rNKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001aDaAa@-\u0001\u0004\u0001\u0016AC5eK:$\u0018NZ5fe\u0006\u0011C-\u001a*fO&\u001cH/\u001a:NKR\fG-\u0019;b%\u0016\fX/Z:ugJ+GO]=SK\u001a$B!a\b\u0004\u0006!1!q`\u0017A\u0002A\u000b\u0011dZ3u\u0005\u0006$8\r\u001b$s_6lU\r^1eCR\f7\u000b^8sKR!11BB\n!\u0019\t9!!\u0003\u0004\u000eA!!QXB\b\u0013\u0011\u0019\tBa0\u0003\u000b\t\u000bGo\u00195\t\r\rUa\u00061\u0001Q\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\f1dZ3u\u0005\u0006$8\r[3t\rJ|W.T3uC\u0012\fG/Y*u_J,G\u0003CB\u000e\u0007;\u00199c!\r\u0011\r\u0005%\u00131KB\u0007\u0011\u001d\u0019yb\fa\u0001\u0007C\taAZ5mi\u0016\u0014\b\u0003\u0002B>\u0007GIAa!\n\u0003~\tqQ*\u001a;bI\u0006$\u0018MR5mi\u0016\u0014\bbBB\u0015_\u0001\u000711F\u0001\u0005MJ|W\u000e\u0005\u0003\u0002\b\r5\u0012bAB\u0018-\n\u0019\u0011J\u001c;\t\u000f\rMr\u00061\u0001\u0004,\u0005!1/\u001b>f\u0003A9W\r\u001e\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003x\re\u0002BBB\u000ba\u0001\u0007\u0001+A\bdY\u0016\fg.\u001e9NKR\fG-\u0019;b)\u0011\tyba\u0010\t\r\t}\u0018\u00071\u0001QQ\r\t41\t\t\u0005\u0007\u000b\u001a9&\u0004\u0002\u0004H)!1\u0011JB&\u0003-\tgN\\8uCRLwN\\:\u000b\t\r53qJ\u0001\u0007G>lWn\u001c8\u000b\t\rE31K\u0001\u0007O>|w\r\\3\u000b\u0005\rU\u0013aA2p[&!1\u0011LB$\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003?\t\u0011dZ3u\u0005\u0006$8\r[*fgNLwN\\:U_J+7m\u001c<feR!11MB3!\u0019\tI%a\u0015\u0003P!11qM\u001aA\u0002A\u000bab[=vk\nL\u0017J\\:uC:\u001cW-\u0001\u0012hKR\u0004V-\u001a:J]N$\u0018M\\2f\u00072|7/\u001a3CCR\u001c\u0007nU3tg&|gn\u001d\u000b\u0005\u0007[\u001ay\u0007\u0005\u0004\u0002J\u0005M#\u0011\u0010\u0005\u0007\u0007O\"\u0004\u0019\u0001)\u0002\u0011%\u001c8+\u001a:wKJ,\"A!#\u0002%%t\u0017\u000e^*fgNLwN\u001c'j[&$XM\u001d\u000b\u0005\u0003?\u0019I\bC\u0004\u0002dZ\u0002\r!!:\u0002#\u001d,G/\u00168mS6LG/\u001a3Vg\u0016\u00148/\u0006\u0002\u0004\u0000A!\u0011k!!Q\u0013\r\u0019\u0019\t\u0018\u0002\u0004'\u0016$\u0018!\u0006:fMJ,7\u000f[+oY&l\u0017\u000e^3e+N,'o\u001d\u000b\u0005\u0003?\u0019I\tC\u0004\u0002db\u0002\r!!:\u0002\u0019\u001d,G\u000fR3osV\u001bXM]:\u0002!I,gM]3tQ\u0012+g._+tKJ\u001cH\u0003BA\u0010\u0007#Cq!a9;\u0001\u0004\t)/\u0001\u0006hKR$UM\\=JaN\faB]3ge\u0016\u001c\b\u000eR3os&\u00038\u000f\u0006\u0003\u0002 \re\u0005bBAry\u0001\u0007\u0011Q]\u0001\u0014CB\u0004H._*fgNLwN\u001c'j[&$XM\u001d\u000b\u000f\u0003g\u001ayja)\u0004(\u000e-6qVBZ\u0011\u001d\u0019\t+\u0010a\u0001\u0007W\t\u0011\"^:fe2KW.\u001b;\t\u000f\r\u0015V\b1\u0001\u0004,\u0005q\u0011\u000e]!eIJ,7o\u001d'j[&$\bbBBU{\u0001\u000711F\u0001\u0013kN,'/\u00139BI\u0012\u0014Xm]:MS6LG\u000fC\u0004\u0004.v\u0002\raa \u0002#U\u001cXM]+oY&l\u0017\u000e^3e\u0019&\u001cH\u000fC\u0004\u00042v\u0002\raa \u0002\u0019U\u001cXM\u001d#f]fd\u0015n\u001d;\t\u000f\rUV\b1\u0001\u0004\u0000\u0005Q\u0011\u000e\u001d#f]fd\u0015n\u001d;\u0002/M$\u0018M\u001d;F]\u001eLg.Z!mSZ,7\t[3dW\u0016\u0014\u0018!I5oSR,enZ5oKN#\u0018M\u001d;vaB\u0013xnY3tgN+W.\u00199i_J,G\u0003BA\u0010\u0007{Cq!a9@\u0001\u0004\t)\u000f")
public class KyuubiSessionManager
extends SessionManager {
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private Option<MetadataManager> metadataManager = None$.MODULE$;
    private KyuubiApplicationManager applicationManager;
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public Option<MetadataManager> metadataManager() {
        return this.metadataManager;
    }

    public void metadataManager_$eq(Option<MetadataManager> x$1) {
        this.metadataManager = x$1;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    public void applicationManager_$eq(KyuubiApplicationManager x$1) {
        this.applicationManager = x$1;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (conf.isRESTEnabled()) {
            this.metadataManager_$eq((Option<MetadataManager>)new Some((Object)new MetadataManager()));
        }
        this.applicationManager_$eq(new KyuubiApplicationManager(this.metadataManager()));
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        Set ipDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$6(x$22)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$23)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$25, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$26)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$28, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyIps() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyIps((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyIps(KyuubiConf conf) {
        Set denyIps = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyIps$1(x$29)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$30 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$30, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$31, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList, Set<String> ipDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$32 -> x$32 > 0) || userDenyList.nonEmpty() || ipDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList, ipDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveUserSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$6(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyIps$1(String x$29) {
        return new StringOps(Predef$.MODULE$.augmentString(x$29)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

