/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EmbeddedScript;
import com.github.sommeri.less4j.core.ast.EmptyExpression;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.KeywordExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.UnicodeRangeExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.PrintUtils;
import com.github.sommeri.less4j.utils.URIUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TermBuilder {
    private static final String URL = "url";
    private final ASTBuilderSwitch parentBuilder;
    private ProblemsHandler problemsHandler;

    public TermBuilder(ASTBuilderSwitch astBuilderSwitch, ProblemsHandler problemsHandler) {
        this.parentBuilder = astBuilderSwitch;
        this.problemsHandler = problemsHandler;
    }

    public Expression buildFromTerm(HiddenTokenAwareTree token) {
        return this.buildFromTerm(token, token, 0);
    }

    public Expression buildFromChildTerm(HiddenTokenAwareTree token) {
        return this.buildFromChildTerm(token, 0);
    }

    private Expression buildFromChildTerm(HiddenTokenAwareTree token, int offsetChildIndx) {
        HiddenTokenAwareTree offsetChild = token.getChildren().get(offsetChildIndx);
        return this.buildFromTerm(token, offsetChild, offsetChildIndx);
    }

    private Expression buildFromTerm(HiddenTokenAwareTree token, HiddenTokenAwareTree offsetChild, int offsetChildIndx) {
        switch (offsetChild.getGeneralType()) {
            case 21: {
                return this.buildFromLongIdentifier(token, offsetChild);
            }
            case 74: 
            case 141: {
                return this.buildFromPercent(token, offsetChild);
            }
            case 79: {
                return this.buildFromString(token, offsetChild);
            }
            case 114: {
                return this.buildFromColorHash(token, offsetChild);
            }
            case 99: 
            case 107: {
                return this.negate(this.buildFromChildTerm(token, offsetChildIndx + 1), offsetChild);
            }
            case 106: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                return this.buildFromNumber(token, offsetChild);
            }
            case 143: {
                return this.buildFromSpecialFunction(token, URL, offsetChild);
            }
            case 145: {
                return this.buildFromSpecialFunction(token, "domain", offsetChild);
            }
            case 144: {
                return this.buildFromSpecialFunction(token, "url-prefix", offsetChild);
            }
            case 29: {
                return this.buildFromNormalFunction(token, offsetChild);
            }
            case 92: {
                return this.buildFromVariable(token, offsetChild);
            }
            case 9: {
                return this.buildFromVariableReference(token, offsetChild);
            }
            case 97: {
                return this.buildFromIndirectVariable(token, offsetChild);
            }
            case 31: {
                return this.buildFromChildTerm(offsetChild);
            }
            case 15: {
                return this.buildFromParentheses(offsetChild);
            }
            case 16: {
                return this.buildFromEscapedValue(token, offsetChild);
            }
            case 140: {
                return this.buildFromUnicodeRange(token, offsetChild);
            }
            case 139: {
                return this.buildFromEscapedScript(token, offsetChild);
            }
            case 138: {
                return this.buildFromEmbeddedScript(token, offsetChild);
            }
        }
        throw new BugHappened("type number: " + PrintUtils.toName(offsetChild.getGeneralType()) + "(" + offsetChild.getGeneralType() + ") for " + offsetChild.getText(), offsetChild);
    }

    private Expression buildFromParentheses(HiddenTokenAwareTree first) {
        first.addBeforeFollowing(first.getLastChild().getFollowing());
        return new ParenthesesExpression(first, this.parentBuilder.handleExpression(first.getChild(1)));
    }

    private Expression buildFromColorHash(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        ColorExpression parsedColor = ConversionUtils.parseColor(token, text);
        if (parsedColor == null) {
            FaultyExpression faultyExpression = new FaultyExpression(token);
            this.problemsHandler.notAColor(faultyExpression, text);
            return faultyExpression;
        }
        return parsedColor;
    }

    private Expression negate(Expression value, HiddenTokenAwareTree sign) {
        if (value instanceof NumberExpression) {
            NumberExpression number = (NumberExpression)value;
            number.setExpliciteSign(true);
            if (sign.getGeneralType() == 107) {
                number.negate();
                number.setOriginalString("-" + number.getOriginalString());
            } else if (sign.getGeneralType() == 99) {
                number.setOriginalString("+" + number.getOriginalString());
            }
            return number;
        }
        if (sign.getGeneralType() == 107) {
            return new SignedExpression(sign, SignedExpression.Sign.MINUS, value);
        }
        return new SignedExpression(sign, SignedExpression.Sign.PLUS, value);
    }

    private NumberExpression buildFromNumber(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        NumberExpression result = new NumberExpression(token);
        String valueAsString = actual.getText().trim();
        this.setDoubleAndType(result, valueAsString);
        result.setOriginalString(valueAsString);
        result.setDimension(this.toDimension(actual));
        return result;
    }

    private void setDoubleAndType(NumberExpression result, String value) {
        value = value.toLowerCase().trim();
        String numberPart = value.replaceAll("[^0-9\\.]*", "");
        result.setValueAsDouble(Double.valueOf(numberPart));
        if (numberPart.length() < value.length()) {
            result.setSuffix(value.substring(numberPart.length()));
        } else {
            result.setSuffix("");
        }
    }

    private NumberExpression.Dimension toDimension(HiddenTokenAwareTree actual) {
        switch (actual.getGeneralType()) {
            case 106: {
                return NumberExpression.Dimension.NUMBER;
            }
            case 124: {
                return NumberExpression.Dimension.PERCENTAGE;
            }
            case 125: {
                return NumberExpression.Dimension.UNKNOWN;
            }
            case 123: {
                return NumberExpression.Dimension.REPEATER;
            }
            case 119: {
                return NumberExpression.Dimension.LENGTH;
            }
            case 117: {
                return NumberExpression.Dimension.EMS;
            }
            case 118: {
                return NumberExpression.Dimension.EXS;
            }
            case 120: {
                return NumberExpression.Dimension.ANGLE;
            }
            case 121: {
                return NumberExpression.Dimension.TIME;
            }
            case 122: {
                return NumberExpression.Dimension.FREQ;
            }
        }
        throw new BugHappened("Unknown dimension type: " + actual.getGeneralType() + " " + actual.getText(), actual);
    }

    public EscapedValue buildFromEscapedValue(HiddenTokenAwareTree token, HiddenTokenAwareTree offsetChild) {
        token.pushHiddenToKids();
        offsetChild.pushHiddenToKids();
        HiddenTokenAwareTree valueToken = offsetChild.getChild(0);
        String quotedText = valueToken.getText();
        return new EscapedValue(valueToken, quotedText.substring(2, quotedText.length() - 1), quotedText.substring(1, 1));
    }

    private Expression buildFromString(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        return this.createCssString(token, text);
    }

    public CssString createCssString(HiddenTokenAwareTree token, String quotedText) {
        return new CssString(token, quotedText.substring(1, quotedText.length() - 1), quotedText.substring(0, 1));
    }

    private Expression buildFromEscapedScript(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        text = text.substring(2, text.length() - 1);
        return new FunctionExpression(token, "~`", new EmbeddedScript(token, text));
    }

    private Expression buildFromEmbeddedScript(HiddenTokenAwareTree token, HiddenTokenAwareTree first) {
        String text = first.getText();
        text = text.substring(1, text.length() - 1);
        return new FunctionExpression(token, "`", new EmbeddedScript(token, text));
    }

    private Expression buildFromPercent(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        String text = first.getText();
        return this.createIdentifierExpression(parent, text);
    }

    private Expression buildFromLongIdentifier(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        StringBuilder text = new StringBuilder();
        List<HiddenTokenAwareTree> children = first.getChildren();
        for (HiddenTokenAwareTree child : children) {
            text.append(child.getText().trim());
        }
        if (children.size() == 1 && children.get(0).getGeneralType() == 134) {
            return new KeywordExpression(parent, children.get(0).getText().trim(), true);
        }
        return this.createIdentifierExpression(parent, text.toString());
    }

    private Expression createIdentifierExpression(HiddenTokenAwareTree parent, String text) {
        if (NamedColorExpression.isColorName(text)) {
            return NamedColorExpression.createNamedColorExpression(parent, text);
        }
        return new IdentifierExpression(parent, text);
    }

    private Expression buildFromUnicodeRange(HiddenTokenAwareTree parent, HiddenTokenAwareTree first) {
        return new UnicodeRangeExpression(parent, first.getText());
    }

    private FunctionExpression buildFromSpecialFunction(HiddenTokenAwareTree token, String function, HiddenTokenAwareTree first) {
        Expression parameter = this.extractUrlParameter(token, function, this.normalizeNewLineSymbols(first.getText()));
        parameter = this.packIntoListExpression(parameter);
        return new FunctionExpression(token, function, parameter);
    }

    private String normalizeNewLineSymbols(String text) {
        return text.replaceAll("\r?\n", "\n");
    }

    private Expression extractUrlParameter(HiddenTokenAwareTree token, String function, String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= function.length() + 2) {
            return new CssString(token, "", "");
        }
        String string = text.substring(function.length() + 1, text.length() - 1);
        if (!URIUtils.isQuotedUrl(string)) {
            return new CssString(token, string, "");
        }
        String quote = String.valueOf(string.charAt(0));
        return new CssString(token, string.substring(1, string.length() - 1), quote);
    }

    private FunctionExpression buildFromNormalFunction(HiddenTokenAwareTree token, HiddenTokenAwareTree actual) {
        List<HiddenTokenAwareTree> children = actual.getChildren();
        String name = this.buildFunctionName(children.get(0));
        if (children.size() == 1) {
            return new FunctionExpression(token, name, new EmptyExpression(token));
        }
        HiddenTokenAwareTree parameterNode = children.get(1);
        Expression parameter = (Expression)this.parentBuilder.switchOn(parameterNode);
        if (!this.isListOfParameters(parameter)) {
            parameter = this.packIntoListExpression(parameter);
        }
        return new FunctionExpression(token, name, parameter);
    }

    private Expression packIntoListExpression(Expression parameter) {
        ListExpressionOperator operator = new ListExpressionOperator(parameter.getUnderlyingStructure(), ListExpressionOperator.Operator.COMMA);
        return new ListExpression(parameter.getUnderlyingStructure(), this.asList(parameter), operator);
    }

    private List<Expression> asList(Expression ... parameter) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression expression : parameter) {
            result.add(expression);
        }
        return result;
    }

    private boolean isListOfParameters(Expression parameter) {
        if (parameter.getType() != ASTCssNodeType.LIST_EXPRESSION) {
            return false;
        }
        ListExpression list = (ListExpression)parameter;
        return list.getOperator().getOperator() == ListExpressionOperator.Operator.COMMA;
    }

    private String buildFunctionName(HiddenTokenAwareTree token) {
        String result = "";
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            result = result + kid.getText();
        }
        return result;
    }

    public Variable buildFromVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromVariable(null, variableToken);
    }

    private Variable buildFromVariable(HiddenTokenAwareTree realOwner, HiddenTokenAwareTree variableToken) {
        if (realOwner != null) {
            realOwner.addFollowing(variableToken.getFollowing());
            return new Variable(realOwner, variableToken.getText());
        }
        return new Variable(variableToken, variableToken.getText());
    }

    public Variable buildFromVariableReference(HiddenTokenAwareTree variableToken) {
        return this.buildFromVariableReference(null, variableToken);
    }

    private Variable buildFromVariableReference(HiddenTokenAwareTree realOwner, HiddenTokenAwareTree variableToken) {
        Iterator<HiddenTokenAwareTree> kids = variableToken.getChildren().iterator();
        HiddenTokenAwareTree name = kids.next();
        boolean isCollector = kids.hasNext();
        if (realOwner != null) {
            realOwner.addFollowing(variableToken.getFollowing());
            return new Variable(realOwner, name.getText(), false, isCollector);
        }
        return new Variable(variableToken, name.getText(), false, isCollector);
    }

    public IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree variableToken) {
        return this.buildFromIndirectVariable(null, variableToken);
    }

    private IndirectVariable buildFromIndirectVariable(HiddenTokenAwareTree expressionToken, HiddenTokenAwareTree variableToken) {
        if (expressionToken != null) {
            expressionToken.addFollowing(variableToken.getFollowing());
            return new IndirectVariable(expressionToken, variableToken.getText().substring(1));
        }
        return new IndirectVariable(variableToken, variableToken.getText().substring(1));
    }
}

