/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.FacilityManager;

public class Tiler
extends ImgDataAdapter
implements BlkImgDataSrc {
    private BlkImgDataSrc src = null;
    private int x0siz;
    private int y0siz;
    private int xt0siz;
    private int yt0siz;
    private int xtsiz;
    private int ytsiz;
    private int ntX;
    private int ntY;
    private int[] compW = null;
    private int[] compH = null;
    private int[] tcx0 = null;
    private int[] tcy0 = null;
    private int tx;
    private int ty;
    private int tileW;
    private int tileH;

    public Tiler(BlkImgDataSrc src, int ax, int ay, int px, int py, int nw, int nh) {
        super(src);
        this.src = src;
        this.x0siz = ax;
        this.y0siz = ay;
        this.xt0siz = px;
        this.yt0siz = py;
        this.xtsiz = nw;
        this.ytsiz = nh;
        if (src.getNumTiles() != 1) {
            throw new IllegalArgumentException("Source is tiled");
        }
        if (src.getImgULX() != 0 || src.getImgULY() != 0) {
            throw new IllegalArgumentException("Source is \"canvased\"");
        }
        if (this.x0siz < 0 || this.y0siz < 0 || this.xt0siz < 0 || this.yt0siz < 0 || this.xtsiz < 0 || this.ytsiz < 0 || this.xt0siz > this.x0siz || this.yt0siz > this.y0siz) {
            throw new IllegalArgumentException("Invalid image origin, tiling origin or nominal tile size");
        }
        if (this.xtsiz == 0) {
            this.xtsiz = this.x0siz + src.getImgWidth() - this.xt0siz;
        }
        if (this.ytsiz == 0) {
            this.ytsiz = this.y0siz + src.getImgHeight() - this.yt0siz;
        }
        if (this.x0siz - this.xt0siz >= this.xtsiz) {
            this.xt0siz += (this.x0siz - this.xt0siz) / this.xtsiz * this.xtsiz;
        }
        if (this.y0siz - this.yt0siz >= this.ytsiz) {
            this.yt0siz += (this.y0siz - this.yt0siz) / this.ytsiz * this.ytsiz;
        }
        if (this.x0siz - this.xt0siz >= this.xtsiz || this.y0siz - this.yt0siz >= this.ytsiz) {
            FacilityManager.getMsgLogger().printmsg(1, "Automatically adjusted tiling origin to equivalent one (" + this.xt0siz + "," + this.yt0siz + ") so that " + "first tile overlaps the image");
        }
        this.ntX = (int)Math.ceil((double)(this.x0siz + src.getImgWidth()) / (double)this.xtsiz);
        this.ntY = (int)Math.ceil((double)(this.y0siz + src.getImgHeight()) / (double)this.ytsiz);
    }

    @Override
    public final int getTileWidth() {
        return this.tileW;
    }

    @Override
    public final int getTileHeight() {
        return this.tileH;
    }

    @Override
    public final int getTileCompWidth(int t, int c) {
        if (t != this.getTileIdx()) {
            throw new Error("Asking the width of a tile-component which is not in the current tile (call setTile() or nextTile() methods before).");
        }
        return this.compW[c];
    }

    @Override
    public final int getTileCompHeight(int t, int c) {
        if (t != this.getTileIdx()) {
            throw new Error("Asking the width of a tile-component which is not in the current tile (call setTile() or nextTile() methods before).");
        }
        return this.compH[c];
    }

    @Override
    public int getFixedPoint(int c) {
        return this.src.getFixedPoint(c);
    }

    @Override
    public final DataBlk getInternCompData(DataBlk blk, int c) {
        if (blk.ulx < 0 || blk.uly < 0 || blk.w > this.compW[c] || blk.h > this.compH[c]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        int incx = (int)Math.ceil((double)this.x0siz / (double)this.src.getCompSubsX(c));
        int incy = (int)Math.ceil((double)this.y0siz / (double)this.src.getCompSubsY(c));
        blk.ulx -= incx;
        blk.uly -= incy;
        blk = this.src.getInternCompData(blk, c);
        blk.ulx += incx;
        blk.uly += incy;
        return blk;
    }

    @Override
    public final DataBlk getCompData(DataBlk blk, int c) {
        if (blk.ulx < 0 || blk.uly < 0 || blk.w > this.compW[c] || blk.h > this.compH[c]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        int incx = (int)Math.ceil((double)this.x0siz / (double)this.src.getCompSubsX(c));
        int incy = (int)Math.ceil((double)this.y0siz / (double)this.src.getCompSubsY(c));
        blk.ulx -= incx;
        blk.uly -= incy;
        blk = this.src.getCompData(blk, c);
        blk.ulx += incx;
        blk.uly += incy;
        return blk;
    }

    @Override
    public final void setTile(int x, int y) {
        if (x < 0 || y < 0 || x >= this.ntX || y >= this.ntY) {
            throw new IllegalArgumentException("Tile's indexes out of bounds");
        }
        this.tx = x;
        this.ty = y;
        int tx0 = x != 0 ? this.xt0siz + x * this.xtsiz : this.x0siz;
        int ty0 = y != 0 ? this.yt0siz + y * this.ytsiz : this.y0siz;
        int tx1 = x != this.ntX - 1 ? this.xt0siz + (x + 1) * this.xtsiz : this.x0siz + this.src.getImgWidth();
        int ty1 = y != this.ntY - 1 ? this.yt0siz + (y + 1) * this.ytsiz : this.y0siz + this.src.getImgHeight();
        this.tileW = tx1 - tx0;
        this.tileH = ty1 - ty0;
        int nc = this.src.getNumComps();
        if (this.compW == null) {
            this.compW = new int[nc];
        }
        if (this.compH == null) {
            this.compH = new int[nc];
        }
        if (this.tcx0 == null) {
            this.tcx0 = new int[nc];
        }
        if (this.tcy0 == null) {
            this.tcy0 = new int[nc];
        }
        for (int i = 0; i < nc; ++i) {
            this.tcx0[i] = (int)Math.ceil((double)tx0 / (double)this.src.getCompSubsX(i));
            this.tcy0[i] = (int)Math.ceil((double)ty0 / (double)this.src.getCompSubsY(i));
            this.compW[i] = (int)Math.ceil((double)tx1 / (double)this.src.getCompSubsX(i)) - this.tcx0[i];
            this.compH[i] = (int)Math.ceil((double)ty1 / (double)this.src.getCompSubsY(i)) - this.tcy0[i];
        }
    }

    @Override
    public final void nextTile() {
        if (this.tx == this.ntX - 1 && this.ty == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.tx < this.ntX - 1) {
            this.setTile(this.tx + 1, this.ty);
        } else {
            this.setTile(0, this.ty + 1);
        }
    }

    @Override
    public final Coord getTile(Coord co) {
        if (co != null) {
            co.x = this.tx;
            co.y = this.ty;
            return co;
        }
        return new Coord(this.tx, this.ty);
    }

    @Override
    public final int getTileIdx() {
        return this.ty * this.ntX + this.tx;
    }

    @Override
    public final int getCompULX(int c) {
        return this.tcx0[c];
    }

    @Override
    public final int getCompULY(int c) {
        return this.tcy0[c];
    }

    @Override
    public int getTilePartULX() {
        return this.xt0siz;
    }

    @Override
    public int getTilePartULY() {
        return this.yt0siz;
    }

    @Override
    public final int getImgULX() {
        return this.x0siz;
    }

    @Override
    public final int getImgULY() {
        return this.y0siz;
    }

    @Override
    public final Coord getNumTiles(Coord co) {
        if (co != null) {
            co.x = this.ntX;
            co.y = this.ntY;
            return co;
        }
        return new Coord(this.ntX, this.ntY);
    }

    @Override
    public final int getNumTiles() {
        return this.ntX * this.ntY;
    }

    @Override
    public final int getNomTileWidth() {
        return this.xtsiz;
    }

    @Override
    public final int getNomTileHeight() {
        return this.ytsiz;
    }

    public final Coord getTilingOrigin(Coord co) {
        if (co != null) {
            co.x = this.xt0siz;
            co.y = this.yt0siz;
            return co;
        }
        return new Coord(this.xt0siz, this.yt0siz);
    }

    public String toString() {
        return "Tiler: source= " + this.src + "\n" + this.getNumTiles() + " tile(s), nominal width=" + this.xtsiz + ", nominal height=" + this.ytsiz;
    }
}

