/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.opensaml.InvalidCryptoException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class SAMLSignedObject
extends SAMLObject
implements Cloneable {
    private XMLSignature sig = null;
    private boolean sig_from_parse = false;

    public Object getNativeSignature() {
        return this.sig;
    }

    public abstract String getId();

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        Element element2 = XML.getFirstChildElement(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (element2 != null) {
            try {
                this.sig = new XMLSignature(element2, "");
                this.sig_from_parse = true;
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new InvalidCryptoException("SAMLSignedObject.fromDOM() detected an XML security exception: " + xMLSecurityException.getMessage(), (Exception)((Object)xMLSecurityException));
            }
        }
    }

    public Node toDOM(boolean bl) throws SAMLException {
        if (this.root == null && this.sig != null) {
            return this.toDOM(this.sig.getDocument(), bl);
        }
        return super.toDOM(bl);
    }

    protected abstract void insertSignature() throws SAMLException;

    protected Element getSignatureElement() {
        return this.sig != null ? this.sig.getElement() : null;
    }

    protected void setDirty(boolean bl) {
        if (bl) {
            this.unsign();
        }
        super.setDirty(bl);
    }

    public void unsign() {
        if (this.sig != null && this.sig.getElement().getParentNode() != null) {
            this.sig.getElement().getParentNode().removeChild(this.sig.getElement());
        }
        this.sig = null;
    }

    public void sign(String string, Key key, Collection collection) throws SAMLException {
        this.sign(string, null, key, collection);
    }

    public void sign(String string, String string2, Key key, Collection collection) throws SAMLException {
        this.unsign();
        this.toDOM();
        this.plantRoot();
        try {
            this.sig = new XMLSignature(this.root.getOwnerDocument(), "", string, "http://www.w3.org/2001/10/xml-exc-c14n#");
            this.insertSignature();
            Transforms transforms = new Transforms(this.sig.getDocument());
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            transforms.item(1).getElement().appendChild(new InclusiveNamespaces(this.root.getOwnerDocument(), this.config.getProperty("org.opensaml.inclusive-namespace-prefixes")).getElement());
            if (this.config.getBooleanProperty("org.opensaml.compatibility-mode")) {
                this.sig.addDocument("", transforms, string2 != null ? string2 : "http://www.w3.org/2000/09/xmldsig#sha1");
            } else {
                this.sig.addDocument("#" + this.getId(), transforms, string2 != null ? string2 : "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            X509Data x509Data = new X509Data(this.root.getOwnerDocument());
            if (collection != null) {
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof X509Certificate) {
                        if (!iterator.hasNext() && n > 0 && ((Object)((X509Certificate)e).getSubjectDN()).equals(((X509Certificate)e).getIssuerDN())) break;
                        x509Data.addCertificate((X509Certificate)e);
                    }
                    ++n;
                }
            }
            if (x509Data.lengthCertificate() > 0) {
                KeyInfo keyInfo = new KeyInfo(this.root.getOwnerDocument());
                keyInfo.add(x509Data);
                this.sig.getElement().appendChild(keyInfo.getElement());
            }
            this.sig.sign(key);
        }
        catch (XMLSecurityException xMLSecurityException) {
            this.unsign();
            throw new InvalidCryptoException("SAMLSignedObject.sign() detected an XML security exception: " + xMLSecurityException.getMessage(), (Exception)((Object)xMLSecurityException));
        }
    }

    public void verify() throws SAMLException {
        this.verify((Key)null);
    }

    public void verify(Certificate certificate) throws SAMLException {
        this.verify(certificate.getPublicKey());
    }

    public void verify(Key key) throws SAMLException {
        if (!this.isSigned()) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() can't verify unsigned object");
        }
        try {
            Transforms transforms;
            Object object;
            boolean bl = false;
            SignedInfo signedInfo = this.sig.getSignedInfo();
            if (signedInfo.getLength() == 1 && ((object = signedInfo.item(0)).getURI() == null || object.getURI().equals("") || object.getURI().equals("#" + this.getId()))) {
                transforms = object.getTransforms();
                for (int i = 0; i < transforms.getLength(); ++i) {
                    if (transforms.item(i).getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                        bl = true;
                        continue;
                    }
                    if (transforms.item(i).getURI().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() detected an invalid signature profile");
            }
            if (key == null) {
                if (this.sig_from_parse) {
                    key = this.sig.getKeyInfo().getPublicKey();
                } else {
                    object = new ByteArrayOutputStream();
                    transforms = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    ((OutputStream)object).write(transforms.canonicalizeSubtree(this.sig.getElement().getLastChild()));
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                    KeyInfo keyInfo = new KeyInfo(XML.parserPool.parse(byteArrayInputStream).getDocumentElement(), "");
                    key = keyInfo.getPublicKey();
                }
            }
            if (!this.sig.checkSignatureValue(key)) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() failed to validate signature value");
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an XML security exception: " + xMLSecurityException.getMessage(), (Exception)((Object)xMLSecurityException));
        }
        catch (IOException iOException) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an I/O exception: " + iOException.getMessage(), (Exception)iOException);
        }
        catch (SAXException sAXException) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected a XML parsing exception: " + sAXException.getMessage(), (Exception)sAXException);
        }
    }

    public Iterator getX509Certificates() throws SAMLException {
        if (this.isSigned()) {
            KeyInfo keyInfo = this.sig.getKeyInfo();
            if (keyInfo != null && keyInfo.containsX509Data()) {
                try {
                    for (int i = 0; i < keyInfo.lengthX509Data(); ++i) {
                        X509Data x509Data = keyInfo.itemX509Data(i);
                        if (!x509Data.containsCertificate()) continue;
                        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509Data.lengthCertificate());
                        for (int j = 0; j < x509Data.lengthCertificate(); ++j) {
                            arrayList.add(x509Data.itemCertificate(j).getX509Certificate());
                        }
                        return arrayList.iterator();
                    }
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() detected an XML security exception: " + xMLSecurityException.getMessage(), (Exception)((Object)xMLSecurityException));
                }
            }
            throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't find any X.509 certificates in signature");
        }
        throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't examine unsigned object");
    }

    public String getSignatureAlgorithm() throws SAMLException {
        if (this.isSigned()) {
            return this.sig.getSignedInfo().getSignatureMethodURI();
        }
        throw new InvalidCryptoException("SAMLSignedObject.getSignatureAlgorithm() can't examine unsigned object");
    }

    public String getDigestAlgorithm() throws SAMLException {
        SignedInfo signedInfo;
        if (this.isSigned() && (signedInfo = this.sig.getSignedInfo()).getLength() == 1) {
            try {
                Reference reference = signedInfo.item(0);
                return reference.getMessageDigestAlgorithm().getAlgorithmURI();
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new InvalidCryptoException("SAMLSignedObject.getDigestAlgorithm() detected an XML security exception: " + xMLSecurityException.getMessage(), (Exception)((Object)xMLSecurityException));
            }
        }
        throw new InvalidCryptoException("SAMLSignedObject.getDigestAlgorithm() can't examine unsigned or improperly signed object");
    }

    public boolean isSigned() {
        return this.sig != null;
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLSignedObject sAMLSignedObject = (SAMLSignedObject)super.clone();
        sAMLSignedObject.sig = null;
        return sAMLSignedObject;
    }
}

