/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.pdfbox.debugger.ui.MenuBase;

public final class PrintDpiMenu
extends MenuBase {
    private static final int[] DPIS = new int[]{0, 100, 200, 300, 600, 1200};
    private static PrintDpiMenu instance;
    private final JMenu menu = new JMenu("Print dpi");

    private PrintDpiMenu() {
        ButtonGroup bg = new ButtonGroup();
        for (int dpi : DPIS) {
            PrintDpiMenuItem printDpiMenuItem = new PrintDpiMenuItem(dpi == 0 ? "auto" : "" + dpi, dpi);
            bg.add(printDpiMenuItem);
            this.menu.add(printDpiMenuItem);
        }
        this.changeDpiSelection(0);
        this.setMenu(this.menu);
    }

    public static PrintDpiMenu getInstance() {
        if (instance == null) {
            instance = new PrintDpiMenu();
        }
        return instance;
    }

    public void changeDpiSelection(int selection) {
        for (Component comp : this.menu.getMenuComponents()) {
            PrintDpiMenuItem menuItem = (PrintDpiMenuItem)comp;
            if (menuItem.dpi != selection) continue;
            menuItem.setSelected(true);
            return;
        }
        throw new IllegalArgumentException("no dpi menu item found for: " + selection);
    }

    public static int getDpiSelection() {
        for (Component comp : PrintDpiMenu.instance.menu.getMenuComponents()) {
            PrintDpiMenuItem menuItem = (PrintDpiMenuItem)comp;
            if (!menuItem.isSelected()) continue;
            return menuItem.dpi;
        }
        throw new IllegalStateException("no dpi menu item is selected");
    }

    private static class PrintDpiMenuItem
    extends JRadioButtonMenuItem {
        private final int dpi;

        PrintDpiMenuItem(String text, int dpi) {
            super(text);
            this.dpi = dpi;
        }
    }
}

