/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.apache.sis.internal.storage.io.InputStreamAdapter;
import org.apache.sis.io.InvalidSeekException;

public final class RewindableLineReader
extends LineNumberReader {
    public static final int BUFFER_SIZE = 8192;
    private InputStreamAdapter input;
    private final Charset encoding;

    public RewindableLineReader(InputStream inputStream, Charset charset) throws IOException {
        super(charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream), 8192);
        if (inputStream instanceof InputStreamAdapter) {
            this.input = (InputStreamAdapter)inputStream;
        }
        this.encoding = charset;
        super.mark(8192);
        this.lock = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RewindableLineReader rewind() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.reset();
                return this;
            }
            catch (IOException iOException) {
                InputStreamAdapter inputStreamAdapter = this.input;
                if (inputStreamAdapter == null) {
                    throw new InvalidSeekException();
                }
                this.input = null;
                assert (Thread.holdsLock(inputStreamAdapter));
                try {
                    inputStreamAdapter.keepOpen = true;
                    super.close();
                }
                finally {
                    inputStreamAdapter.keepOpen = false;
                }
                try {
                    inputStreamAdapter.input.seek(0L);
                }
                catch (IOException iOException2) {
                    iOException2.addSuppressed(iOException);
                    throw iOException2;
                }
                return new RewindableLineReader(inputStreamAdapter, this.encoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input = null;
            super.close();
        }
    }
}

