/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.NoMessageBodyWriterFoundFailure;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.interception.ContainerResponseContextImpl;
import org.jboss.resteasy.core.interception.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.ServerWriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

public class ServerResponseWriter {
    public static void writeNomapResponse(BuiltResponse jaxrsResponse, HttpRequest request, final HttpResponse response, ResteasyProviderFactory providerFactory) throws IOException {
        Annotation[] annotations;
        ResourceMethodInvoker method = (ResourceMethodInvoker)request.getAttribute(ResourceMethodInvoker.class.getName());
        if (jaxrsResponse.getEntity() != null && jaxrsResponse.getMediaType() == null) {
            ServerResponseWriter.setDefaultContentType(request, jaxrsResponse, providerFactory, method);
        }
        ServerResponseWriter.executeFilters(jaxrsResponse, request, response, providerFactory, method);
        if (jaxrsResponse.getEntity() == null || request.getHttpMethod().equalsIgnoreCase("HEAD")) {
            response.setStatus(jaxrsResponse.getStatus());
            ServerResponseWriter.commitHeaders(jaxrsResponse, response);
            return;
        }
        Class type = jaxrsResponse.getEntityClass();
        Object ent = jaxrsResponse.getEntity();
        Type generic = jaxrsResponse.getGenericType();
        MessageBodyWriter writer = providerFactory.getMessageBodyWriter(type, generic, annotations = jaxrsResponse.getAnnotations(), jaxrsResponse.getMediaType());
        if (writer == null) {
            throw new NoMessageBodyWriterFoundFailure(type, jaxrsResponse.getMediaType());
        }
        response.setStatus(jaxrsResponse.getStatus());
        final BuiltResponse built = jaxrsResponse;
        CommitHeaderOutputStream.CommitCallback callback = new CommitHeaderOutputStream.CommitCallback(){
            private boolean committed;

            @Override
            public void commit() {
                if (this.committed) {
                    return;
                }
                this.committed = true;
                ServerResponseWriter.commitHeaders(built, response);
            }
        };
        CommitHeaderOutputStream os = new CommitHeaderOutputStream(response.getOutputStream(), callback);
        WriterInterceptor[] writerInterceptors = null;
        writerInterceptors = method != null ? method.getWriterInterceptors() : (WriterInterceptor[])providerFactory.getServerWriterInterceptorRegistry().postMatch(null, null);
        ServerWriterInterceptorContext writerContext = new ServerWriterInterceptorContext(writerInterceptors, providerFactory, ent, type, generic, annotations, jaxrsResponse.getMediaType(), jaxrsResponse.getMetadata(), os, request);
        writerContext.proceed();
        callback.commit();
    }

    private static void executeFilters(BuiltResponse jaxrsResponse, HttpRequest request, HttpResponse response, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) throws IOException {
        ContainerResponseFilter[] responseFilters = null;
        responseFilters = method != null ? method.getResponseFilters() : (ContainerResponseFilter[])providerFactory.getContainerResponseFilterRegistry().postMatch(null, null);
        if (responseFilters != null) {
            ResponseContainerRequestContext requestContext = new ResponseContainerRequestContext(request);
            ContainerResponseContextImpl responseContext = new ContainerResponseContextImpl(request, response, jaxrsResponse);
            for (ContainerResponseFilter filter : responseFilters) {
                filter.filter((ContainerRequestContext)requestContext, (ContainerResponseContext)responseContext);
            }
        }
    }

    protected static void setDefaultContentType(HttpRequest request, BuiltResponse jaxrsResponse, ResteasyProviderFactory providerFactory, ResourceMethodInvoker method) {
        MediaType chosen = (MediaType)request.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        if (chosen != null && chosen.isWildcardSubtype()) {
            chosen = null;
        }
        if (chosen == null && method != null) {
            for (MediaType produce : method.getProduces()) {
                if (produce.isWildcardType()) continue;
                chosen = produce;
                if (!produce.isWildcardSubtype()) break;
            }
        }
        if (chosen == null) {
            MediaType mt;
            Annotation[] annotations;
            chosen = MediaType.WILDCARD_TYPE;
            Class type = jaxrsResponse.getEntityClass();
            Object ent = jaxrsResponse.getEntity();
            Type generic = jaxrsResponse.getGenericType();
            if (generic == null) {
                generic = method != null && !Response.class.isAssignableFrom(method.getMethod().getReturnType()) ? method.getGenericReturnType() : type;
            }
            if ((annotations = jaxrsResponse.getAnnotations()) == null && method != null) {
                annotations = method.getMethodAnnotations();
            }
            if ((mt = providerFactory.getConcreteMediaTypeFromMessageBodyWriters(type, generic, annotations, chosen)) != null) {
                jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)mt);
                return;
            }
        }
        if (chosen.isWildcardType()) {
            chosen = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        } else if (chosen.isWildcardSubtype() && chosen.getSubtype().equals("application")) {
            chosen = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        } else if (chosen.isWildcardSubtype()) {
            throw new NotAcceptableException(Messages.MESSAGES.illegalResponseMediaType(chosen.toString()));
        }
        jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)chosen);
    }

    public static MediaType resolveContentType(BuiltResponse response) {
        MediaType responseContentType = null;
        Object type = response.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public static void commitHeaders(BuiltResponse jaxrsResponse, HttpResponse response) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll(jaxrsResponse.getMetadata());
        }
    }
}

