/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cli;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.utils.ExecHelper;
import org.mvndaemon.mvnd.common.JavaVersion;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.nativ.CLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvHelper.class);

    private EnvHelper() {
    }

    public static void environment(String workingDir, Map<String, String> clientEnv) {
        EnvHelper.environment(workingDir, clientEnv, arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    public static void environment(String workingDir, Map<String, String> clientEnv, Consumer<String> log) {
        TreeMap<String, String> requested = new TreeMap<String, String>(clientEnv);
        TreeMap<String, String> actual = new TreeMap<String, String>(System.getenv());
        requested.put("PWD", Os.current().isCygwin() ? EnvHelper.toCygwin(workingDir) : workingDir);
        List<String> diffs = Stream.concat(requested.keySet().stream(), actual.keySet().stream()).sorted().distinct().filter(s -> !s.startsWith("JAVA_MAIN_CLASS_")).filter(key -> !Objects.equals(requested.get(key), actual.get(key))).collect(Collectors.toList());
        try {
            for (String key2 : diffs) {
                String vr = (String)requested.get(key2);
                int rc = CLibrary.setenv((String)key2, (String)vr);
                if (!(Os.current() == Os.WINDOWS ^ rc != 0)) continue;
                log.accept(String.format("Error setting environment value %s = %s", key2, vr));
            }
            EnvHelper.setEnv(requested);
            EnvHelper.chDir(workingDir);
        }
        catch (Exception e) {
            log.accept("Environment mismatch ! Could not set the environment (" + e + ")");
        }
        TreeMap<String, String> nactual = new TreeMap<String, String>(System.getenv());
        diffs = Stream.concat(requested.keySet().stream(), actual.keySet().stream()).sorted().distinct().filter(s -> !s.startsWith("JAVA_MAIN_CLASS_")).filter(key -> !Objects.equals(requested.get(key), nactual.get(key))).collect(Collectors.toList());
        if (!diffs.isEmpty()) {
            log.accept("A few environment mismatches have been detected between the client and the daemon.");
            diffs.forEach(key -> {
                String vr = (String)requested.get(key);
                String va = (String)nactual.get(key);
                log.accept(String.format("   %s -> %s instead of %s", key, va != null ? "'" + va + "'" : "<null>", vr != null ? "'" + vr + "'" : "<null>"));
            });
            log.accept("If the difference matters to you, stop the running daemons using mvnd --stop and");
            log.accept("start a new daemon from the current environment by issuing any mvnd build command.");
        }
    }

    static String toCygwin(String path) {
        if (path.length() >= 3 && ":\\".equals(path.substring(1, 3))) {
            try {
                String p = path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
                return ExecHelper.exec((boolean)false, (String[])new String[]{"cygpath", p}).trim();
            }
            catch (IOException e) {
                String root = path.substring(0, 1);
                String p = path.substring(3);
                return "/cygdrive/" + root.toLowerCase(Locale.ROOT) + "/" + p.replace('\\', '/');
            }
        }
        return path;
    }

    static void chDir(String workingDir) throws Exception {
        CLibrary.chdir((String)workingDir);
        System.setProperty("user.dir", workingDir);
        Class<?> fileClass = Class.forName("java.io.File");
        if ((double)JavaVersion.getJavaSpec() >= 11.0) {
            Field fsField = fileClass.getDeclaredField((double)JavaVersion.getJavaSpec() >= 21.0 ? "FS" : "fs");
            fsField.setAccessible(true);
            Object fs = fsField.get(null);
            Field userDirField = fs.getClass().getDeclaredField("userDir");
            userDirField.setAccessible(true);
            userDirField.set(fs, workingDir);
        }
        FileSystem fs = FileSystems.getDefault();
        for (Class<?> fsClass = fs.getClass(); fsClass != Object.class; fsClass = fsClass.getSuperclass()) {
            Field defaultDirectoryField;
            if ("sun.nio.fs.UnixFileSystem".equals(fsClass.getName())) {
                defaultDirectoryField = fsClass.getDeclaredField("defaultDirectory");
                defaultDirectoryField.setAccessible(true);
                String encoding = System.getProperty("sun.jnu.encoding");
                Charset charset = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
                defaultDirectoryField.set(fs, workingDir.getBytes(charset));
                continue;
            }
            if (!"sun.nio.fs.WindowsFileSystem".equals(fsClass.getName())) continue;
            defaultDirectoryField = fsClass.getDeclaredField("defaultDirectory");
            Field defaultRootField = fsClass.getDeclaredField("defaultRoot");
            defaultDirectoryField.setAccessible(true);
            defaultRootField.setAccessible(true);
            Path wdir = Paths.get(workingDir, new String[0]);
            Path root = wdir.getRoot();
            defaultDirectoryField.set(fs, wdir.toString());
            defaultRootField.set(fs, root.toString());
        }
    }

    static void setEnv(Map<String, String> newenv) throws Exception {
        Map<String, String> env = System.getenv();
        for (Field field : env.getClass().getDeclaredFields()) {
            if (!Map.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            Object obj = field.get(env);
            Map map = (Map)obj;
            map.clear();
            map.putAll(newenv);
        }
        if (Os.current() == Os.WINDOWS) {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.clear();
            cienv.putAll(newenv);
        }
    }
}

