/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.nio.file.Path;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ModelProblem;

public class ModelProblemUtils {
    static String toSourceHint(Model model) {
        if (model == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(ModelProblemUtils.toId(model));
        Path pomPath = model.getPomFile();
        if (pomPath != null) {
            buffer.append(" (").append(pomPath).append(')');
        }
        return buffer.toString();
    }

    static String toPath(Model model) {
        Path pomPath;
        String path = "";
        if (model != null && (pomPath = model.getPomFile()) != null) {
            path = pomPath.toAbsolutePath().toString();
        }
        return path;
    }

    static String toId(Model model) {
        if (model == null) {
            return "";
        }
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    static String toId(String groupId, String artifactId, String version) {
        return (groupId != null && !groupId.isEmpty() ? groupId : "[unknown-group-id]") + ":" + (artifactId != null && !artifactId.isEmpty() ? artifactId : "[unknown-artifact-id]") + ":" + (version != null && !version.isEmpty() ? version : "[unknown-version]");
    }

    public static String formatLocation(ModelProblem problem, String projectId) {
        StringBuilder buffer = new StringBuilder(256);
        if (!problem.getModelId().equals(projectId)) {
            buffer.append(problem.getModelId());
            if (!problem.getSource().isEmpty()) {
                if (!buffer.isEmpty()) {
                    buffer.append(", ");
                }
                buffer.append(problem.getSource());
            }
        }
        if (problem.getLineNumber() > 0) {
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append("line ").append(problem.getLineNumber());
        }
        if (problem.getColumnNumber() > 0) {
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append("column ").append(problem.getColumnNumber());
        }
        return buffer.toString();
    }
}

