/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.ftpserver.util.StringUtils;

public class EncryptUtils {
    public static final byte[] encrypt(byte[] source, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        md.update(source);
        return md.digest();
    }

    public static final String encrypt(String source, String algorithm) throws NoSuchAlgorithmException {
        if (source == null) {
            source = "";
        }
        byte[] resByteArray = EncryptUtils.encrypt(source.getBytes(StandardCharsets.UTF_8), algorithm);
        return StringUtils.toHexString(resByteArray);
    }

    public static final String encryptMD5(String source) {
        try {
            return EncryptUtils.encrypt(source, "MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static final String encryptSHA(String source) {
        try {
            return EncryptUtils.encrypt(source, "SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static final String encryptSHA256(String source) {
        try {
            return EncryptUtils.encrypt(source, "SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String encryptSHA512(String source) {
        try {
            return EncryptUtils.encrypt(source, "SHA-512");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

