/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.tomcat5.customizer;

import javax.swing.JSpinner.NumberEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 * Customizer deployment tab.
 *
 * @author  sherold
 */
public class CustomizerDeployment extends javax.swing.JPanel {
    
    private final CustomizerDataSupport custData;
    
    /** Creates new form CustomizerDeployment */
    public CustomizerDeployment(CustomizerDataSupport custData) {
        this.custData = custData;
        initComponents();
        ((NumberEditor) deploymentTimeoutSpinner.getEditor()).getTextField().setColumns(5);
        // working around the issue #111094
        Mnemonics.setLocalizedText(driverDeploymentjCheckBox, NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.driverDeploymentjCheckBox.text"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        driverDeploymentjCheckBox = new javax.swing.JCheckBox();
        deploymentTimeoutSpinner = new javax.swing.JSpinner();
        deplolymentTimeoutLabel = new javax.swing.JLabel();

        driverDeploymentjCheckBox.setModel(custData.getDriverDeploymentModel());
        org.openide.awt.Mnemonics.setLocalizedText(driverDeploymentjCheckBox, org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.driverDeploymentjCheckBox.text")); // NOI18N
        driverDeploymentjCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.driverDeploymentjCheckBox.toolTipText")); // NOI18N
        driverDeploymentjCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        driverDeploymentjCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        deploymentTimeoutSpinner.setModel(custData.getDeploymentTimeoutModel());
        deploymentTimeoutSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutSpinner.tooltip")); // NOI18N
        deploymentTimeoutSpinner.setEditor(new NumberEditor(deploymentTimeoutSpinner, "#"));

        deplolymentTimeoutLabel.setLabelFor(deploymentTimeoutSpinner);
        org.openide.awt.Mnemonics.setLocalizedText(deplolymentTimeoutLabel, org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutLabel.text")); // NOI18N
        deplolymentTimeoutLabel.setToolTipText(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutLabel.tooltip")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(deplolymentTimeoutLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(deploymentTimeoutSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(driverDeploymentjCheckBox))
                .addContainerGap(176, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(deplolymentTimeoutLabel)
                    .addComponent(deploymentTimeoutSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(driverDeploymentjCheckBox)
                .addContainerGap(241, Short.MAX_VALUE))
        );

        driverDeploymentjCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.driverDeploymentjCheckBox.accessible.name")); // NOI18N
        driverDeploymentjCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.driverDeploymentjCheckBox.accessible.description")); // NOI18N
        deploymentTimeoutSpinner.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutSpinner.accessible.name")); // NOI18N
        deploymentTimeoutSpinner.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutSpinner.accessible.description")); // NOI18N
        deplolymentTimeoutLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutLabel.accessible.name")); // NOI18N
        deplolymentTimeoutLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CustomizerDeployment.class, "CustomizerDeployment.deplolymentTimeoutLabel.accessible.description")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel deplolymentTimeoutLabel;
    private javax.swing.JSpinner deploymentTimeoutSpinner;
    private javax.swing.JCheckBox driverDeploymentjCheckBox;
    // End of variables declaration//GEN-END:variables
    
}
