/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class MathEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<String> methodName;
    private final Evaluator<Number> optionalArg;

    public MathEvaluator(Evaluator<Number> subject, Evaluator<String> methodName, Evaluator<Number> optionalArg) {
        this.subject = subject;
        this.methodName = methodName;
        this.optionalArg = optionalArg;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        Number optionalArgValue;
        Number subjectValue;
        String methodNamedValue = this.methodName.evaluate(evaluationContext).getValue();
        if (methodNamedValue == null) {
            return new NumberQueryResult(null);
        }
        if (this.subject != null) {
            subjectValue = this.subject.evaluate(evaluationContext).getValue();
            if (subjectValue == null) {
                return new NumberQueryResult(null);
            }
        } else {
            subjectValue = null;
        }
        if (this.optionalArg != null) {
            optionalArgValue = this.optionalArg.evaluate(evaluationContext).getValue();
            if (optionalArgValue == null) {
                return new NumberQueryResult(null);
            }
        } else {
            optionalArgValue = null;
        }
        try {
            Number executionValue = null;
            if (subjectValue == null) {
                Method method;
                try {
                    method = Math.class.getMethod(methodNamedValue, new Class[0]);
                }
                catch (NoSuchMethodException subjectlessNoMethodException) {
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no subjectless method was found with the name:'" + methodNamedValue + "'", subjectlessNoMethodException);
                }
                if (method == null) {
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no subjectless method was found with the name:'" + methodNamedValue + "'");
                }
                executionValue = (Number)method.invoke(null, new Object[0]);
            } else if (this.optionalArg == null) {
                Method method;
                boolean subjectIsDecimal = subjectValue instanceof Double;
                try {
                    method = Math.class.getMethod(methodNamedValue, subjectIsDecimal ? Double.TYPE : Long.TYPE);
                }
                catch (NoSuchMethodException noOptionalNoMethodException) {
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no method was found matching the passed parameters: name:'" + methodNamedValue + "', one argument of type: '" + (subjectIsDecimal ? "double" : "long") + "'", noOptionalNoMethodException);
                }
                if (method == null) {
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no method was found matching the passed parameters: name:'" + methodNamedValue + "', one argument of type: '" + (subjectIsDecimal ? "double" : "long") + "'");
                }
                executionValue = subjectIsDecimal ? (Number)((Number)method.invoke(null, subjectValue.doubleValue())) : (Number)((Number)method.invoke(null, subjectValue.longValue()));
            } else {
                Method method;
                boolean subjectIsDecimal = subjectValue instanceof Double;
                boolean optionalArgIsDecimal = optionalArgValue instanceof Double;
                boolean convertOptionalToInt = false;
                try {
                    method = Math.class.getMethod(methodNamedValue, subjectIsDecimal ? Double.TYPE : Long.TYPE, optionalArgIsDecimal ? Double.TYPE : Long.TYPE);
                }
                catch (NoSuchMethodException withOptionalNoMethodException) {
                    if (!optionalArgIsDecimal) {
                        try {
                            method = Math.class.getMethod(methodNamedValue, subjectIsDecimal ? Double.TYPE : Long.TYPE, Integer.TYPE);
                        }
                        catch (NoSuchMethodException withOptionalInnerNoMethodException) {
                            throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no method was found matching the passed parameters: name:'" + methodNamedValue + "', first argument type: '" + (subjectIsDecimal ? "double" : "long") + "', second argument type:  'long'", withOptionalInnerNoMethodException);
                        }
                        convertOptionalToInt = true;
                    }
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no method was found matching the passed parameters: name:'" + methodNamedValue + "', first argument type: '" + (subjectIsDecimal ? "double" : "long") + "', second argument type:  'double'", withOptionalNoMethodException);
                }
                if (method == null) {
                    throw new AttributeExpressionLanguageException("Cannot evaluate 'math' function because no method was found matching the passed parameters: name:'" + methodNamedValue + "', first argument type: '" + (subjectIsDecimal ? "double" : "long") + "', second argument type:  '" + (optionalArgIsDecimal ? "double" : "long") + "'");
                }
                executionValue = optionalArgIsDecimal ? (Number)((Number)method.invoke(null, subjectValue, optionalArgValue.doubleValue())) : (Number)(convertOptionalToInt ? (Number)((Number)method.invoke(null, subjectValue, optionalArgValue.intValue())) : (Number)((Number)method.invoke(null, subjectValue, optionalArgValue.longValue())));
            }
            return new NumberQueryResult(executionValue);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AttributeExpressionLanguageException("Unable to calculate math function value", e);
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

