/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;

public class ReftableCompactor {
    private final ReftableWriter writer;
    private final ArrayDeque<ReftableReader> tables = new ArrayDeque();
    private boolean includeDeletes;
    private long reflogExpireMinUpdateIndex = 0L;
    private long reflogExpireMaxUpdateIndex = Long.MAX_VALUE;
    private Instant reflogExpireOldestReflogTime = Instant.EPOCH;
    private ReftableWriter.Stats stats;

    public ReftableCompactor(OutputStream out) {
        this.writer = new ReftableWriter(out);
    }

    public ReftableCompactor setConfig(ReftableConfig cfg) {
        this.writer.setConfig(cfg);
        return this;
    }

    public ReftableCompactor setIncludeDeletes(boolean deletes) {
        this.includeDeletes = deletes;
        return this;
    }

    public ReftableCompactor setReflogExpireMinUpdateIndex(long min) {
        this.reflogExpireMinUpdateIndex = min;
        return this;
    }

    public ReftableCompactor setReflogExpireMaxUpdateIndex(long max) {
        this.reflogExpireMaxUpdateIndex = max;
        return this;
    }

    @Deprecated(since="7.3")
    public ReftableCompactor setReflogExpireOldestReflogTimeMillis(long timeMillis) {
        return this.setReflogExpireOlderThan(timeMillis == Long.MAX_VALUE ? Instant.MAX : Instant.ofEpochMilli(timeMillis));
    }

    public ReftableCompactor setReflogExpireOlderThan(Instant cutTime) {
        this.reflogExpireOldestReflogTime = cutTime;
        return this;
    }

    public void addAll(List<ReftableReader> readers) throws IOException {
        for (ReftableReader r : readers) {
            this.tables.add(r);
        }
    }

    public void compact() throws IOException {
        MergedReftable mr = new MergedReftable(new ArrayList<ReftableReader>(this.tables));
        mr.setIncludeDeletes(this.includeDeletes);
        this.writer.setMaxUpdateIndex(mr.maxUpdateIndex());
        this.writer.setMinUpdateIndex(mr.minUpdateIndex());
        this.writer.begin();
        this.mergeRefs(mr);
        this.mergeLogs(mr);
        this.writer.finish();
        this.stats = this.writer.getStats();
    }

    public ReftableWriter.Stats getStats() {
        return this.stats;
    }

    private void mergeRefs(MergedReftable mr) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RefCursor rc = mr.allRefs();){
            while (rc.next()) {
                this.writer.writeRef(rc.getRef(), rc.getRef().getUpdateIndex());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void mergeLogs(MergedReftable mr) throws IOException {
        if (this.reflogExpireOldestReflogTime == Instant.MAX) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (LogCursor lc = mr.allLogs();){
            while (lc.next()) {
                long updateIndex = lc.getUpdateIndex();
                if (updateIndex > this.reflogExpireMaxUpdateIndex || updateIndex < this.reflogExpireMinUpdateIndex) continue;
                String refName = lc.getRefName();
                ReflogEntry log = lc.getReflogEntry();
                if (log == null) {
                    if (!this.includeDeletes) continue;
                    this.writer.deleteLog(refName, updateIndex);
                    continue;
                }
                PersonIdent who = log.getWho();
                if (who.getWhenAsInstant().compareTo(this.reflogExpireOldestReflogTime) < 0) continue;
                this.writer.writeLog(refName, updateIndex, who, log.getOldId(), log.getNewId(), log.getComment());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

