/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PropertyDependency {
    private final String propertyName;
    private final String displayName;
    private final Set<String> dependentValues;

    public PropertyDependency(String propertyName, String propertyDisplayName) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.displayName = propertyDisplayName == null ? propertyName : propertyDisplayName;
        this.dependentValues = null;
    }

    public PropertyDependency(String propertyName, String propertyDisplayName, Set<String> dependentValues) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.displayName = propertyDisplayName == null ? propertyName : propertyDisplayName;
        this.dependentValues = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(dependentValues)));
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyDisplayName() {
        return this.displayName;
    }

    public Set<String> getDependentValues() {
        return this.dependentValues;
    }

    public String toString() {
        return "PropertyDependency[propertyName=" + this.propertyName + ", displayName=" + this.displayName + ", dependentValues=" + String.valueOf(this.dependentValues) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDependency that = (PropertyDependency)o;
        return Objects.equals(this.getPropertyName(), that.getPropertyName()) && Objects.equals(this.getDependentValues(), that.getDependentValues());
    }

    public int hashCode() {
        return Objects.hash(this.getPropertyName(), this.getDependentValues());
    }
}

