/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.flywaydb.core.api.callback.CallbackEvent;
import org.flywaydb.core.api.callback.GenericCallback;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resolver.script.ScriptMigrationExecutor;

public class ArbitraryScriptCallback<E extends CallbackEvent<E>>
implements GenericCallback<E>,
Comparable<ArbitraryScriptCallback<E>> {
    @Generated
    private static final Log LOG = LogFactory.getLog(ArbitraryScriptCallback.class);
    private final E event;
    private final String description;
    private final ScriptMigrationExecutor scriptMigrationExecutor;

    @Override
    public boolean supports(E event, org.flywaydb.core.api.callback.Context context) {
        return this.event == event;
    }

    @Override
    public boolean canHandleInTransaction(E event, org.flywaydb.core.api.callback.Context context) {
        return this.scriptMigrationExecutor.canExecuteInTransaction();
    }

    @Override
    public void handle(E event, final org.flywaydb.core.api.callback.Context context) {
        LOG.info("Executing script callback: " + event.getId() + (String)(this.description == null ? "" : " - " + this.description) + (this.scriptMigrationExecutor.canExecuteInTransaction() ? "" : " [non-transactional]"));
        try {
            this.scriptMigrationExecutor.execute(new Context(){

                @Override
                public Configuration getConfiguration() {
                    return context.getConfiguration();
                }

                @Override
                public Connection getConnection() {
                    return context.getConnection();
                }
            });
        }
        catch (SQLException e) {
            LOG.error("Script callback \"" + this.description + "\" failed.", e);
        }
    }

    @Override
    public String getCallbackName() {
        return this.description;
    }

    @Override
    public int compareTo(ArbitraryScriptCallback<E> o) {
        int result = this.event.compareTo(o.event);
        if (result == 0) {
            if (this.description == null) {
                return -1;
            }
            if (o.description == null) {
                return 1;
            }
            result = this.description.compareTo(o.description);
        }
        return result;
    }

    @Generated
    public ArbitraryScriptCallback(E event, String description, ScriptMigrationExecutor scriptMigrationExecutor) {
        this.event = event;
        this.description = description;
        this.scriptMigrationExecutor = scriptMigrationExecutor;
    }
}

