/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.cluster.ConnectionState;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.runtime.util.HttpExchangeUtils;

class HealthClusterHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final int NO_RESPONSE_BODY = -1;
    private static final String GET_METHOD = "GET";
    private static final String DELETE_METHOD = "DELETE";
    private static final String STATUS = "Cluster Status: %s\n";
    private final NiFiServer server;

    HealthClusterHttpHandler(NiFiServer server) {
        this.server = Objects.requireNonNull(server);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HttpExchangeUtils.drainRequestBody(exchange);
        String requestMethod = exchange.getRequestMethod();
        try (OutputStream responseBody = exchange.getResponseBody();){
            if (GET_METHOD.contentEquals(requestMethod)) {
                exchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, TEXT_PLAIN);
                ConnectionState connectionState = this.getConnectionState();
                String status = STATUS.formatted(connectionState);
                byte[] response = status.getBytes(StandardCharsets.UTF_8);
                int responseCode = this.getResponseCode(connectionState);
                exchange.sendResponseHeaders(responseCode, response.length);
                responseBody.write(response);
            } else if (DELETE_METHOD.contentEquals(requestMethod)) {
                this.startDecommission();
                exchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, TEXT_PLAIN);
                String status = STATUS.formatted(ConnectionState.OFFLOADING);
                byte[] response = status.getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(202, response.length);
                responseBody.write(response);
            } else {
                exchange.sendResponseHeaders(405, -1L);
            }
        }
    }

    private void startDecommission() {
        DecommissionTask decommissionTask = this.server.getDecommissionTask();
        Thread.ofVirtual().name(DecommissionTask.class.getSimpleName()).start(() -> {
            try {
                decommissionTask.decommission();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private int getResponseCode(ConnectionState connectionState) {
        int responseCode = ConnectionState.CONNECTED == connectionState || ConnectionState.CONNECTING == connectionState ? 200 : 503;
        return responseCode;
    }

    private ConnectionState getConnectionState() {
        ClusterDetailsFactory clusterDetailsFactory = this.server.getClusterDetailsFactory();
        ConnectionState connectionState = clusterDetailsFactory == null ? ConnectionState.UNKNOWN : clusterDetailsFactory.getConnectionState();
        return connectionState;
    }
}

